{$MODE OBJFPC}
unit rlshop;

interface

uses sysutils, vnode, rlitem, rlUI;

type TShopRefillProc = procedure(Level : byte);

type TShop = class(TNode)
   Refill : TShopRefillProc;
   level: byte;
   constructor Create(newSize : byte; newRefill: TShopRefillProc);
   procedure Callback(Index: byte);
   destructor Destroy;
   procedure Clear();
   function getCount: byte;
   function getSize: byte;
   procedure addItem(newItem: TItem);
   function getItem(Index : byte): TItem;
   procedure RemoveItem(Index: byte);
   procedure NilItem(Index: byte);
private
   Items : array of TItem;
   Count: byte;
   Size : byte;
end;

implementation

constructor TShop.Create(newSize: byte; newRefill: TShopRefillProc);
begin
  inherited Create();
  inc(newSize);
  setlength(Items, newSize);
  Size := 0;
  Count := 0;
  Level := 0;
  Refill:=newRefill;
  while Size < newSize do begin Items[Size]:=nil; inc(Size) end;
end;

procedure TShop.Callback(Index: byte);
begin
  if index in [1..count] then
    UI.UpdateStatus(Items[Index])
  else
    UI.UpdateStatus(nil);
end;

function TShop.getItem(Index: byte): TItem;
begin
  exit(Items[Index]);
end;

function TShop.getCount: byte;
begin
  exit(Count);
end;

function TShop.getSize: byte;
begin
  exit(Size-1);
end;

procedure TShop.Clear;
var i: byte;
begin
 if Count = 0 then exit;
  for i:=1 to Count do FreeAndNil(Items[i]);
  Count:=0;
end;

procedure TShop.AddItem(newItem: TItem);
var i:byte;
begin
  for i:= 1 to Size do
    if Items[i]=nil then
    begin
      Items[i]:=newItem;
      if i>Count then Count:=i;
      exit;
    end;
end;

procedure TShop.RemoveItem(Index: byte);
begin
  if Items[Index]=nil then exit;
  while Index<Count do
  begin
    Items[Index]:=Items[Index+1];
    inc(Index);
  end;
  Items[Index]:=nil;
  dec(Count);
end;

procedure TShop.NilItem(Index: byte);
begin
  Items[Index]:=nil;
end;

destructor TShop.Destroy;
begin
  FreeAndNil(Items);
  inherited destroy;
end;

end.

