unit rllua;
{$mode objfpc}{$H+}
interface

uses SysUtils, vrltools, vlua, rlnpc, rlitem, rlthing, rlLevel, rlgobj, vdf, vds, vluastate;

var LuaPlayerX : Byte = 2;
    LuaPlayerY : Byte = 2;

type

{ TRLLua }

TRLLua = class(TLua)
       constructor Create;
       destructor Destroy; override;
       function RunHook(const TableName: Ansistring; const Index: DWord; const Name: Ansistring; const Args: array of const ) : Variant;
       procedure RegisterPlayer(Thing: TThing);
       procedure LuaError;
     public
       Level   : TLevel;
     private
       CoreData: TVDataFile;
     private
       procedure ReadData( const DataFile : AnsiString );
     end;

{ TRLLuaState }

TRLLuaState = object(TLuaState)
end;


implementation

uses lua, vluatools, vdebug, voutput, vinput, rlglobal, rlgame, diablout, strutils,
     vutil, rlplayer, rlgen, rlcell, rlui, rlshopinv;

var ThisLua : TRLLua;

function lua_diablorl_require( L: Plua_State ) : Integer; cdecl;
var Arg      : AnsiString;
    Module   : AnsiString;
    Path     : AnsiString;
begin
  if lua_gettop(L) <> 1 then ThisLua.Error('Require has wrong amount of parameters!');
  Arg := lua_tostring( L, 1 );
  if ThisLua.ModuleNames.Exists(Arg) then Exit(0);

  Path := Arg;
  Module := ExtractDelimited( 1, Path, [':'] );
  Delete( Path, 1, Length( Module ) + 1 );

  Path := Path+'.lua';
  if not FileExists(Path) then
  begin
    Path := 'lua'+PathDelim+Path;
    if not FileExists(Path) then
      raise ELuaException.Create('require : File "'+Path+'" not found!');
  end;
  ThisLua.LoadFile(Path);

  ThisLua.ModuleNames[ Arg ] := True;
  Exit( 0 );
end;

// ************************************************************************ //
// ************************************************************************ //

function lua_endgame(L: Plua_State): Integer; cdecl;
begin
  Result := 0;
  GameEnd:=true;
  Dec(Game.Player.SpeedCount,50);
end;

function lua_selladria(L: Plua_State): Integer; cdecl;
begin
  Result := 0;
  DiabloSell([TYPE_POTION, TYPE_SCROLL, TYPE_STAFF, TYPE_BOOK]);
end;

function lua_identify(L: Plua_State): Integer; cdecl;
begin
  if lua_gettop(L) = 0 then DiabloIdentify(true)
  else DiabloIdentify(lua_toBoolean(L, 1));
  Result := 0;
end;

function lua_repair(L: Plua_State): Integer; cdecl;
begin
  if lua_gettop(L) = 0 then DiabloRepair(true)
  else DiabloRepair(lua_toBoolean(L, 1));
  Result := 0;
end;

function lua_recharge(L: Plua_State): Integer; cdecl;
begin
  if lua_gettop(L) = 0 then DiabloRecharge(true)
  else DiabloRecharge(lua_toBoolean(L, 1));
  Result := 0;
end;

function lua_sellgriswold(L: Plua_State): Integer; cdecl;
begin
  Result := 0;
  DiabloSell([TYPE_WEAPON, TYPE_ARMOR, TYPE_SHIELD, TYPE_HELM, TYPE_RING, TYPE_AMULET, TYPE_BOW]);
end;

procedure TRLLua.LuaError;
begin
  UI.Msg('LuaError: '+ErrorStr);
  Log('LuaError: '+ErrorStr);
end;

procedure TRLLua.ReadData(const DataFile: AnsiString);
begin
  Log('Loading data from @1...',[DataFile]);
  CoreData := TVDataFile.Create(DataFile);
  RegisterDataFile(CoreData,'diablorl');
  LoadStream(CoreData,'','const.inc');
  LoadStream(CoreData,'','core.lua');
  LoadStream(CoreData,'','main.lua');
  Log('@1 loaded.',[DataFile]);
end;

function lua_log(L: Plua_State): Integer; cdecl;
begin
  if lua_gettop(L) = 0 then Exit(0);
  Log('Lua : ' + lua_tostring(L, 1));
  Result := 0;
end;


procedure TRLLua.RegisterPlayer(Thing: TThing);
begin
  lua_getglobal(LuaState,'player');

{  lua_pushnil( LuaState );
  lua_setfield( LuaState, -2, '__ptr' );
  lua_pushnil( LuaState );
  lua_setfield( LuaState, -2, 'flags' );
  lua_pushnil( LuaState );
  lua_setfield( LuaState, -2, 'eq' );
  lua_pushnil( LuaState );
  lua_setfield( LuaState, -2, 'inv' );}

  lua_rawgeti(LuaState, LUA_REGISTRYINDEX, Thing.GetLuaIndex());
  lua_shallowmerge(LuaState,-2);
  lua_setglobal(LuaState,'player');
  lua_pop(LuaState,1);

  TPlayer.RegisterLuaAPI( Self );
end;


constructor TRLLua.Create;
var Count     : DWord;
begin
  inherited Create;

  CoreData := nil;
  ThisLua := Self;

  for Count := 0 to 15 do Variables[ColorNames[Count]] := Count;

  RegisterCoordClass( LuaState );
  RegisterAreaClass( LuaState );

//  AddVar('VERSION',Version);
  Register('log',        @lua_log);

  Register('endgame', @lua_endgame);
  Register('sellgriswold', @lua_sellgriswold);
  Register('selladria', @lua_selladria);
  Register('identify',  @lua_identify);
  Register('recharge', @lua_recharge);
  Register('repair',   @lua_repair);

  TGameUI.RegisterLuaAPI( Self );
  TGameObject.RegisterLuaAPI( Self );
  TThing.RegisterLuaAPI( Self );
  TItem.RegisterLuaAPI( Self );
  TNPC.RegisterLuaAPI( Self );
  TShopInventory.RegisterLuaAPI( Self );
  TLevel.RegisterLuaAPI( Self );

  if GodMode then
  try
    Register('require', @lua_diablorl_require);
    LoadFile('const.inc');
    LoadFile('lua/core.lua');
    LoadFile('lua/main.lua');
  except
    on e : ELuaException do
      CritError( e.Message );
  end
  else
    ReadData('diablorl.mpq');


end;

function TRLLua.RunHook(const TableName: Ansistring; const Index: DWord;
  const Name: Ansistring; const Args: array of const ) : Variant;
var Count : DWord;
var State : TLuaState;
begin
  State.Init( LuaState );
  try
    with TLuaTable.Create( Self, TableName, Index ) do
    try
      RunHook := State.CallFunction( Name, Args, -1 );
    finally
      Free;
    end;
  except
    on e : Exception do
    begin
      CritError('Hook '+TableName+'['+IntToStr(Index)+'].'+Name+' failed : '+e.Message);
    end;
  end;
end;

destructor TRLLua.Destroy;
begin
  FreeAndNil(CoreData);
  inherited Destroy;
end;

{ TRLLuaState }

end.
