// @abstract(Globals for RL Core)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @created(January 17, 2005)
// @lastmod(January 17, 2009)
//
// This unit holds global definiotions for the RL. No functions nor
// procedures should be here -- just constants and variables.

unit rlglobal;
interface
uses sysutils, vrltools, vutil, vnode, vds, voutput, vinput, vini, vtextut;

type TNameOutputType = (TheName,AName,PlainName,CTheName,CAName,InvName,Status1,Status2,BuyName, SpellName);
type TPriceType  = (COST_BUY, COST_SELL, COST_REPAIR, COST_RECHARGE);

type TIntAssocArray = specialize TAssocArray<LongInt>;

type TAITypeSet = set of byte;

type TLightFlag  = ( lfLighted, lfBlocked, lfVisited );
     TLightFlags = set of TLightFlag;
     TTextAlign  = (AlignLeft, AlignCenter, AlignRight);

const FILETYPE_LUA = 1;

const CLASSTYPE_GAME   = 1;
      CLASSTYPE_LEVEL  = 2;
      CLASSTYPE_ITEM   = 3;
      CLASSTYPE_NPC    = 4;
      CLASSTYPE_PLAYER = 5;

const // Properties
{$INCLUDE ../bin/const.inc}

const AIMonster = [AIZombie..AILeoric];

const EquipableType = [TYPE_HELM,TYPE_ARMOR,TYPE_SHIELD,TYPE_STAFF,TYPE_BOW,TYPE_WEAPON,TYPE_RING,TYPE_AMULET];

const MapSizeX  = 100;
      MapSizeY  = 70;

      MapPosX   : byte = 1;
      MapPosY   = 2;

      MaxItems  = 60;
      MaxBeings = 60;
      MaxSpells = 40;
      MaxQuests = 64;
      MaxSpellLvl = 20;
      MaxShops  = 16;
      MaxLevels = 16;



      MaxQuickSkills = 4;

      GodMode     : Boolean = False;
      GameEnd     : Boolean = False;
      LevelChange : Boolean = False;

      const
      COMMAND_WALKNORTH = 2;
      COMMAND_WALKSOUTH = 3;
      COMMAND_WALKEAST  = 4;
      COMMAND_WALKWEST  = 5;
      COMMAND_WALKNE    = 6;
      COMMAND_WALKSE    = 7;
      COMMAND_WALKNW    = 8;
      COMMAND_WALKSW    = 9;
      COMMAND_WAIT      = 10;
      COMMAND_PICKUP    = 11;
      COMMAND_DROP      = 12;
      COMMAND_INVENTORY = 13;
      COMMAND_EQUIPMENT = 14;
      COMMAND_ACT       = 15;
      COMMAND_CAST      = 16;
      COMMAND_LOOK      = 17;
      COMMAND_FIRE      = 18;
      COMMAND_USE       = 19;
      COMMAND_PLAYERINFO= 21;
      COMMAND_SAVE      = 22;
      COMMAND_RUNMODE   = 23;
      COMMAND_STAIRSDOWN= 24;
      COMMAND_STAIRSUP  = 25;
      COMMAND_QUICKSLOT = 26;
      COMMAND_ESCAPE    = 27;
      COMMAND_JOURNAL   = 28;
      COMMAND_SPELLBOOK = 30;
      COMMAND_SPELLS    = 31;
      COMMAND_CWIN      = 32;
      COMMAND_SOUNDVOLUP= 35;
      COMMAND_SOUNDVOLDN= 36;
      COMMAND_MUSICVOLUP= 37;
      COMMAND_MUSICVOLDN= 38;

      COMMAND_GOD1 = 101;
      COMMAND_GOD2 = 102;
      COMMAND_GOD3 = 103;
      COMMAND_GOD4 = 104;
      COMMAND_GOD5 = 105;

      COMMANDS_MOVE = [COMMAND_WALKNORTH..COMMAND_WALKSW];

function RandRange(RangeMin,RangeMax : LongInt) : LongInt;
function CapLet(name : string) : string;
function DPad(str : string; len : Byte) : string;

const ExpTable : array[1..50] of DWord = (
      0,          2000,       4620,       8040,       12489,
      18258,      25712,      35309,      47622,      63364,
      83419,      108876,     141086,     181683,     231075,
      313656,     424068,     571190,     766597,     1025154,
      1366227,    1814568,    2401895,    3168651,    4166200,
      5459523,    7130496,    9281874,    12042092,   15571031,
      20066900,   25744405,   32994399,   42095202,   53525811,
      67831218,   85670061,   107834823,  135274799,  196122009,
      210720231,  261657253,  323800420,  399335440,  490808349,
      601170414,  733825617,  892680222,  1082908612, 1310707109
      );


implementation

uses rlui;

function DPad(str : string; len : Byte) : string;
begin
  if Output.Length(str) = len then Exit(str);
  if Output.Length(str) > len then
  begin
    while Output.Length(str) > Len do
      Delete(str,Length(str),1);
    Exit(str);
  end;
  while Output.length(str) < len do str := str + ' ';
  Exit(str);
end;

function CapLet(name : string) : string;
begin
  name[1] := UpCase(name[1]);
end;

function RandRange(RangeMin,RangeMax : LongInt) : LongInt;
begin
  if RangeMin > RangeMax then Exit(RangeMin)
                         else Exit(Random(RangeMax-RangeMin+1)+RangeMin);
end;

end.
