unit rlconfig;

interface

uses Classes, SysUtils, vluaconfig;

type

TDiabloConfig = class(TLuaConfig)
  constructor Create( const Filename : AnsiString );
  function RunKey( Key : Byte ) : Variant;
end;

implementation

uses vsystems, vinput, lua, vlua, vluastate, rlui, rlglobal, rlgame;

function lua_command_messages(L: PLua_State): Integer; cdecl;
begin
  UI.ShowRecent();
  Result := 0;
end;

function lua_command_help(L: PLua_State): Integer; cdecl;
begin
  UI.ShowManual();
  Result := 0;
end;

function lua_command_quit(L: PLua_State): Integer; cdecl;
begin
  GameEnd := true;
  Game.Player.SpeedCount -= 50;
  Result := 0;
end;

function lua_command_screenshot(L: PLua_State): Integer; cdecl;
var State: TLuaState;
begin
  State.Init(L);
  UI.ScreenShot( State.ToBoolean( 1 ) );
  Result := 0;
end;

function lua_command_quick_slot(L: PLua_State): Integer; cdecl;
var State: TLuaState;
begin
  State.Init(L);
  Game.Player.useQuickSlot( State.ToInteger( 1 ) );
  Result := 0;
end;

function lua_command_quick_spell(L: PLua_State): Integer; cdecl;
var State: TLuaState;
begin
  State.Init(L);
  Game.Player.useQuickSkill( State.ToInteger( 1 ) );
  Result := 0;
end;

constructor TDiabloConfig.Create( const Filename : AnsiString );
begin
  inherited Create(FileName);
  EntryFeed('Keybindings', @Input.RegisterCommandVariant);
  UI.SetSoundVolume(Entries['SoundVolume']);
  UI.SetMusicVolume(Entries['MusicVolume']);
  //lua bounds
  Lua.SetVariable('VERSION', Version);
  Lua.SetTableFunction( 'command', 'messages', @lua_command_messages );
  Lua.SetTableFunction( 'command', 'quit', @lua_command_quit );
  Lua.SetTableFunction( 'command', 'help', @lua_command_help );
  Lua.SetTableFunction( 'command', 'screenshot', @lua_command_screenshot );
  Lua.SetTableFunction( 'command', 'quick_slot', @lua_command_quick_slot );
  Lua.SetTableFunction( 'command', 'quick_spell', @lua_command_quick_spell );
  TGameUI.RegisterLuaAPI( Self.Lua );
end;

function TDiabloConfig.RunKey( Key : Byte ) : Variant;
begin
  Exit( Entries['Keybindings.'+Input.VCodeToString(Input.LastKey)] );
end;

end.
