{$MODE OBJFPC}
// @abstract(Level Cell for RL Core)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @created(March 6, 2005)
// @lastmod(March 6, 2005)
//
// This unit hold's cell data;

unit rlcell;
interface
uses vutil, vds;

type TIDAssocArray = specialize TAssocArray<Byte>;

type TCellData = record
       color   : Byte;
       pic     : char;
       pass    : boolean;
       bvis    : boolean;
       bproj   : boolean;
       canch   : boolean;
       actto   : byte;
       special : byte;
       id      : AnsiString;
       name    : AnsiString;
     end;


var Cells : array[1..255] of TCellData;

const CellID : TIDAssocArray = nil;

procedure LoadCells;

var
CELL_FLOOR         : Byte;
CELL_WALL          : Byte;
CELL_WALL_BLOOD    : Byte;
CELL_FLOOR_BLOOD   : Byte;
CELL_CELL_WALL     : Byte;
CELL_DOOR_CLOSED   : Byte;
CELL_DOOR_OPEN     : Byte;
CELL_DOOR_BLOCKED  : Byte;
CELL_DOOR_CLOSED_2 : Byte;
CELL_GRATE         : Byte;

CELL_STAIR_DOWN           : Byte;
CELL_STAIR_DOWN_SPECIAL   : Byte;
CELL_STAIR_DOWN_CATACOMBS : Byte;
CELL_STAIR_UP             : Byte;
CELL_STAIR_UP_SPECIAL     : Byte;
CELL_STAIR_UP_CATACOMBS   : Byte;

CELL_CORPSE        : Byte;
CELL_CORPSE_BLOOD  : Byte;
CELL_BONES         : Byte;

CELL_MARKER        : Byte;
CELL_TOWN_PORTAL   : Byte;



implementation
uses sysutils, variants, vlua, vdebug,rlglobal, rlgame;

procedure LoadCells;
var CID       : AnsiString;
    CellCount : Word;
    Count     : Word;
begin
  CellID := TIDAssocArray.Create;
  for Count := 1 to 255 do Cells[Count].id := '';

  CellCount := Game.Lua.Table['cells','__counter'];

  for Count := 1 to CellCount do
  begin
    CID := Game.Lua.IndexedTable['cells', Count, 'id'];
    CellID[CID]     := Count;
    Cells[Count].id := CID;
  end;

  for Count := 1 to CellCount do
  with TLuaTable.Create( Game.Lua, 'cells', Count ) do
  try
    with Cells[Count] do
    begin
      color   := GetNumber('color');
      pic     := GetString('pic')[1];
      pass    := GetBoolean('passable');
      bvis    := GetBoolean('blockvision');
      canch   := GetBoolean('canchange');
      name    := GetString('name');
      if Defined('activates') then
      begin
        CID := GetString('activates');
        if not CellID.Exists(CID) then CritError('unknown cell -- '+CID);
        actto := CellID[CID];
      end
      else
        actto := 0;

      special := GetNumber('special');
      bproj   := bvis;
    end;
  finally
    Free;
  end;

  CELL_MARKER        := CellID['marker'];
  CELL_FLOOR         := CellID['floor'];
  CELL_WALL          := CellID['stone_wall'];
  CELL_WALL_BLOOD    := CellID['bloody_stone_wall'];
  CELL_FLOOR_BLOOD   := CellID['bloody_floor'];
  CELL_CELL_WALL     := CellID['cell_wall'];
  CELL_DOOR_CLOSED   := CellID['closed_door'];
  CELL_DOOR_OPEN     := CellID['open_door'];
  CELL_DOOR_BLOCKED  := CellID['open_blocked_door'];
  CELL_DOOR_CLOSED_2 := CellID['closed_door_2'];
  CELL_GRATE         := CellID['grate'];

  CELL_STAIR_DOWN    := CellID['stairs_down'];
  CELL_STAIR_DOWN_SPECIAL := CellID['stairs_down_special'];
  CELL_STAIR_DOWN_CATACOMBS := CellID['stairs_down_catacombs'];
  CELL_STAIR_UP      := CellID['stairs_up'];
  CELL_STAIR_UP_SPECIAL := CellID['stairs_up_special'];
  CELL_STAIR_UP_CATACOMBS := CellID['stairs_up_catacombs'];
  CELL_CORPSE        := CellID['corpse'];
  CELL_CORPSE_BLOOD  := CellID['bloody_corpse'];
  CELL_BONES         := CellID['bones'];

  CELL_TOWN_PORTAL   := CellID['shimmering_portal'];

end;

finalization

  FreeAndNil( CellID );

end.

