program mpq;
{$mode objfpc}{$H+}
uses Classes, SysUtils, vpkg, vdf, vutil;

var MPQFile   : TVDataCreator;
    SearchRec : TSearchRec;

//{$R *.res}

// This constant comes from rlglobal.pas
// "uses rlglobal" causes compile errors
const FILETYPE_LUA = 1;

begin
  MPQFile := TVDataCreator.Create('diablorl.mpq');
  try
    MPQFile.AddLuaFile('functions.lua',FILETYPE_LUA,[vdfCompressed]);
    MPQFile.AddLuaFile('const.inc',FILETYPE_LUA,[vdfCompressed]);

    MPQFile.Add('lua','*.lua',@MPQFile.AddLuaFile,FILETYPE_LUA,[vdfCompressed]);
    MPQFile.Add('lua' + PathDelim + 'items','*.lua',@MPQFile.AddLuaFile,FILETYPE_LUA,[vdfCompressed],'items');
    MPQFile.Add('lua' + PathDelim + 'npc','*.lua',@MPQFile.AddLuaFile,FILETYPE_LUA,[vdfCompressed],'npc');
    MPQFile.Add('lua' + PathDelim + 'levels','*.lua',@MPQFile.AddLuaFile,FILETYPE_LUA,[vdfCompressed],'levels');
  except
    on e : Exception do
      Writeln( e.Message );
  end;
  FreeAndNil(MPQFile);

  if FindFirst('*.*__compiled',faAnyFile,SearchRec) = 0 then
  repeat
    DeleteFile(SearchRec.Name);
  until (FindNext(SearchRec) <> 0);
  FindClose(SearchRec);
end.


