{$MODE OBJFPC}
// @abstract(Diablo specific unit)
// @author(Kornel Kisielewicz <admin@chaosforge.org>)
// @created(March 8, 2005)
// @lastmod(January 27, 2009)

unit diablout;

interface

uses vrltools, rlglobal, vutil, rlnpc, rlitem, rllevel, rlui, rlshopinv;

procedure DiabloIdentify(Cain: boolean = False);
procedure DiabloRepair(Griswold: boolean = False);
procedure DiabloRecharge(Adria: boolean = False);
procedure DiabloSell(Items: TFlags);

implementation

uses SysUtils, vdebug, vds, vmath, voutput, vinput, rlgame, rlplayer, rllua, vlua, lua, rlshop,  variants;

procedure DiabloIdentify(Cain: boolean = False);
var
  Choice: byte;
  Window: TShopWindow;
  Info: TItemWindow;
  Item : TItem;
  Shop : TShop;
begin
  repeat
    Shop:=TShop.Create(ITEMS_INV+ITEMS_EQ, nil);

    for Choice := 1 to ITEMS_EQ do
      if game.player.Eq[choice] <> nil then
        if ifUnknown in game.player.Eq[choice].Flags then
          Shop.AddItem(game.player.Eq[choice]);

    for Choice := 1 to ITEMS_INV do
      if game.player.Inv[choice] <> nil then
        if ifUnknown in game.player.Inv[choice].Flags then
          Shop.AddItem(game.player.Inv[choice]);

    if Cain then
    begin
      Window := TShopWindow.Create(UI.VUI, 'Identify an Item (' + IntToStr(Game.Player.getGold) + ' gold left)', @Shop.Callback);
      if Shop.getCount = 0 then
        TContent.Create(Window,3,Padded('',15)+'You have nothing to identify.')
      else
        for Choice := 1 to Shop.getCount do
          Window.Add(DPad(Shop.getItem(choice).GetName(PlainName),57)+' 100',Shop.getItem(choice).InvColor);
    end
    else
    begin
      Window := TShopWindow.Create(UI.VUI, 'Identify an Item', @Shop.Callback);
      if Shop.getCount = 0 then
        TContent.Create(Window,3,Padded('',15)+'You have nothing to identify.')
      else
        for Choice := 1 to Shop.getCount do
          Window.Add(Shop.getItem(choice).GetName(PlainName),Shop.getItem(choice).InvColor);
    end;

    Choice := Window.Run;

    if Choice <> 0 then
    begin
      Item := Shop.getItem(choice);
      if (Game.Player.getGold < 100) and Cain then
        UI.Msg('Cain says "Sorry ' + Game.Player.KlassSalutation +
          ', you have not enough money."')
      else
      begin
        if Cain then
          Game.Player.removeGold(100);
        Item.Identify;
        UI.UpdateStatus(Item);
        Info:=TItemWindow.Create(UI.VUI, Item, '');
        Info.Run;
        FreeAndNil(Info);
      end;
    end;
    FreeAndNil(Window);
    FreeAndNil(Shop);
  until (Choice = 0) or (not Cain);
end;

procedure DiabloRepair(Griswold: boolean = False);
var
  Choice: byte;
  Window: TShopWindow;
  Item : TItem;
  Shop : TShop;

begin
  repeat
    Shop:=TShop.Create(ITEMS_INV+ITEMS_EQ, nil);
    for choice := 1 to ITEMS_EQ do
    begin
      Item:= game.player.Eq[choice];
      if Item = nil then continue;
      if (Item.IType in [TYPE_WEAPON, TYPE_BOW, TYPE_STAFF,TYPE_ARMOR, TYPE_HELM, TYPE_SHIELD]) then
        if (Griswold and (Item.getPrice(COST_REPAIR)>0)) or
          ((not Griswold)and(Item.Dur<Item.DurMax)) then
            Shop.AddItem(Item);
    end;
    for choice := 1 to ITEMS_INV do
    begin
      Item:= game.player.inv[choice];
      if Item = nil then continue;
      if (Item.IType in [TYPE_WEAPON, TYPE_BOW, TYPE_STAFF,TYPE_ARMOR, TYPE_HELM, TYPE_SHIELD]) then
        if (Griswold and (Item.getPrice(COST_REPAIR)>0)) or
          ((not Griswold)and(Item.Dur<Item.DurMax)) then
            Shop.AddItem(Item);
    end;

    if Griswold then
    begin
      Window := TShopWindow.Create(UI.VUI, 'Repair an Item (' + IntToStr(Game.Player.getGold) + ' gold left)', @Shop.Callback);
      if Shop.getCount = 0 then
        TContent.Create(Window,3,Padded('',15)+'You have no repairable items.')
      else
        for Choice := 1 to Shop.getCount do
          Window.Add(DPad(Shop.getItem(choice).GetName(PlainName),55)+inttostr(Shop.getItem(choice).getPrice(COST_REPAIR)),Shop.getItem(choice).InvColor);
    end
    else
    begin
      UI.PlaySound('sound/sfx/misc/cast6.wav');
      Window := TShopWindow.Create(UI.VUI, 'Repair an Item', @Shop.Callback);
      if Shop.getCount = 0 then
        TContent.Create(Window,3,Padded('',15)+'You have no repairable items.')
      else
        for Choice := 1 to Shop.getCount do
          Window.Add(Shop.getItem(choice).GetName(PlainName),Shop.getItem(choice).InvColor);
    end;

    Choice := Window.Run;

    if Choice <> 0 then
    begin
      Item := Shop.getItem(choice);
      if Griswold and (Game.Player.getGold < Item.getPrice(COST_REPAIR)) then
        UI.Msg('Griswold says "Sorry ' + Game.Player.KlassSalutation +
          ', you have not enough money."')
      else
        if Griswold then
        begin
          Game.Player.removeGold(Item.getPrice(COST_REPAIR));
          Item.Repair;
          UI.Msg('Griswold repaired ' + Item.GetName(AName));
        end
        else
        begin
          Item.Repair(Game.Player.Level);
          dec(Game.Player.SpeedCount, Game.Player.SpdMag);
          UI.Msg('You repaired ' + Item.GetName(AName));
        end;
    end;
    FreeAndNil(Window);
    FreeAndNil(Shop);
  until (Choice = 0);
end;

procedure DiabloSell(Items: TFlags);
var
  Choice: byte;
  Window: TShopWindow;
  Item : TItem;
  Shop : TShop;
begin
  repeat
    Shop:=TShop.Create(ITEMS_INV+ITEMS_EQ, nil);
    for choice := 1 to ITEMS_INV do
    begin
      Item:= game.player.inv[choice];
      if Item = nil then continue;
      if (Item.IType in Items) then
        Shop.AddItem(Item);
    end;

    Window := TShopWindow.Create(UI.VUI, 'Selling Items', @Shop.Callback);
    if Shop.getCount = 0 then
      TContent.Create(Window,3,Padded('',15)+'You have nothing to sell.')
    else
      for Choice := 1 to Shop.getCount do
          Window.Add(DPad(Shop.getItem(choice).GetName(PlainName),55)+inttostr(Shop.getItem(choice).getPrice(COST_SELL)),Shop.getItem(choice).InvColor);

    Choice := Window.Run;

    if Choice>0 then
    begin
      Item := Shop.getItem(choice);
      Game.Player.AddGold(Item.getPrice(COST_SELL));
      UI.Msg('You sold ' + Item.GetName(AName) + ' for ' + IntToStr(Item.getPrice(COST_SELL)) + ' gold pieces');
      for Choice := 1 to ITEMS_INV do
        if game.player.Inv[Choice] = Item then
        begin
          FreeAndNil(game.player.Inv[Choice]);
          break;
        end;
    end;
    FreeAndNil(Window);
    FreeAndNil(Shop);
  until (Choice = 0);
end;

procedure DiabloRecharge(Adria: boolean = False);
var
  Choice: byte;
  Window: TShopWindow;
  Item : TItem;
  Shop : TShop;

begin
  if (not Adria) then UI.PlaySound('sound/sfx/misc/cast6.wav');
  repeat
    Shop:=TShop.Create(ITEMS_INV+ITEMS_EQ, nil);
    for choice := 1 to ITEMS_EQ do
    begin
      Item:= game.player.Eq[choice];
      if Item = nil then continue;
      if (Item.IType = TYPE_STAFF) and (Item.Spell>0) then
        if (Adria and (Item.getPrice(COST_RECHARGE)>0)) or
          ((not Adria)and(Item.Charges<Item.ChargesMax)) then
            Shop.AddItem(Item);
    end;
    for choice := 1 to ITEMS_INV do
    begin
      Item:= game.player.inv[choice];
      if Item = nil then continue;
      if (Item.IType = TYPE_STAFF) and (Item.Spell>0) then
        if (Adria and (Item.getPrice(COST_RECHARGE)>0)) or
          ((not Adria)and(Item.Charges<Item.ChargesMax)) then
            Shop.AddItem(Item);
    end;

    if Adria then
    begin
      Window := TShopWindow.Create(UI.VUI, 'Recharge an Item (' + IntToStr(Game.Player.getGold) + ' gold left)', @Shop.Callback);
      if Shop.getCount = 0 then
        TContent.Create(Window,3,Padded('',15)+'You have no rechargeable items.')
      else
        for Choice := 1 to Shop.getCount do
          Window.Add(DPad(Shop.getItem(choice).GetName(PlainName),55)+inttostr(Shop.getItem(choice).getPrice(COST_recharge)),Shop.getItem(choice).InvColor);
    end
    else
    begin
      Window := TShopWindow.Create(UI.VUI, 'Recharge an Item', @Shop.Callback);
      if Shop.getCount = 0 then
        TContent.Create(Window,3,Padded('',15)+'You have no rechargeable items.')
      else
        for Choice := 1 to Shop.getCount do
          Window.Add(Shop.getItem(choice).GetName(PlainName),Shop.getItem(choice).InvColor);
    end;

    Choice := Window.Run;

    if Choice <> 0 then
    begin
      Item := Shop.getItem(choice);
      if Adria and (Game.Player.getGold < Item.getPrice(COST_RECHARGE)) then
        UI.Msg('Adria says "Sorry ' + Game.Player.KlassSalutation +
          ', you have not enough money."')
      else
        if Adria then
        begin
          Game.Player.removeGold(Item.getPrice(COST_recharge));
          Item.recharge;
          UI.Msg('Adria recharged ' + Item.GetName(AName));
        end
        else
        begin
          Item.recharge(Game.Player.Level);
          dec(Game.Player.SpeedCount, Game.Player.SpdMag);
          if Item.ChargesMax > 0 then
            UI.Msg('You recharged ' + Item.GetName(AName))
          else UI.Msg('You drained ' + Item.GetName(AName));
        end;
    end;
    FreeAndNil(Window);
    FreeAndNil(Shop);
  until (Choice = 0);
end;

end.

