-- Skills --

Spell{
	name     = "Repair Items",
	page     = 0,
	type     = 0,
	effect   = SPELL_SCRIPT,
	color    = LIGHTGRAY,
	townsafe = true,
	script   = function(slvl)
	    repair(false)
	end,
}

Spell{
	name     = "Recharge Staves",
	page     = 0,
	type     = 0,
	effect   = SPELL_SCRIPT,
	color    = LIGHTGRAY,
	townsafe = true,
	script   = function(slvl)
	    recharge(false)
	end,
}

-- Scroll only spells --

Spell{
	name     = "Identify",
	page     = 0,
	type     = 0,
	cost     = function(slvl) return math.max(13 - 2 * (slvl-1),1) end,
	magic	 = 23,
	effect   = SPELL_SCRIPT,
	color    = LIGHTGRAY,
	townsafe = true,
	sound1   = 'cast6',
	script   = function(slvl)
	    identify(false)
	end,

	scroll_price = 100,
	scroll_level = 1,

	staff_chargesmin = 8,
	staff_chargesmax = 12,
}

Spell{
	name     = "Infravision",
	page     = 0,
	type     = 0,
	cost     = function(slvl) return math.max(40 - 5 * (slvl-1),1) end,
	magic	 = 36,
	effect   = SPELL_SCRIPT,
	color    = LIGHTMAGENTA,
	sound1   = 'cast8',
	sound2   = 'infravis',
	script   = function(slvl, caster, target)
		caster.flags[ nfInfravision ] = true
		ui.msg('Your senses were magically enhanced.')
		--TODO:
		--this spell should last { 7920*math.floor((9/8)^slvl) } game ticks
	end,

    scroll_price = 600,
	scroll_level = 8,
	scroll_mag   = 23,
}

-- Page 1 spells

Spell{
	name     = "Firebolt",
	page     = 1,
	type     = DAMAGE_FIRE,
	dmin     = function(slvl, caster) return 1 + slvl + math.floor(caster.mag / 8) end,
	dmax     = function(slvl, caster) return 10 + slvl + math.floor(caster.mag / 8) end,
	cost     = function(slvl) return math.max(6 - math.floor((slvl-1)*0.5),3) end,
	magic    = 15,
	target   = SPELL_TARGET,
	effect   = SPELL_BOLT,
	color    = LIGHTRED,
	picture  = "*",
	sound1   = 'cast2',
	sound2   = 'fbolt1',

	book_price = 1000,
	book_level = 1,

	staff_level = 1,
	charge_cost = 10,
	charges_min = 40,
	charges_max = 80,
}
--[[
-- this is going to be a real bitch to code, asynch TAnimation code needed
Spell{
	name     = "Charged Bolt",
	page     = 1,
	type     = DAMAGE_LIGHTNING,
	dmin     = function(slvl) return 1 end,
	dmax     = function(slvl, caster) return 1 + math.floor(caster.mag / 4) end,
	count    = function(slvl) return 4 + math.floor(slvl / 2) end,
	cost     = function(slvl) ,
	magic    = 25,
	color    = YELLOW,
	target   = SPELL_DIRECTION,
	effect   = SPELL_CHARGED,
	picture  = "*",
	sound1   = 'cast2',
	sound2   = 'cbolt',

	book_price   = 1000,
	book_level   = 1,

	staff_level = 1,
	charge_cost = 10,
	charges_min = 40,
	charges_max = 80,
}
]]--

Spell{
	name     = "Holy Bolt",
	page     = 1,
	type     = DAMAGE_HOLY,
	dmin     = function(slvl, caster) return 9 + caster.level end,
	dmax     = function(slvl, caster) return 18 + caster.level end,
	cost     = function(slvl) return math.max(8 - slvl,3) end,
	magic    = 20,
	target   = SPELL_TARGET,
	effect   = SPELL_BOLT,
	color    = WHITE,
	picture  = "*",
	sound1   = 'cast2',
	sound2   = 'holybolt',

	book_price = 1000,
	book_level = 1,

	staff_level = 1,
	charge_cost = 10,
	charges_min = 40,
	charges_max = 80,
}

Spell{
	name     = "Healing",
	page     = 1,
	type     = 0,
	effect   = SPELL_SCRIPT,
	dmin     = function(slvl, caster) return (1 + caster.level + slvl) end,
	dmax     = function(slvl, caster) return (10 + 4*caster.level + 6*slvl) end,
	cost     = function(slvl, caster) return math.max(8 + 2*caster.level - 3*slvl,0) end,
	magic    = 17,
	color    = WHITE,
	townsafe = true,
	sound1   = 'cast8',
	script   = function(slvl, caster)
		ui.play_sound('sound/sfx/misc/cast8.wav')
		caster.hp = math.min(caster.hpmax, (caster.hp + math.random( 1 + caster.level + slvl, 10 + 4*caster.level + 6*slvl )))
	end,

	book_price   = 1000,
	book_level   = 1,
    scroll_price = 50,
	scroll_level = 1,

	staff_level = 1,
	charge_cost = 10,
	charges_min = 20,
	charges_max = 40,
}

--[[
-- This will have to wait until fire-layer is implemented
Spell{
	name     = "Inferno",
	page     = 1,
	type     = DAMAGE_FIRE,
	dmin     = function(slvl, caster) return 3 end,
	dmax     = function(slvl, caster) return 6 + (3*caster.level)/2 end,
	cost     = function(slvl) return math.max(12 - slvl,6) end,
	magic    = 20,
	target   = SPELL_DIRECTION,
	effect   = SPELL_BLAST,
	color    = RED,
	picture  = "*",
	range    = 3,
	sound1   = 'cast2',
	sound2   = '', // TODO

	book_price   = 2000,
	book_level   = 3,

    scroll_price = 100,
	scroll_level = 1,
	scroll_mag   = 19,

	staff_level = 1,
	charge_cost = 10,
	charges_min = 20,
	charges_max = 40,
}
]]--

-- Page 2 spells

--[[
Spell{
	name     = "Lightning",
	page     = 1,
	type     = DAMAGE_LIGHTNING,
	dmin     = function(slvl) return 4 end,
	dmax     = function(slvl, caster) return 4 + (2 * caster.level) end,
	count    = function(slvl) return math.floor(((slvl/2)+6)/20) end,
	cost     = function(slvl) return math.max(11-slvl,6) end,
	magic    = 20,
	color    = LIGHTCYAN,
	target   = SPELL_TARGET,
	effect   = SPELL_BOLT,
	picture  = "*",
	sound1   = 'cast4',
	sound2   = '', -- secondary sound moves with bolt ltning or ltning1

	book_price   = 3000,
	book_level   = 4,

	scroll_price = 150,
	scroll_level = 3,

	staff_level = 3,
	charge_cost = 30,
	charges_min = 20,
	charges_max = 40,
}
--]]

Spell{
	name     = "Town Portal",
	page     = 1,
	type     = 0,
	effect   = SPELL_SCRIPT,
	cost     = function(slvl) return math.max(35 - ((slvl-1)*3),18) end,
	magic    = 20,
	sound1   = 'cast6',
-- special case sound2 is played in TLevel.TimeFlow (rllevel.pas)
--	sound2   = 'sentinel',

	color    = LIGHTBLUE,
	script   = function(slvl)
		ui.msg("You feel the presence of strong magic around you...")
		player:summon_portal( 6 + math.random(20) )
	end,

	book_level = 3,
	book_price = 3000,

	scroll_price = 200,
	scroll_level = 3,

	staff_level = 3,
	charge_cost = 40,
	charges_min = 8,
	charges_max = 12,

}

Spell{
	name     = "Flash",
	page     = 1,
	type     = DAMAGE_MAGIC,
	dmin     = function(slvl, caster) return math.floor(((9/ 8)^slvl)*math.floor(3 * caster.level / 2)) end,
	dminmlvl = function(mlvl) return math.ceil(mlvl/32) end,
	dmax     = function(slvl, caster) return math.floor(((9/ 8)^slvl)*(3 * caster.level)) end,
	dmaxmlvl = function(mlvl) return math.floor(19*mlvl/32) end,
	cost     = function(slvl) return math.max(30 - 2 * (slvl - 1), 16) end,
	magic    = 33,
	effect   = SPELL_BLAST,
	color    = RED,
	picture  = "*",
	sound1   = 'cast4',
	sound2   = 'nova',

	book_price = 7500,
	book_level = 5,

    scroll_price = 500,
	scroll_level = 6,
	scroll_mag   = 21,

	staff_level = 4,
	charge_cost = 100,
	charges_min = 20,
	charges_max = 40,
}

Spell{
	name     = "Stone Curse",
	page     = 1,
	type     = DAMAGE_MAGIC,
	cost     = function(slvl) return math.max(60 - 3 * (slvl - 1), 40) end,
	magic    = 51,
	target   = SPELL_TARGET,
	effect   = SPELL_SCRIPT,
	color    = DARKGRAY,
	sound1   = 'cast2',
	sound2   = 'scurse',
	script =  function( slvl, caster, target )
		if not target then return end
		if not target:is_npc() then return end
		if target.flags[ nfStatue ] then return end
		target.flags[ nfStatue ] = true
		target.recov = math.max(480 + 80 * slvl, 1200)
		ui.msg(target:get_name(0)..' turned into stone.')
	end,

	book_price = 12000,
	book_level = 6,

    scroll_price = 800,
	scroll_level = 6,
	scroll_mag   = 33,

	staff_level = 5,
	charge_cost = 160,
	charges_min = 8,
	charges_max = 16,
}

-- Page 3 spells

Spell{
	name     = "Phasing",
	page     = 1,
	type     = DAMAGE_MAGIC,
	cost     = function(slvl) return math.max(12 - 2 * (slvl-1),4) end,
	magic    = 39,
	effect   = SPELL_SCRIPT,
	color    = CYAN,
	sound1   = 'cast2',
	sound2   = 'teleport',
	script =  function( slvl, caster )
		caster:phasing()
	end,

	book_price = 3500,
	book_level = 7,

    scroll_price = 200,
	scroll_level = 6,
	scroll_mag   = 25,

	staff_level = 6,
	charge_cost = 40,
	charges_min = 40,
	charges_max = 80,
}

Spell{
	name     = "Mana Shield",
	page     = 1,
	type     = DAMAGE_MAGIC,
	cost     = function(slvl) return 33 end,
	magic    = 25,
	color    = BLUE,
	effect   = SPELL_SCRIPT,
	sound1   = 'cast2',
	sound2   = 'mshield',
	script =  function( slvl, caster, target )
		if caster.mp > 0 then
			caster.flags[ nfManaShield ] = true
			ui.msg('You feel magical protection.')
		end;
	end,

	book_price = 16000,
	book_level = 6,

    scroll_price = 1200,
	scroll_level = 8,

	staff_level = 5,
	charge_cost = 240,
	charges_min = 4,
	charges_max = 10,
}

Spell{
	name     = "Fireball",
	page     = 1,
	type     = DAMAGE_FIRE,
	dmin     = function(slvl, caster) return math.floor(((9/ 8)^slvl)*(4 + 2 * caster.level)) end,
	dmax     = function(slvl, caster) return math.floor(((9/ 8)^slvl)*(40 + 2 * caster.level)) end,
	cost     = function(slvl) return math.max(16 - (slvl-1),10) end,
	magic    = 48,
	target   = SPELL_TARGET,
	effect   = SPELL_BALL,
	color    = LIGHTRED,
	picture  = "*",
	sound1   = 'cast2',
	sound2   = 'fbolt2',

	book_price = 8000,
	book_level = 8,

    scroll_price = 300,
	scroll_level = 8,
	scroll_mag   = 31,

	staff_level = 7,
	charge_cost = 60,
	charges_min = 40,
	charges_max = 80,
}

Spell{
	name     = "Guardian",
	page     = 1,
	type     = 0,
	cost     = function(slvl) return math.max(50 - 2 * (slvl-1),30) end,
	magic    = 81,
	effect   = SPELL_SCRIPT,
	target   = SPELL_TARGET,
	color    = BROWN,
	script =  function( slvl, caster )
		local hydra = level.drop_npc( 'hydra', caster:get_target() )
		hydra.hpmax = (8*slvl+4*caster.level)
		hydra.hp = hydra.hpmax
		hydra.aistate = player.spells['firebolt']
	end,

	book_price = 14000,
	book_level = 9,

    scroll_price = 920,
	scroll_level = 12,
	scroll_mag   = 51,

	staff_level = 8,
	charge_cost = 290,
	charges_min = 16,
	charges_max = 32,
}

-- Page 4 Spells

Spell{
	name     = "Teleport",
	page     = 1,
	type     = DAMAGE_MAGIC,
	cost     = function(slvl) return math.max(35 - 3 * (slvl-1),15) end,
	magic    = 105,
	target   = SPELL_TARGET,
	effect   = SPELL_SCRIPT,
	color    = LIGHTCYAN,
	script =  function( slvl, caster )
		caster.targetx, caster.targety = level.find_nearest( caster:get_target(), cfNoMonsters, cfNoObstacles):get()
		caster:move( caster:get_target() )
	end,

	book_price = 20000,
	book_level = 14,

    scroll_price = 3000,
	scroll_level = 14,
	scroll_mag   = 81,

	staff_level = 12,
	charge_cost = 250,
	charges_min = 16,
	charges_max = 32,
}

Spell{
	name     = "Golem",
	page     = 1,
	type     = 0,
	cost     = function(slvl) return math.max(100 - 6 * (slvl-1),60) end,
	magic    = 81,
	effect   = SPELL_SCRIPT,
	color    = BROWN,
	script =  function( slvl, caster )
		local golem = level.find('golem')
		if golem then level.drop_npc( '', golem:get_position() ) end
		golem = level.drop_npc( 'golem', caster:get_position() )
		golem.hpmax = math.floor(caster.mpmax*2/3 + 10*slvl)
		golem.hp = golem.hpmax
		golem.tohit = 40 + 2 * caster.level + 5 * slvl
		golem.dmgmin = 8 + 2 * slvl
		golem.dmgmax = 16 + 2 * slvl
		golem.scount = 0
	end,

	book_price = 18000,
	book_level = 11,

    scroll_price = 1100,
	scroll_level = 10,
	scroll_mag   = 51,

	staff_level = 9,
	charge_cost = 220,
	charges_min = 16,
	charges_max = 32,
}
