Shop{
	id = "grisworld",
	name = "Buying at Griswold",
	size = 10,

	OnRefill = function( self )
		local lvl = math.min( 16, math.max( 6, player.maxdepth ) )
		local sitem = nil
		self:clear()
		local count = math.random(8,10)
		for i=1,count do
			repeat
				sitem = item.new( level.random_item_id( lvl, { TYPE_WEAPON, TYPE_STAFF, TYPE_HELM, TYPE_SHIELD, TYPE_ARMOR } ) )
				self.item[i] = sitem
			until sitem.price > 0 and sitem.spell == 0
			sitem:identify()
			sitem.dur = sitem.durmax
		end
		count = math.random(2,4)
		for i=self.amount+1,self.amount+count do
			repeat
				sitem = item.new( level.random_item_id( lvl, { TYPE_BOW } ) )
				self.item[i] = sitem
			until sitem.price > 0 and sitem.spell == 0
			sitem:identify()
			sitem.dur = sitem.durmax
		end
		self:sort()
	end,

	OnEnter = function( self )
		repeat
			if self.amount == 0 then
				ui.msg( 'Griswold says "Sorry '..player:salutation()..', got nothing to sell right now."')
				return
			else
				local nid = ui.shop( self.id, "Buying at Griswold ("..player.gold.." gold left)" )
				if nid == 0 then return end
				local bitem = self.item[nid]

				if bitem.volume + player.volume > MaxVolume then
					ui.msg( 'Griswold says "Sorry '..player:salutation()..', you have no room for that."')
				elseif bitem.price > player.gold then
					ui.msg( 'Griswold says "Sorry '..player:salutation()..', you have not enough money."')
				else
					player:remove_gold( bitem.price )
					ui.msg( 'You buy a '..bitem.name..' for '..bitem.price..' gold pieces.')
					player:add_item( bitem )
					self.item[nid] = nil
				end
			end
		until false
	end,
}

Shop{
	id = "grisworld_premium",
	name = "Buying at Griswold",
	size = 6,

	OnRefill = function ( self )
		local lvl = player.level
		local sitem = nil
		for i = 1, math.min(6,(player.level-self.level)*2) do
		  self.item[i] = "" end
		if lvl ~= self.level then self.item[1] = nil end
		self.level = lvl
		for i=1,6 do
			if i == 6 then lvl = lvl + 1 end
			if not self.item[i] ~= nil then
				repeat
					sitem = item.new( level.random_item_id( lvl, { TYPE_WEAPON, TYPE_BOW, TYPE_HELM, TYPE_SHIELD, TYPE_ARMOR, TYPE_RING, TYPE_AMULET } ) )
					self.item[i] = sitem
					utils.roll_magic( sitem, lvl / 2, lvl )
				until sitem.level > lvl / 4 and
					sitem.price > 0 and
					sitem.spell == 0 and
					sitem.flags[ ifMagic ] and
					not sitem.flags[ ifCursed ]
				sitem:identify()
				sitem.dur = sitem.durmax
			end
		end
		self:sort()
	end,

	OnEnter = function( self )
		repeat
			if self.amount == 0 then
				ui.msg( 'Griswold says "Sorry '..player:salutation()..', got nothing premium to sell right now."')
				return
			else
				local nid = ui.shop( self.id, "Buying at Griswold ("..player.gold.." gold left)" )
				if nid == 0 then return end
				local bitem = self.item[nid]


				if bitem.volume + player.volume > MaxVolume then
					ui.msg( 'Griswold says "Sorry '..player:salutation()..', you have no room for that."')
				elseif bitem.price > player.gold then
					ui.msg( 'Griswold says "Sorry '..player:salutation()..', you have not enough money."')
				else
					player:remove_gold( bitem.price )
					ui.msg( 'You buy a '..bitem.name..' for '..bitem.price..' gold pieces.')
					player:add_item( bitem )
					self.item[nid] = nil
					shops[self.id].OnRefill( level.get_shop(self.nid) )
				end
			end
		until false
	end,
}

Shop{
	id = "pepin",
	name = "Buying at Pepin",
	size = 12,

	OnRefill = function( self )
		self:clear()
		self:add( "potion_healing" )
		self:add( "potion_full_healing" )
		for i=1,5 do
			self:add( "potion_rejuvenation" )
		end
		for i=1,5 do
			self:add( "scroll_healing" )
		end
		self:sort()
	end,

	OnEnter = function( self )
		-- Pepin always has something to sell
		repeat
			local nid = ui.shop( self.id, "Buying at Pepin ("..player.gold.." gold left)" )
			if nid == 0 then return end
			local bitem = self.item[nid]

			if bitem.volume + player.volume > MaxVolume then
				ui.msg( 'Pepin says "Sorry '..player:salutation()..', you have no room for that."')
			elseif bitem.price > player.gold then
				ui.msg( 'Pepin says "Sorry '..player:salutation()..', you have not enough money."')
			else
				player:remove_gold( bitem.price )
				ui.msg( 'You buy a '..bitem.name..' for '..bitem.price..' gold pieces.')
				if nid < 3 then
					player:add_item( bitem.id )
				else
					player:add_item( bitem )
					self.item[nid] = nil
				end
			end
		until false
	end,

}

Shop{
	id = "adria",
	name = "Buying at Adria",
	size = 12,

	OnRefill = function( self )
		local lvl = math.min( 16, math.max( 6, player.maxdepth ) )
		local sitem = nil
		self:clear()
		self:add("potion_mana")
		self:add("potion_full_mana")
		self:add("scroll_town_portal")
		local count = math.random(3)+6
		for i = 1,count do
			self:add( level.random_item_id( lvl, { TYPE_SCROLL } ))
		end
		local count = math.random(5)-2
		if count > 0 then
			for i=1, count do
				self:add( level.random_item_id( lvl, { TYPE_BOOK } ))
		end end
		count = math.random(5)-2
		if count > 0 then
			for i = self.amount +1, self.amount+count do
				repeat
					sitem = item.new( level.random_item_id( lvl, { TYPE_STAFF } ) )
					self.item[i] = sitem
					if math.random(3) ~= 2 then
						utils.roll_magic( sitem, lvl / 2, lvl )
					end
				until sitem.level > lvl / 4 and sitem.price > 0 and
					(sitem.spell ~= 0 or sitem.flags[ ifMagic ]) and
					not sitem.flags[ ifCursed ]
				sitem:identify()
				sitem.dur = sitem.durmax
			end 
		end
		self:sort()
	end,

	OnEnter = function( self )
		repeat
			local nid = ui.shop( self.id, "Buying at Adria ("..player.gold.." gold left)" )
			if nid == 0 then return end
			local bitem = self.item[nid]

			if bitem.volume + player.volume > MaxVolume then
				ui.msg( 'Adria says "Sorry '..player:salutation()..', you have no room for that."')
			elseif bitem.price > player.gold then
				ui.msg( 'Adria says "Sorry '..player:salutation()..', you have not enough money."')
			else
				player:remove_gold( bitem.price )
				ui.msg( 'You buy a '..bitem.name..' for '..bitem.price..' gold pieces.')
				if nid < 4 then
					player:add_item( bitem.id )
				else
					player:add_item( bitem )
					self.item[nid] = nil
				end
			end
		until false
	end,
}

Shop{
	id = "wirt",
	name = "Buying at Wirt",
	size = 12,

	OnRefill = function( self )
		local wirt_filter = {
			KlassWarrior = {TYPE_WEAPON, TYPE_ARMOR, TYPE_HELM, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
			KlassRogue   = {TYPE_BOW, TYPE_ARMOR, TYPE_HELM, TYPE_RING, TYPE_AMULET},
			KlassSorceror= {TYPE_STAFF, TYPE_ARMOR, TYPE_HELM, TYPE_RING, TYPE_AMULET},
		}
		wirt_filter = wirt_filter[ player.klass ]

		local witem = nil
		local lvl = player.level
		if not self.item[1] ~= nil or lvl ~= self.level then
			repeat
				witem = item.new( level.random_item_id( lvl, wirt_filter ) )
				self.item[1] = witem
				utils.roll_magic( witem, math.min(lvl,25), 2*lvl )
			until witem.level > lvl / 4 and witem.price > 0 and
				witem.price <= 90000 and witem.spell == 0 and
				witem.flags[ ifMagic ] and not witem.flags[ ifCursed ]
			witem:identify()
			witem.dur = witem.durmax
			self.level = lvl
		end
	end,

	OnEnter = function( self )
		if self.amount == 0 then
			ui.msg('Wirt says "Sorry '..player:salutation()..', come back later."')
		elseif player:remove_gold( 50 ) then
			local nid = ui.shop( self.id, "Buying at Wirt ("..player.gold.." gold left)" )
			if nid == 0 then return end
			local bitem = self.item[nid]

			if bitem.volume + player.volume > MaxVolume then
				ui.msg( 'Wirt says "Sorry '..player:salutation()..', you have no room for that."')
			elseif bitem.price > player.gold then
				ui.msg( 'Wirt says "Sorry '..player:salutation()..', you have not enough money."')
			else
				player:remove_gold( bitem.price )
				ui.msg( 'You buy a '..bitem.name..' for '..bitem.price..' gold pieces.')
				player:add_item( bitem )
				self.item[nid] = nil
			end
		else
			ui.msg('Wirt says "Sorry '..player:salutation()..', you have not enough money."')
		end
	end,
}
