-- Data in this file comes from Jarulf:
--	5.4 Unique monsters
-- Properties are listed in the same order as the table columns
-- "level" is the mlvl battle column
-- The mlvl items column is implicit, the level of the base class
-- The proto must have the same name as the base class
-- The proto is used for mlvl items calculation and mob spawn
-----------------------
-- Random Unique NPCs
NPC{
	proto = "zombie",
	name = "Rotfeast the Hungry",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune},
	ai = AISkeleton,
	intf = 3,
	mob = true,
	dlvl = 2,
	level = 4,
	hpmin = 85,
	hpmax = 85,
	dmgmin = 4,
	dmgmax = 12,
}

NPC{
	proto = "zombie",
	name = "Soulpus",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfFireResist, nfLightningResist},
	intf = 0,
	mob = false,
	dlvl = 2,
	level = 4,
	hpmin = 133,
	hpmax = 133,
	dmgmin = 4,
	dmgmax = 8,
}

NPC{
	proto = "ghoul",
	name = "Rotcarnage",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune, nfLightningResist},
	intf = 3,
	mob = true,
	dlvl = 3,
	level = 6,
	hpmin = 102,
	hpmax = 102,
	dmgmin = 9,
	dmgmax = 24,
	ac = 45,
}

NPC{
	proto = "rotting_carcass",
	name = "Goretongue",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune},
	ai = AISkeleton,
	intf = 1,
	mob = false,
	dlvl = 3,
	level = 6,
	hpmin = 156,
	hpmax = 156,
	dmgmin = 15,
	dmgmax = 30,
}

NPC{
	proto = "fallen_one_spear",
	name = "Pukerat the Unclean",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireResist},
	intf = 3,
	mob = false,
	dlvl = 2,
	level = 4,
	hpmin = 51,
	hpmax = 51,
	dmgmin = 6,
	dmgmax = 18,
}

NPC{
	proto = "devil_kin_spear",
	name = "Bongo",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal},
	intf = 3,
	mob = true,
	dlvl = 3,
	level = 6,
	hpmin = 178,
	hpmax = 178,
	dmgmin = 9,
	dmgmax = 21,
}

NPC{
	proto = "fallen_one_sword",
	name = "Bladeskin the Slasher",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireResist},
	intf = 0,
	mob = false,
	dlvl = 2,
	level = 4,
	hpmin = 77,
	hpmax = 77,
	dmgmin = 1,
	dmgmax = 5,
	ac = 45,
}

NPC{
	proto = "carver_sword",
	name = "Gutshank the Quick",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireResist},
	ai = AIWingedFiend,
	intf = 2,
	mob = true,
	dlvl = 3,
	level = 6,
	hpmin = 66,
	hpmax = 66,
	dmgmin = 6,
	dmgmax = 16,
}

NPC{
	proto = "dark_one_sword",
	name = "Shadowcrow",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfInvisible},
	ai = AIHidden,
	intf = 2,
	mob = true,
	dlvl = 5,
	level = 10,
	hpmin = 270,
	hpmax = 270,
	dmgmin = 12,
	dmgmax = 25,
}

NPC{
	proto = "skeleton",
	name = "Boneripper",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune, nfFireImmune},
	ai = AIWingedFiend,
	intf = 0,
	mob = true,
	dlvl = 2,
	level = 4,
	hpmin = 54,
	hpmax = 54,
	dmgmin = 6,
	dmgmax = 15,
}

NPC{
	proto = "corpse_axe",
	name = "Bonehead Keenaxe",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune},
	intf = 2,
	mob = true,
	dlvl = 2,
	level = 4,
	hpmin = 91,
	hpmax = 91,
	dmgmin = 4,
	dmgmax = 10,
	tohit = 100,
}

NPC{
	proto = "burning_dead",
	name = "Madeye the Dead",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune, nfFireImmune},
	ai = AIWingedFiend,
	intf = 0,
	mob = true,
	dlvl = 4,
	level = 84,
	hpmin = 75,
	hpmax = 75,
	dmgmin = 21,
	dmgmax = 24,
}

NPC{
	proto = "corpse_captain",
	name = "Brokenhead Bangshield",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune, nfLightningResist},
	intf = 3,
	mob = true,
	dlvl = 4,
	level = 6,
	hpmin = 108,
	hpmax = 108,
	dmgmin = 12,
	dmgmax = 20,
}

NPC{
	proto = "horror_captain",
	name = "Shadowdrinker",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfUndead, nfMagicImmune, nfFireResist, nfLightningResist},
	ai = AIHidden,
	intf = 1,
	mob = true,
	dlvl = 5,
	level = 10,
	hpmin = 300,
	hpmax = 300,
	dmgmin = 18,
	dmgmax = 26,
	ac = 45,
}

NPC{
	proto = "scavenger",
	name = "Shadowbite",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireImmune},
	ai = AISkeleton,
	intf = 3,
	mob = true,
	dlvl = 2,
	level = 4,
	hpmin = 60,
	hpmax = 60,
	dmgmin = 3,
	dmgmax = 20,
}

NPC{
	proto = "plague_eater",
	name = "El Chupacabras",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireResist},
	ai = AIGoat,
	intf = 0,
	mob = true,
	dlvl = 3,
	level = 6,
	hpmin = 120,
	hpmax = 120,
	dmgmin = 10,
	dmgmax = 18,
}

NPC{
	proto = "shadow_beast",
	name = "Pulsecrawler",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireImmune, nfLightningResist},
	intf = 0,
	mob = true,
	dlvl = 4,
	level = 8,
	hpmin = 150,
	hpmax = 150,
	dmgmin = 16,
	dmgmax = 20,
	ac = 45,
}

NPC{
	proto = "bone_gasher",
	name = "Spineeater",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfLightningImmune},
	intf = 1,
	mob = true,
	dlvl = 4,
	level = 8,
	hpmin = 180,
	hpmax = 180,
	dmgmin = 18,
	dmgmax = 25,
}

NPC{
	proto = "blink",
	name = "Moonbender",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireImmune},
	intf = 0,
	mob = true,
	dlvl = 4,
	level = 8,
	hpmin = 135,
	hpmax = 135,
	dmgmin = 9,
	dmgmax = 27,
}

NPC{
	proto = "blink",
	name = "Wrathraven",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireImmune},
	intf = 2,
	mob = true,
	dlvl = 5,
	level = 10,
	hpmin = 135,
	hpmax = 135,
	dmgmin = 9,
	dmgmax = 22,
}

NPC{
	proto = "gloom",
	name = "Foulwing",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfAnimal, nfFireResist},
-- TODO
--	ai = AIHornedDemon,
	intf = 3,
	mob = true,
	dlvl = 5,
	level = 10,
	hpmin = 246,
	hpmax = 246,
	dmgmin = 12,
	dmgmax = 28,
}

NPC{
	proto = "hidden",
	name = "Warpskull",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfFireResist, nfLightningResist},
	intf = 2,
	mob = true,
	dlvl = 3,
	level = 6,
	hpmin = 117,
	hpmax = 117,
	dmgmin = 6,
	dmgmax = 18,
}

NPC{
	proto = "stone_clan",
	name = "Deathshade Fleshmaul",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfMagicImmune, nfFireResist},
	-- TODO
--	ai = AIHornedDemon,
	intf = 0,
	dlvl = 6,
	level = 10,
	hpmin = 276,
	hpmax = 276,
	dmgmin = 12,
	dmgmax = 24,
}

NPC{
	proto = "fire_clan",
	name = "Bloodgutter",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfFireImmune},
	-- TODO
	ai = AIWingedFiend,
	intf = 1,
	dlvl = 6,
	level = 12,
	hpmin = 315,
	hpmax = 315,
	dmgmin = 24,
	dmgmax = 34,
}

NPC{
	proto = "night_clan",
	name = "Blighthorn Steelmace",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist},
	-- TODO
--	ai = AIHornedDemon,
	intf = 0,
	dlvl = 7,
	level = 10,
	hpmin = 250,
	hpmax = 250,
	dmgmin = 20,
	dmgmax = 28,
	ac = 55,
}

NPC{
	proto = "overlord",
	name = "Bilefroth the Pit Master",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist, nfFireImmune, nfMagicImmune},
	intf = 1,
	mob = true,
	dlvl = 5,
	level = 10,
	hpmin = 207,
	hpmax = 207,
	dmgmin = 3,
	dmgmax = 16,
}

NPC{
	proto = "flesh_clan_archer",
	name = "Bloodskin Darkbow",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist, nfFireResist},
	intf = 0,
	mob = true,
	dlvl = 5,
	level = 10,
	hpmin = 207,
	hpmax = 207,
	dmgmin = 3,
	dmgmax = 16,
}

NPC{
	proto = "fire_clan_archer",
	name = "Blightfire",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfFireImmune},
	intf = 2,
	mob = true,
	dlvl = 7,
	level = 14,
	hpmin = 321,
	hpmax = 321,
	dmgmin = 13,
	dmgmax = 21,
}

NPC{
	proto = "night_clan_archer",
	name = "Gorestone",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist},
	intf = 1,
	mob = true,
	dlvl = 7,
	level = 14,
	hpmin = 303,
	hpmax = 303,
	dmgmin = 15,
	dmgmax = 28,
	tohit = 70,
}

NPC{
	proto = "overlord",
	name = "Bilefroth the Pit Master",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist, nfFireImmune, nfMagicImmune},
	intf = 1,
	mob = true,
	ai = AIWingedFiend,
	dlvl = 6,
	level = 12,
	hpmin = 210,
	hpmax = 210,
	dmgmin = 16,
	dmgmax = 23,
}

NPC{
	proto = "mud_man",
	name = "Bilefroth the Pit Master",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist, nfFireResist, nfMagicImmune},
	intf = 3,
	mob = true,
	ai = AIHidden,
	dlvl = 8,
	level = 16,
	hpmin = 315,
	hpmax = 315,
	dmgmin = 24,
	dmgmax = 35,
}

NPC{
	proto = "toad_demon",
	name = "Oozedrool",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist},
	intf = 3,
	mob = true,
	dlvl = 9,
	level = 18,
	hpmin = 483,
	hpmax = 483,
	dmgmin = 25,
	dmgmax = 30,
}

NPC{
	proto = "gargoyle",
	name = "Nightwing of the Cold",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist, nfMagicImmune},
	intf = 1,
	mob = true,
	ai = AIWingedFiend,
	dlvl = 7,
	level = 14,
	hpmin = 342,
	hpmax = 342,
	dmgmin = 18,
	dmgmax = 26,
}

NPC{
	proto = "blood_claw",
	name = "Goblight of the flame",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfFireImmune, nfMagicImmune},
	intf = 0,
	mob = true,
	dlvl = 10,
	level = 20,
	hpmin = 405,
	hpmax = 405,
	dmgmin = 20,
	dmgmax = 40,
}

NPC{
	proto = "death_wing",
	name = "Viletouch",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningImmune},
	intf = 3,
	mob = true,
	dlvl = 12,
	level = 24,
	hpmin = 525,
	hpmax = 525,
	dmgmin = 20,
	dmgmax = 40,
}

NPC{
	proto = "magma_demon",
	name = "Firewound the Grim",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfFireResist, nfMagicImmune},
	intf = 0,
	mob = true,
	dlvl = 8,
	level = 16,
	hpmin = 303,
	hpmax = 303,
	dmgmin = 18,
	dmgmax = 22,
}

NPC{
	proto = "mud_runner",
	name = "Breakspine",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfFireResist},
	intf = 0,
	mob = true,
	dlvl = 9,
	level = 18,
	hpmin = 351,
	hpmax = 351,
	dmgmin = 25,
	dmgmax = 34,
}

NPC{
	proto = "obsidian_lord",
	name = "Blackstorm",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningImmune, nfMagicImmune},
	intf = 3,
	mob = true,
	dlvl = 10,
	level = 20,
	hpmin = 525,
	hpmax = 525,
	dmgmin = 20,
	dmgmax = 40,
	ac = 90,
}

NPC{
	proto = "frost_charger",
	name = "Bluehorn",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist, nfMagicImmune},
	intf = 1,
	mob = true,
	dlvl = 11,
	level = 22,
	hpmin = 477,
	hpmax = 477,
	dmgmin = 25,
	dmgmax = 30,
	ac = 90,
}

NPC{
	proto = "acid_beast",
	name = "Deathspit",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfLightningResist, nfFireResist},
	intf = 0,
	mob = true,
	--ai = AIFastSpit,
	dlvl = 6,
	level = 12,
	hpmin = 303,
	hpmax = 303,
	dmgmin = 12,
	dmgmax = 32,
}

NPC{
	proto = "poison_spitter",
	name = "Chaoshowler",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon},
	intf = 0,
	mob = true,
	--ai = AIFastSpit,
	dlvl = 8,
	level = 16,
	hpmin = 240,
	hpmax = 240,
	dmgmin = 12,
	dmgmax = 20,
}

NPC{
	proto = "poison_spitter",
	name = "Plaguewrath",
	color = LIGHTMAGENTA,
	random = true,
	flags = {nfUnique, nfDemon, nfFireResist, nfMagicImmune},
	intf = 2,
	mob = true,
	--ai = AIFastSpit,
	dlvl = 10,
	level = 20,
	hpmin = 450,
	hpmax = 450,
	dmgmin = 20,
	dmgmax = 30,
}

-- Quest Unique NPCs --
-----------------------
NPC{
	proto = 'butcher_base',
	name = "the Butcher",
	intf = 3,
	corpse = "bloody_corpse",
	color = LIGHTMAGENTA,
	flags = {nfUnique, nfDemon},
	level = 6,
	hpmin = 110,
	hpmax = 110,
	tohit = 50,
	ac    = 50,
	dmgmin = 6,
	dmgmax = 12,
	expvalue = 710,

	OnSpot = function()
		ui.msg("Butcher exclaims \"Ahh...fresh meat!\"")
		ui.play_sound("sound/sfx/monsters/butcher.wav")
	end,

	OnDrop = function(self)
		level.drop_item('cleaver', self:get_position() )
	end,

	OnDie = function()
		player:play_sound(80);
		ui.msg_enter("@<\"The spirits of the dead are now avenged\"@>")
		player.quest["butcher"] = 2
	end,
}

NPC{
	proto = "leoric_base",
	name = "Skeleton King",
	id = "leoric",
	corpse = "bones",
	color = LIGHTMAGENTA,
	intf = 3,
	flags = {nfUnique, nfUndead, nfOpenDoors, nfMagicImmune, nfFireResist, nfLightningResist},
	level = 14,
	hpmin = 120,
	hpmax = 120,
	ac = 70,
	tohit = 60,
	dmgmin = 6,
	dmgmax = 16,
	expvalue = 570,

	OnDrop = function(self)
		level.drop_item('undead_crown', self:get_position() )
	end,

	OnDie = function()
		player:play_sound("82")
		ui.msg_enter("@<\"Rest well Leoric. I'll find your son.\"@>")
		player.quest["leoric"] = 3
	end,
}

NPC{
	proto = "dark_one_spear",
	name = "Snotspill",
	color = LIGHTMAGENTA,
	flags = {nfUnique, nfLightningResist, nfAnimal},
	ai   = AINPC,
	level = 8,
	hpmin = 220,
	hpmax = 220,
	tohit = 30,
	dmgmin = 10,
	dmgmax = 18,
	expvalue = 510,

	OnTalk = function()
		if player.quest["sign"] < 2 then
			ui.play_sound("sound/sfx/monsters/snot01.wav")
			ui.plot_talk("Hey - you that one that kill all! You get me magic banner or we attack! You no leave with Life! You kill big uglies and give back magic. Go past corner and door. Find uglies. You give, you go!")
			player.quest["sign"] = 2
		elseif player.item["tavern_sign"] ~= nil then
			ui.play_sound("sound/sfx/monsters/snot03.wav")
			ui.plot_talk("You give! Yes, good! Go now, we strong! We kill all with big magic! (laughs) ")
			player.item["tavern_sign"] = nil
			player.quest["sign"] = 5
			levels[4].OnEnter()
		else
			ui.play_sound("sound/sfx/monsters/snot02.wav")
			ui.plot_talk("You kill uglies, get banner. You bring to me, or else...")
		end
	end,
}

NPC{
	proto = "goat",
	name = "Gharbad",
	ai   = AINPC,
	intf = 3,
	color = LIGHTMAGENTA,
	flags = {nfUnique, nfLightningResist, nfDemon, nfOpenDoors},
	level = 7,
	hpmin = 120,
	hpmax = 120,
	tohit = 50,
	ac = 40,
	dmgmin = 6,
	dmgmax = 16,
	expvalue = 460,

	OnTalk = function(self)
		local state = player.quest["gharbad"]
		if state < 2 then
			quests["gharbad"].OnJournal()
			player.quest["gharbad"] = 1
		elseif state < 4 then
			ui.play_sound("sound/sfx/monsters/garbud02.wav");
			ui.plot_talk("Something for you I am making. Again, not kill Gharbad, live and give good.@/@/You take this as proof I keep word...")
			if (state == 2) then
				level.drop_random_item(player.x, player.y, 7, 100, false)
			end
			player.quest["gharbad"] = 3
		elseif state < 6 then
			ui.play_sound("sound/sfx/monsters/garbud03.wav");
			ui.plot_talk("Nothing yet! Almost done.@/@/Very powerful, very strong. Live! Live!@/@/No pain and promise I keep!")
			player.quest["gharbad"] = 5
		elseif state == 6 then
			ui.play_sound("sound/sfx/monsters/garbud04.wav");
			ui.plot_talk("This too good for you. Very powerful! You want - you take!")
			self.ai = AIGoat
		end
	end,

	OnSpot = function()
		local state = player.quest["gharbad"]
		if (state % 2 == 1) then
			-- inc from odd to even state
			player.quest["gharbad"] = state + 1
		end
	end,

	OnDie = function()
		player:play_sound(61);
		ui.msg_enter("@<\"I'm not impressed.\"@>")
		player.quest["gharbad"] = 7
	end,

	OnDrop = function(self)
		local id
		repeat
			-- find some kind of club base item
			id = level.random_item_id(7,{TYPE_WEAPON})
		until items[id].proto.pid == "club"
		level.drop_random_base(id,self.x,self.y,7,100,true)
	end,
}

NPC{
	proto  	= "mage_base",
	id 	 	= "zhar_the_mad",
	name 	= "Zhar the mad",
	ai   	= AINPC,
	intf 	= 3,
	color 	= LIGHTMAGENTA,
	flags 	= {nfUnique, nfLightningResist, nfDemon, nfOpenDoors, nfMagicImmune, nfFireResist},
	level 	= 16,
	hpmin 	= 360,
	hpmax 	= 360,
	tohit 	= 90,
	ac 		= 0,
	dmgmin 	= 16,
	dmgmax 	= 40,
	expvalue= 3876,

	OnTalk = function()
		if player.quest["mad_mage"] == 0 then
			player.quest["mad_mage"] = 1
			level.drop_item( level.random_item_id( level.level() * 2, { TYPE_BOOK } ),player:get_position() )
		end
		quests["mad_mage"].OnJournal()
	end,

	OnDie = function()
		player:play_sound(62);
		ui.msg_enter("@<\"I'm sorry, did I break your concentration?\"@>")
		player.quest["mad_mage"] = 2
	end
}

--Spell summoned NPCs --
------------------------

NPC{
	proto = 'golem_base',
	name = 'golem',
	intf = 0,
	color = BROWN,
	level = 12,
	hpmin = 12,
	hpmax = 12,
	tohit = 40,
	ac = 25,
	dmgmin = 8,
	dmgmax = 16,
	expvalue = 0,
}

NPC{
	proto = 'guardian_base',
	id	= 'hydra',
	name = 'guardian',
	intf = 0,
	color = BROWN,
	level = 12,
	hpmin = 12,
	hpmax = 12,
	tohit = 40,
	ac = 25,
	dmgmin = 8,
	dmgmax = 16,
	expvalue = 0,
}
