-- Data in this file comes from Jarulf:
--	5.2 Monster data
--	5.3.1 Monster size
--	5.3.4 Timing information
------------------------------
-- monster is the base prototype for all monsters
-- it is mostly used to
-- the default properties should all be overridden
Prototype{
	pid = "monster",
	ai = AISkeleton,
	intf = 0,
	pic = "?",
	color = WHITE,
	level = 1,
	corpse = "bloody_corpse",
	amountmin = 1,
	amountmax = 1,
	size = 500,
	hpmin = 1,
	hpmax = 1,
	tohit = 0,
	ac = 0,
	dmgmin = 0,
	dmgmax = 0,
	spdmov = 100,
	spdatk = 100,
	spdhit = 100,
	expvalue = 0,

	OnDrop = function(self)
		if self.flags[ nfUnique ] then
			local mlvlitem = self.level
			if npcs[self.id].proto and type(npcs[self.id].proto) == 'table' then
				mlvlitem = npcs[self.id].proto.level
			end
			level.drop_random_item( self.x, self.y, mlvlitem, 100, true )
		else
			local roll = math.random(10)
			if roll < 7  then return end
			if roll < 10 then
				level.drop_gold( self.x, self.y )
			else
				level.drop_random_item( self.x, self.y, self.level )
			end
		end
	end,
}

--== ZOMBIES ========================================================--

Prototype{
	proto = "monster",
	pid = "zombie_base",
	ai = AIZombie,
	flags = {nfUndead,nfMagicImmune},
	amountmin = 1,
	amountmax = 4,
	pic = "z",
	size = 799,
	corpse = "corpse",
	spdmov = 120,
	spdhit = 30,
	spdatk = 60,
	sound = "sound/monsters/zombie/zombie",
}

NPC{
	proto = "zombie_base",
	name = "zombie",
	intf = 0,
	color = LIGHTGRAY,
	level = 1,
	group = {1,2},
	hpmin = 2,
	hpmax = 3,
	tohit = 10,
	ac = 5,
	dmgmin = 2,
	dmgmax = 5,
	expvalue = 54,
}

NPC{
	proto = "zombie_base",
	name = "ghoul",
	intf = 1,
	color = LIGHTBLUE,
	level = 2,
	group = {2,3},
	hpmin = 3,
	hpmax = 5,
	tohit = 10,
	ac = 10,
	dmgmin = 3,
	dmgmax = 10,
	expvalue = 58,
}

NPC{
	proto = "zombie_base",
	name = "rotting carcass",
	intf = 2,
	color = DARKGRAY,
	level = 4,
	group = {2,3,4},
	hpmin = 7,
	hpmax = 12,
	tohit = 25,
	ac = 15,
	dmgmin = 5,
	dmgmax = 15,
	expvalue = 136,
}

NPC{
	proto = "zombie_base",
	name = "black death",
	intf = 3,
	color = YELLOW,
	level = 6,
	group = {3,4,5},
	hpmin = 12,
	hpmax = 20,
	tohit = 25,
	ac = 20,
	dmgmin = 6,
	dmgmax = 22,
	expvalue = 240,
	amountmin = 1,
	amountmax = 1,

	OnAttack = function(self,tgt)
	  tgt.hpmod = tgt.hpmod - 1
	end,
}

--== SKELETONS ======================================================--

Prototype{
	proto = "monster",
	pid = "skeleton_base",
	flags = {nfUndead, nfMagicImmune, nfSkeleton},
	corpse = "bones",
	sound = "sound/monsters/skelaxe/sklax"
}

-- normal skeletons --

Prototype{
	proto = "skeleton_base",
	pid = "skeleton_axe",
	pic = "s",
	ai = AISkeleton,
	amountmin = 1,
	amountmax = 5,
	size = 553,
	spdatk = 65,
	spdhit = 30,
	ac = 0,
}

NPC{
	proto = "skeleton_axe",
	name = "skeleton",
	intf = 0,
	color = LIGHTGRAY,
	level = 1,
	group = {1,2},
	hpmin = 1,
	hpmax = 2,
	tohit = 20,
	dmgmin = 1,
	dmgmax = 4,
	expvalue = 64,
}

NPC{
	proto = "skeleton_axe",
	name = "corpse axe",
	intf = 1,
	color = BROWN,
	level = 4,
	group = {2,3,4},
	hpmin = 2,
	hpmax = 3,
	tohit = 25,
	dmgmin = 3,
	dmgmax = 5,
	expvalue = 68,
}

NPC{
	proto = "skeleton_axe",
	name = "burning dead",
	intf = 2,
	color = LIGHTRED,
	flags = {nfUndead,nfMagicImmune,nfFireResist,nfSkeleton},
	level = 4,
	group = {2,3,4},
	hpmin = 4,
	hpmax = 6,
	tohit = 30,
	ac = 5,
	dmgmin = 3,
	dmgmax = 7,
	expvalue = 154,
}

NPC{
	proto = "skeleton_axe",
	name = "horror",
	intf = 3,
	color = DARKGRAY,
	flags = {nfUndead,nfMagicImmune,nfLightningResist,nfSkeleton},
	level = 6,
	group = {4,5,6},
	hpmin = 6,
	hpmax = 10,
	tohit = 35,
	ac = 15,
	dmgmin = 4,
	dmgmax = 9,
	expvalue = 264,
}

-- skeleton captains --

Prototype{
	proto = "skeleton_axe",
	pid = "skeleton_captain",
	pic = "S",
	amountmin = 1,
	amountmax = 4,
	size = 575,
	spdatk = 60,
	spdhit = 35,
}

NPC{
	proto = "skeleton_captain",
	name = "skeleton captain",
	intf = 0,
	color = LIGHTGRAY,
	level = 2,
	group = {1,2,3},
	hpmin = 1,
	hpmax = 3,
	tohit = 20,
	ac = 10,
	dmgmin = 2,
	dmgmax = 7,
	expvalue = 90,
}

NPC{
	proto = "skeleton_captain",
	name = "corpse captain",
	intf = 1,
	color = BROWN,
	level = 4,
	group = {2,3,4},
	hpmin = 6,
	hpmax = 10,
	tohit = 30,
	ac = 5,
	dmgmin = 3,
	dmgmax = 9,
	expvalue = 200,
}

NPC{
	proto = "skeleton_captain",
	name = "burning dead captain",
	intf = 2,
	color = LIGHTRED,
	flags = {nfUndead,nfMagicImmune,nfFireResist,nfSkeleton},
	level = 6,
	group = {3,4,5},
	hpmin = 8,
	hpmax = 15,
	tohit = 35,
	ac = 15,
	dmgmin = 4,
	dmgmax = 10,
	expvalue = 393,
}

NPC{
	proto = "skeleton_captain",
	name = "horror captain",
	intf = 3,
	color = DARKGRAY,
	flags = {nfUndead,nfMagicImmune,nfLightningResist,nfSkeleton},
	level = 8,
	group = {4,5,6},
	hpmin = 17,
	hpmax = 25,
	tohit = 40,
	ac = 30,
	dmgmin = 5,
	dmgmax = 14,
	expvalue = 604,
}


-- skeleton archers --

Prototype{
	proto = "monster",
	pid = "skeleton_archer",
	ai = AISkelArcher,
	amountmin = 1,
	amountmax = 4,
	flags = {nfUndead,nfMagicImmune,nfSkeleton},
	size = 567,
	pic = "a",
	corpse = "bones",
	sound = "sound/monsters/skelbow/sklbw",
}

NPC{
	proto = "skeleton_archer",
	name = "skeleton archer",
	intf = 0,
	color = LIGHTGRAY,
	level = 3,
	group = {2,3},
	hpmin = 1,
	hpmax = 2,
	tohit = 15,
	dmgmin = 1,
	dmgmax = 2,
	expvalue = 110,
}

NPC{
	proto = "skeleton_archer",
	name = "corpse bow",
	intf = 1,
	color = BROWN,
	level = 5,
	group = {2,3,4},
	hpmin = 4,
	hpmax = 8,
	tohit = 25,
	dmgmin = 1,
	dmgmax = 4,
	expvalue = 210,
}

NPC{
	proto = "skeleton_archer",
	name = "burning dead archer",
	intf = 2,
	color = LIGHTRED,
	flags = {nfUndead,nfMagicImmune,nfFireResist,nfSkeleton},
	level = 7,
	group = {3,4,5},
	hpmin = 5,
	hpmax = 12,
	tohit = 30,
	ac = 5,
	dmgmin = 1,
	dmgmax = 6,
	expvalue = 364,
}

NPC{
	proto = "skeleton_archer",
	name = "horror archer",
	intf = 3,
	color = DARKGRAY,
	flags = {nfUndead,nfMagicImmune,nfLightningResist,nfSkeleton},
	level = 9,
	group = {4,5,6},
	hpmin = 7,
	hpmax = 22,
	tohit = 35,
	ac = 15,
	dmgmin = 2,
	dmgmax = 9,
	expvalue = 594,
}

--== SCAVENGERS =====================================================--

Prototype{
	proto = "monster",
	pid = "scavenger_base",
	ai = AIScavenger,
	flags = {nfAnimal},
	amountmin = 3,
	amountmax = 7,
	pic = "v",
	size = 410,
	corpse = "bloody_corpse",
	spdmov = 40,
	spdatk = 60,
	spdhit = 30,
	sound = "sound/monsters/scav/scav"
}

NPC{
	proto = "scavenger_base",
	name = "scavenger",
	intf = 0,
	color = RED,
	level = 2,
	group = {1,2,3},
	hpmin = 1,
	hpmax = 3,
	tohit = 20,
	ac = 10,
	dmgmin = 1,
	dmgmax = 5,
	expvalue = 80,
}

NPC{
	proto = "scavenger_base",
	name = "plague eater",
	intf = 1,
	color = BROWN,
	level = 4,
	group = {2,3,4},
	hpmin = 6,
	hpmax = 12,
	tohit = 30,
	ac = 20,
	dmgmin = 1,
	dmgmax = 8,
	expvalue = 188,
}

NPC{
	proto = "scavenger_base",
	name = "shadow beast",
	intf = 2,
	color = BLUE,
	level = 6,
	group = {3,4,5},
	hpmin = 12,
	hpmax = 18,
	tohit = 35,
	ac = 25,
	dmgmin = 3,
	dmgmax = 12,
	expvalue = 375,
}

NPC{
	proto = "scavenger_base",
	name = "bone gasher",
	intf = 3,
	color = WHITE,
	flags = {nfAnimal,nfMagicResist},
	level = 8,
	group = {4,5,6},
	hpmin = 14,
	hpmax = 20,
	tohit = 35,
	ac = 30,
	dmgmin = 5,
	dmgmax = 15,
	expvalue = 552,
}

--== FALLEN ONES ====================================================--

Prototype{
	proto = "monster",
	pid = "fallen_base",
	ai = AIFallenOne,
	flags = {nfAnimal},
	pic = "o",
	corpse = "bloody_corpse",
	spdhit = 55,
	spdatk = 65,
	amountmin = 2,
	amountmax = 5,
}

Prototype{
	proto = "fallen_base",
	pid = "fallen_spear",
	size = 543,
	spdmov = 55,
	spdatk2 = 65,
	sound = "sound/monsters/falspear/phall",
}

Prototype{
	proto = "fallen_base",
	pid = "fallen_sword",
	size = 623,
	spdmov = 60,
	spdatk2 = 75,
	sound = "sound/monsters/falsword/fall",
}

NPC{
	proto = "fallen_spear",
	id = "fallen_one_spear",
	name = "fallen one",
	intf = 0,
	color = BROWN,
	level = 1,
	group = {1,2,3},
	hpmin = 1,
	hpmax = 2,
	tohit = 15,
	ac = 0,
	dmgmin = 1,
	dmgmax = 3,
	expvalue = 46,
	retreatdistance = 7,
	warcrydistance = 4,
	warcrytime = 525,
}

NPC{
	proto = "fallen_sword",
	id = "fallen_one_sword",
	name = "fallen one",
	intf = 0,
	color = BROWN,
	group = {1,2,3},
	level = 1,
	hpmin = 1,
	hpmax = 2,
	tohit = 15,
	ac = 10,
	dmgmin = 1,
	dmgmax = 4,
	expvalue = 52,
	retreatdistance = 7,
	warcrydistance = 4,
	warcrytime = 525,
}

NPC{
	proto = "fallen_spear",
	id = "carver_spear",
	name = "carver",
	intf = 2,
	color = BLUE,
	group = {2,3},
	level = 3,
	hpmin = 2,
	hpmax = 4,
	ac = 5,
	tohit = 20,
	dmgmin = 2,
	dmgmax = 5,
	expvalue = 80,
	retreatdistance = 5,
	warcrydistance = 5,
	warcrytime = 675,
}

NPC{
	proto = "fallen_sword",
	id = "carver_sword",
	name = "carver",
	intf = 1,
	color = BLUE,
	level = 3,
	group = {2,3},
	hpmin = 2,
	hpmax = 4,
	ac = 15,
	tohit = 20,
	dmgmin = 2,
	dmgmax = 7,
	expvalue = 90,
	retreatdistance = 5,
	warcrydistance = 5,
	warcrytime = 675,
}

NPC{
	proto = "fallen_spear",
	id = "devil_kin_spear",
	name = "devil kin",
	flags = {nfAnimal,nfFireResist},
	intf = 2,
	color = LIGHTRED,
	group = {2,3,4},
	level = 5,
	hpmin = 6,
	hpmax = 12,
	ac = 10,
	tohit = 25,
	dmgmin = 3,
	dmgmax = 7,
	expvalue = 155,
	retreatdistance = 3,
	warcrydistance = 6,
	warcrytime = 825,
}

NPC{
	proto = "fallen_sword",
	id = "devil_kin_sword",
	name = "devil kin",
	flags = {nfAnimal,nfFireResist},
	intf = 2,
	color = LIGHTRED,
	group = {2,3,4},
	level = 5,
	hpmin = 8,
	hpmax = 12,
	ac = 20,
	tohit = 25,
	dmgmin = 4,
	dmgmax = 10,
	expvalue = 180,
	retreatdistance = 3,
	warcrydistance = 6,
	warcrytime = 825,
}

NPC{
	proto = "fallen_spear",
	id = "dark_one_spear",
	name = "dark one",
	flags = {nfAnimal,nfLightningResist},
	intf = 3,
	color = LIGHTBLUE,
	group = {3,4,5},
	level = 7,
	hpmin = 10,
	hpmax = 18,
	ac = 15,
	tohit = 30,
	dmgmin = 4,
	dmgmax = 8,
	expvalue = 255,
	retreatdistance = 2,
	warcrydistance = 7,
	warcrytime = 975,
}

NPC{
	proto = "fallen_sword",
	id = "dark_one_sword",
	name = "dark one",
	flags = {nfAnimal,nfLightningResist},
	intf = 3,
	color = LIGHTBLUE,
	group = {3,4,5},
	level = 7,
	hpmin = 12,
	hpmax = 18,
	ac = 25,
	tohit = 30,
	dmgmin = 4,
	dmgmax = 12,
	expvalue = 280,
	retreatdistance = 2,
	warcrydistance = 7,
	warcrytime = 975,
}

--== WINGED FIENDS ==================================================--

Prototype{
	proto = "monster",
	pid = "winged_fiend",
	ai = AIWingedFiend,
	flags = {nfAnimal},
	amountmin = 1,
	amountmax = 4,
	pic = "b",
	size = 364,
	corpse = "",
	spdmov = 65,
	spdhit = 45,
	spdatk = 50,
	sound = "sound/monsters/bat/bat",

	OnDrop = function()
		-- Jarulf 3.8.1: "Some monster types (Winged Fiends and Hork Spawns) never drop items."
	end,
}

NPC{
	proto = "winged_fiend",
	name = "fiend",
	intf = 0,
	color = RED,
	level = 3,
	group = {2,3},
	hpmin = 1,
	hpmax = 3,
	tohit = 35,
	ac = 0,
	dmgmin = 1,
	dmgmax = 6,
	expvalue = 102,
}

NPC{
	proto = "winged_fiend",
	name = "blink",
	intf = 1,
	color = BLUE,
	level = 7,
	group = {3,4,5},
	hpmin = 6,
	hpmax = 14,
	tohit = 45,
	ac = 15,
	dmgmin = 1,
	dmgmax = 8,
	expvalue = 340,

	OnHit = function(self,tgt)
		local x, y
		if tgt then
			x, y = tgt.x, tgt.y
		else
			x, y = self.x, self.y
		end
		self.targetx, self.targety = level.find_nearest( coord.new(x, y), cfNoMonsters, cfNoObstacles):get()
		if self:is_visible() then
			ui.msg(self:get_name(0)..' teleports.')
		end
		self:move( self:get_target() )
		self.scount = self.scount - self.spdmov
	end,
}

NPC{
	proto = "winged_fiend",
	name = "gloom",
	intf = 2,
	color = DARKGRAY,
	flags = {nfAnimal,nfMagicResist},
	level = 9,
	group = {4,5,6},
	hpmin = 14,
	hpmax = 18,
	tohit = 35,
	ac = 35,
	dmgmin = 4,
	dmgmax = 12,
	expvalue = 509,
}

NPC{
	proto = "winged_fiend",
	name = "familiar",
	flags = {nfDemon,nfMagicResist,nfLightningImmune},
	intf = 3,
	color = YELLOW,
	level = 13,
	group = {6,7,8},
	hpmin = 10,
	hpmax = 17,
	tohit = 50,
	ac = 35,
	dmgmin = 4,
	dmgmax = 16,
	expvalue = 448,
}

--== GOATS ==========================================================--

Prototype{
	proto = "monster",
	pid = "goat",
	ai = AIGoat,
	flags = {nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "g",
	size = 1030,
	corpse = "corpse",
	spdmov = 40,
	spdhit = 30,
	spdatk = 60,
	sound = "sound/monsters/goatmace/goat",
}

NPC{
	proto = "goat",
	name = "flesh clan",
	intf = 0,
	color = BROWN,
	level = 1,
	group = {4,5,6},
	hpmin = 15,
	hpmax = 22,
	tohit = 50,
	ac = 40,
	dmgmin = 4,
	dmgmax = 10,
	expvalue = 460,
}

NPC{
	proto = "goat",
	name = "stone clan",
	intf = 1,
	color = LIGHTGRAY,
	level = 10,
	group = {5,6,7},
	flags = {nfDemon, nfOpenDoors, nfMagicResist},
	hpmin = 20,
	hpmax = 27,
	tohit = 60,
	ac = 40,
	dmgmin = 6,
	dmgmax = 12,
	expvalue = 685,
}

NPC{
	proto = "goat",
	name = "fire clan",
	intf = 2,
	color = RED,
	level = 12,
	group = {6,7,8},
	flags = {nfDemon, nfOpenDoors, nfFireResist},
	hpmin = 25,
	hpmax = 32,
	tohit = 70,
	ac = 45,
	dmgmin = 8,
	dmgmax = 16,
	expvalue = 906,
}

NPC{
	proto = "goat",
	name = "night clan",
	intf = 3,
	color = DARKGRAY,
	level = 14,
	group = {7,8,9},
	flags = {nfDemon, nfOpenDoors, nfMagicResist},
	hpmin = 27,
	hpmax = 35,
	tohit = 80,
	ac = 50,
	dmgmin = 10,
	dmgmax = 20,
	expvalue = 1190,
}

-- goat archers --

Prototype{
	proto = "monster",
	pid = "goat_archer",
	ai = AIGoatArcher,
	flags = {nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "A",
	size = 1040,
	corpse = "corpse",
	spdmov = 40,
	spdhit = 30,
	spdatk = 80,
	sound = "sound/monsters/goatbow/goatb",
}

NPC{
	proto = "goat_archer",
	name = "flesh clan archer",
	intf = 0,
	color = BROWN,
	level = 8,
	group = {4,5,6},
	hpmin = 10,
	hpmax = 17,
	tohit = 35,
	ac = 35,
	dmgmin = 1,
	dmgmax = 7,
	expvalue = 448,
}

NPC{
	proto = "goat_archer",
	name = "stone clan archer",
	intf = 1,
	color = LIGHTGRAY,
	level = 8,
	group = {5,6,7},
	flags = {nfDemon, nfOpenDoors, nfMagicResist},
	hpmin = 15,
	hpmax = 20,
	tohit = 40,
	ac = 35,
	dmgmin = 2,
	dmgmax = 9,
	expvalue = 645,
}


NPC{
	proto = "goat_archer",
	name = "fire clan archer",
	intf = 2,
	color = RED,
	level = 8,
	group = {6,7,8},
	flags = {nfDemon, nfOpenDoors, nfFireResist},
	hpmin = 20,
	hpmax = 25,
	tohit = 45,
	ac = 35,
	dmgmin = 3,
	dmgmax = 11,
	expvalue = 822,
}


NPC{
	proto = "goat_archer",
	name = "night clan archer",
	intf = 3,
	color = DARKGRAY,
	level = 8,
	group = {7,8,9},
	flags = {nfDemon, nfOpenDoors, nfMagicResist},
	hpmin = 25,
	hpmax = 32,
	tohit = 50,
	ac = 40,
	dmgmin = 4,
	dmgmax = 13,
	expvalue = 1092,
}


--== HIDDENS ========================================================--

Prototype{
	proto = "monster",
	pid = "hidden_base",
	ai = AIHidden,
	flags = {nfDemon, nfInvisible},
	amountmin = 1,
	amountmax = 4,
	pic = "n",
	size = 992,
	corpse = "corpse",
	spdmov = 40,
	spdhit = 40,
	spdatk = 60,
	sound = "sound/monsters/sneak/sneak",
}

NPC{
	proto = "hidden_base",
	name = "hidden",
	intf = 0,
	color = DARKGRAY,
	level = 5,
	group = {2,3,4,5},
	hpmin = 4,
	hpmax = 12,
	tohit = 35,
	ac = 25,
	dmgmin = 3,
	dmgmax = 6,
	expvalue = 278,
}

NPC{
	proto = "hidden_base",
	name = "stalker",
	intf = 1,
	color = MAGENTA,
	level = 9,
	group = {5,6,7},
	hpmin = 4,
	hpmax = 15,
	tohit = 40,
	ac = 30,
	dmgmin = 8,
	dmgmax = 16,
	expvalue = 630,
}

NPC{
	proto = "hidden_base",
	name = "unseen",
	intf = 2,
	color = LIGHTGRAY,
	level = 11,
	group = {6,7,8},
	flags = {nfDemon, nfInvisible, nfMagicResist},
	hpmin = 4,
	hpmax = 17,
	tohit = 45,
	ac = 30,
	dmgmin = 12,
	dmgmax = 20,
	expvalue = 935,
}

NPC{
	proto = "hidden_base",
	name = "illusion weaver",
	intf = 3,
	color = YELLOW,
	level = 13,
	group = {8,9,10},
	flags = {nfDemon, nfInvisible, nfInvulnerable, nfMagicResist, nfFireResist},
	hpmin = 20,
	hpmax = 30,
	tohit = 60,
	ac = 30,
	dmgmin = 16,
	dmgmax = 24,
	expvalue = 1500,
}

--== Overlords ======================================================--

Prototype{
	proto = "monster",
	pid = "overlord_base",
	ai = AIOverlord,
	flags = {nfDemon},
	amountmin = 1,
	amountmax = 4,
	pic = "O",
	size = 1130,
	corpse = "corpse",
	spdmov = 50,
	spdhit = 30,
	spdatk = 75,
	sound = "sound/monsters/fat/fat",
}

NPC{
	proto = "overlord_base",
	name = "overlord",
	intf = 0,
	color = RED,
	level = 10,
	group = {5,6,7},
	hpmin = 30,
	hpmax = 40,
	tohit = 55,
	ac = 55,
	dmgmin = 6,
	dmgmax = 12,
	expvalue = 635,
}

NPC{
	proto = "overlord_base",
	name = "mud man",
	intf = 1,
	color = BLUE,
	level = 14,
	group = {7,8,9},
	hpmin = 50,
	hpmax = 62,
	tohit = 60,
	ac = 60,
	dmgmin = 8,
	dmgmax = 16,
	expvalue = 1165,
}

NPC{
	proto = "overlord_base",
	name = "toad demon",
	intf = 2,
	color = BROWN,
	level = 16,
	group = {8,9,10},
	flags = {nfDemon, nfMagicImmune},
	hpmin = 67,
	hpmax = 80,
	tohit = 70,
	ac = 65,
	dmgmin = 8,
	dmgmax = 16,
	expvalue = 1380,
}

NPC{
	proto = "overlord_base",
	name = "flayed one",
	intf = 3,
	color = LIGHTRED,
	level = 20,
	group = {10,11,12},
	flags = {nfDemon, nfMagicResist, nfFireImmune},
	hpmin = 80,
	hpmax = 100,
	tohit = 85,
	ac = 70,
	dmgmin = 10,
	dmgmax = 20,
	expvalue = 2058,
}

--== Horned Demons ==================================================--

Prototype{
	proto = "monster",
	pid = "horned_base",
	ai = AIHornedDemon,
	flags = {nfAnimal, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "J",
	size = 1630,
	corpse = "corpse",
	spdmov = 40,
	spdhit = 30,
	spdatk = 70,
	sound = "sound/monsters/rhino/rhino",
}

NPC{
	proto = "horned_base",
	name = "horned demon",
	intf = 0,
	color = LIGHTGRAY,
	level = 13,
	group = {7,8,9},
	hpmin = 20,
	hpmax = 40,
	tohit = 60,
	ac = 40,
	dmgmin = 2,
	dmgmax = 16,
	expvalue = 1172,
}

NPC{
	proto = "horned_base",
	name = "mud runner",
	intf = 0,
	color = BROWN,
	level = 15,
	group = {8,9,10},
	hpmin = 25,
	hpmax = 45,
	tohit = 60,
	ac = 40,
	dmgmin = 2,
	dmgmax = 16,
	expvalue = 1404,
}

NPC{
	proto = "horned_base",
	name = "frost charger",
	flags = {nfAnimal, nfLightningResist, nfMagicImmune, nfOpenDoors},
	intf = 0,
	color = BLUE,
	level = 17,
	group = {9,10,11},
	hpmin = 30,
	hpmax = 50,
	tohit = 60,
	ac = 40,
	dmgmin = 2,
	dmgmax = 16,
	expvalue = 1720,
}

NPC{
	proto = "horned_base",
	name = "obsidian lord",
	flags = {nfAnimal, nfLightningResist, nfMagicImmune, nfOpenDoors},
	intf = 0,
	color = DARKGRAY,
	level = 19,
	group = {10,11,12},
	hpmin = 35,
	hpmax = 55,
	tohit = 60,
	ac = 40,
	dmgmin = 2,
	dmgmax = 16,
	expvalue = 1809,
}

--== Magma Demons ===================================================--

Prototype{
	proto = "monster",
	pid = "magma_base",
	ai = AIOverlord,
	flags = {nfDemon, nfMagicImmune, nfLightningImmune, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "M",
	size = 1680,
	corpse = "corpse",
	spdmov = 50,
	spdhit = 35,
	spdatk = 70,
	sound = "sound/monsters/magma/magma",
}

NPC{
	proto = "magma_base",
	name = "magma demon",
	intf = 0,
	color = RED,
	level = 13,
	group = {8,9},
	hpmin = 25,
	hpmax = 35,
	tohit = 45,
	ac = 45,
	dmgmin = 2,
	dmgmax = 10,
	expvalue = 1076,
}

NPC{
	proto = "magma_base",
	name = "blood stone",
	intf = 1,
	color = YELLOW,
	level = 14,
	group = {8,9,10},
	hpmin = 28,
	hpmax = 37,
	tohit = 50,
	ac = 45,
	dmgmin = 2,
	dmgmax = 12,
	expvalue = 1309,
}

NPC{
	proto = "magma_base",
	name = "hell stone",
	intf = 2,
	color = BLUE,
	level = 16,
	group = {9,10,11},
	hpmin = 30,
	hpmax = 40,
	tohit = 60,
	ac = 50,
	dmgmin = 2,
	dmgmax = 20,
	expvalue = 1680,
}

NPC{
	proto = "magma_base",
	name = "lava lord",
	intf = 3,
	color = LIGHTBLUE,
	level = 18,
	group = {9,10,11},
	hpmin = 35,
	hpmax = 42,
	tohit = 75,
	ac = 60,
	dmgmin = 4,
	dmgmax = 24,
	expvalue = 2124,
}

--== Gargoyles ======================================================--

Prototype{
	proto = "monster",
	pid = "gargoyle_base",
	ai = AIScavenger,
	flags = {nfDemon, nfMagicImmune, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "G",
	size = 1650,
	corpse = "corpse",
	spdmov = 70,
	spdatk = 70,
	spdhit = 50,
	sound = "sound/monsters/gargoyle/gargoyle"
}

NPC{
	proto = "gargoyle_base",
	name = "winged demon",
	intf = 0,
	color = RED,
	level = 9,
	group = {5,6,7},
	flags = {nfDemon, nfMagicImmune, nfFireResist, nfOpenDoors},
	hpmin = 22,
	hpmax = 30,
	tohit = 50,
	ac = 45,
	dmgmin = 10,
	dmgmax = 16,
	expvalue = 662,
}

NPC{
	proto = "gargoyle_base",
	name = "gargoyle",
	intf = 1,
	color = BROWN,
	level = 13,
	group = {7,8,9},
	flags = {nfDemon, nfMagicImmune, nfLightningResist, nfOpenDoors},
	hpmin = 30,
	hpmax = 45,
	tohit = 60,
	ac = 45,
	dmgmin = 10,
	dmgmax = 16,
	expvalue = 1205,
}

NPC{
	proto = "gargoyle_base",
	name = "blood claw",
	intf = 2,
	color = LIGHTRED,
	level = 19,
	group = {9,10,11},
	flags = {nfDemon, nfMagicImmune, nfFireImmune, nfOpenDoors},
	hpmin = 37,
	hpmax = 62,
	tohit = 80,
	ac = 50,
	dmgmin = 14,
	dmgmax = 22,
	expvalue = 1873,
}

NPC{
	proto = "gargoyle_base",
	name = "death wing",
	intf = 3,
	color = BLUE,
	level = 23,
	group = {10,11,12},
	flags = {nfDemon, nfMagicImmune, nfLightningImmune, nfOpenDoors},
	hpmin = 45,
	hpmax = 75,
	tohit = 95,
	ac = 60,
	dmgmin = 16,
	dmgmax = 28,
	expvalue = 2278,
}

--== Spitting Terrors ===============================================--

Prototype{
	proto = "monster",
	pid = "spitting_base",
	ai = AISkeleton,
	flags = {nfAnimal},
	amountmin = 1,
	amountmax = 4,
	pic = "d",
	size = 716,
	corpse = "corpse",
	spdmov = 40,
	spdatk = 60,
	spdhit = 40,
	sound = "sound/monsters/acid/acid"
}

NPC{
	proto = "spitting_base",
	name = "acid beast",
	intf = 0,
	color = BROWN,
	level = 11,
	group = {6,7,8},
	hpmin = 20,
	hpmax = 33,
	tohit = 40,
	ac = 30,
	dmgmin = 4,
	dmgmax = 12,
	expvalue = 846,
}

NPC{
	proto = "spitting_base",
	name = "poison spitter",
	intf = 1,
	color = DARKGRAY,
	level = 15,
	group = {8,9,10},
	hpmin = 30,
	hpmax = 42,
	tohit = 45,
	ac = 30,
	dmgmin = 4,
	dmgmax = 16,
	expvalue = 1248,
}

NPC{
	proto = "spitting_base",
	name = "pit beast",
	intf = 2,
	color = BLUE,
	level = 21,
	group = {10,11,12},
	flags = {nfAnimal, nfMagicResist},
	hpmin = 40,
	hpmax = 55,
	tohit = 55,
	ac = 35,
	dmgmin = 8,
	dmgmax = 18,
	expvalue = 2060,
}

NPC{
	proto = "spitting_base",
	name = "lava maw",
	intf = 3,
	color = RED,
	level = 25,
	group = {12,13,14},
	flags = {nfAnimal, nfMagicResist, nfFireImmune},
	hpmin = 50,
	hpmax = 75,
	tohit = 65,
	ac = 35,
	dmgmin = 10,
	dmgmax = 20,
	expvalue = 2940,
}

--== Mages ==========================================================--

Prototype{
	proto = "monster",
	pid = "mage_base",
	ai = AIMage,
	flags = {nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "m",
	size = 2000,
	corpse = "corpse",
	spdmov = 5,
	spdatk = 100,
	spdhit = 40,
	sound = "sound/monsters/mage/mage"
}

--== Balrogs ========================================================--

Prototype{
	proto = "monster",
	pid = "balrog_base",
	ai = AISkeleton,
	flags = {nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "W",
	size = 2200,
	corpse = "corpse",
	spdmov = 35,
	spdatk = 70,
	spdhit = 5,
	sound = "sound/monsters/mega/mega"
}

--== Lightning Demons ===============================================--

Prototype{
	proto = "monster",
	pid = "lightning_base",
	ai = AISkeleton,
	flags = {nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "L",
	size = 1740,
	corpse = "corpse",
	spdmov = 40,
	spdatk = 90,
	spdhit = 20,
	sound = "sound/monsters/thin/thin"
}

--== Vipers =========================================================--

Prototype{
	proto = "monster",
	pid = "viper_base",
	ai = AISkeleton,
	flags = {nfDemon},
	amountmin = 1,
	amountmax = 4,
	pic = "V",
	size = 1270,
	corpse = "corpse",
	spdmov = 55,
	spdatk = 65,
	spdhit = 25,
	sound = "sound/monsters/snake/snake"
}

--== Succubi ========================================================--

Prototype{
	proto = "monster",
	pid = "succubus_base",
	ai = AISkeleton,
	flags = {nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "f",
	size = 980,
	corpse = "corpse",
	spdmov = 40,
	spdatk = 80,
	spdhit = 35,
	sound = "sound/monsters/succ/succ"
}

--== Knights ========================================================--

Prototype{
	proto = "monster",
	pid = "knight_base",
	ai = AISkeleton,
	flags = {nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "k",
	size = 2120,
	corpse = "corpse",
	spdmov = 40,
	spdatk = 80,
	spdhit = 20,
	sound = "sound/monsters/dark/dark"
}

--== Golem ==========================================================--

Prototype{
	proto = "monster",
	pid = "golem_base",
	ai = AIGolem,
	flags = {},
	amountmin = 1,
	amountmax = 4,
	pic = "y",
	size = 386,
	corpse = "corpse",
	spdmov = 80,
	spdatk = 60,
	spdhit = 0,
	sound = "sound/monsters/golem/golem",

	OnDrop = function()
	end,
}

--== Guardian =======================================================--

Prototype{
	proto = "monster",
	pid = "guardian_base",
	ai = AIGuardian,
	flags = {nfInvulnerable},
	amountmin = 1,
	amountmax = 4,
	pic = "Y",
	size = 386,
	corpse = "",
	spdmov = 0,
	spdatk = 80,
	spdhit = 0,
	sound = "",

	OnDrop = function()
	end,
}

--== Butcher ========================================================--

Prototype{
	proto = "monster",
	pid = "butcher_base",
	ai = AIButcher,
	flags = {nfDemon},
	amountmin = 1,
	amountmax = 4,
	pic = "B",
	size = 2000,
	corpse = "corpse",
	spdmov = 40,
	spdhit = 30,
	spdatk = 60,
	sound = "sound/monsters/fatc/fatc",
}

--== Leoric =========================================================--

Prototype{
	proto = "monster",
	pid = "leoric_base",
	ai = AILeoric,
	flags = {nfUndead, nfOpenDoors, nfMagicImmune, nfFireResist, nfLightningResist},
	amountmin = 1,
	amountmax = 4,
	pic = "K",
	size = 1010,
	corpse = "corpse",
	spdmov = 30,
	spdhit = 30,
	spdatk = 80,
	sound = "sound/monsters/sking/sking",
}

--== Diablo ==========================================================--

Prototype{
	proto = "monster",
	pid = "diablo_base",
	ai = AISkeleton,
	flags = {nfUndead, nfDemon, nfOpenDoors},
	amountmin = 1,
	amountmax = 4,
	pic = "D",
	size = 2000,
	corpse = "corpse",
	spdmov = 30,
	spdhit = 30,
	spdatk = 80,
	sound = "sound/monsters/diablo/diablo",
}

-- Create implicit bones cells
-- One type of bones for each skeleton
-- This allows the correct type of skeleton to be revived by Leoric
for _, n in ipairs(npcs) do
	if (n.corpse == "bones") then
		local c = {proto = "bones", id = "bones_" .. n.id}
		Cell(c)
		n.corpse = c.id
	end
end


