-- These algorithms (should be) based on Jarulf 5.5 Monster AI
-- especially 5.5.9 AI scripts
--
-- NOTE: LUA math.random(x) returns a number in the range 1 to x
-- Jarulf algorithms use Rnd[x] in the range 0 to x-1

declare("ai_scripts")
ai_scripts = {}

declare("AI")
function AI(id,props)
	ai_scripts[id] = props
end

AI(AINPC,{
	-- Default NPC AI does nothing
	-- Override OnAct in the NPC class
	OnAct = function()
	end,
})

AI(AIZombie,{
	OnAct = function(self)
		local intf = self.intf
		local roll = math.random(100) - 1
		local chance = 2*intf+10
		local dist_max = 2*intf+3

		if roll < chance then
			local target = self:target_closest( dist_max )
			if target then
				local dist = self:distance( target:get_position() )
				if dist == 1 then
					self:attack( target:get_position() )
				else
					self:seek( target:get_position() )
				end
			else
				roll = math.random(100) - 1
				if roll < chance then
					self.targetx, self.targety = level.find_nearest( self:get_position(), cfNoMonsters, cfNoObstacles):get()
					if self.targetx*self.targety ~= 0 then
						self:seek( self:get_target() )
					end
				end
			end
		end
	end,
})

AI(AIFallenOne,{
	-- aistate
	--	0: general
	--	1: last action was delay
	--  2: war cry mode
	--	3: retreat mode
	-- aistate2
	--	retreat mode: distance left to walk
	--	war cry mode: time remaining
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			local npc = npcs[self.id]
			local intf = self.intf
			local scount = self.scount
			local roll
			if self.aistate == 0 or self.aistate == 1 then
				if scount == 100 then
					if math.random(4) == 1 then
						-- Begin war cry
						-- TODO: self.play_sound to avoid repeating sound name formulation code from tnpc.play_sound
						ui.play_sound(npc.sound .. "s" .. math.random(2) .. ".wav",self.x,self.y)
						ui.msg(self:get_name(0)..' shouts!')
						-- activate all fallen within range (including self)
						level.broadcast_event(self:get_position(),npc.warcrydistance,"war_cry")
						return
					end
				end
				roll = math.random(100) - 1
			elseif self.aistate == 3 then
				-- retreat
				-- TODO: improve seek_away. it currently gives up when a wall is reached
				self:seek_away(target:get_position())
				self.aistate2 = self.aistate2 - 1
				if self.aistate2 == 0 then
					-- retreated enough, go back to normal
					self.aistate = 0
				end
				return
			end

			local dist = self:distance(target:get_position())
			if dist <= 1 then
				if self.aistate > 0 or roll < 2*intf + 20 then
					-- attack target
					self:attack(target:get_position())
					if (self.aistate == 1) then
						self.aistate = 0
					end
				else
					-- do delay
					self.aistate = 1
					self.scount = scount - ((math.random(10) + 9 - 2*intf) * 5)
				end
			else
				if self.aistate > 0 or roll < 4*intf + 65 then
					-- move toward target
					self:seek(target:get_position())
					if self.aistate == 1 then
						self.aistate = 0
					end
				else
					-- do delay
					self.aistate = 1
					self.scount = scount - ((math.random(10) + 14 - 2*intf) * 5)
				end
			end

			if self.aistate == 2 then
				-- scount is the elapsed time of 1 tick + current action if any
				scount = 10 + (scount - self.scount)
				if (self.aistate2 <= scount) then
					-- war cry expired
					self.aistate = 0
					self.aistate2 = 0
				else
					self.aistate2 = self.aistate2 - scount
				end
			end
		end
	end,

	OnBroadcast = function( self, event )
		if event == "war_cry" then
			if self.aistate ~= 2 then
				-- Enter war cry state
				self.aistate = 2
				self.hp = math.min(self.hpmax,self.hp + 2*self.intf + 2)
				self.aistate2 = npcs[self.id].warcrytime
			end
		elseif event == "death_nerby" then
			if self.aistate ~= 3 then
				-- Enter retreat state
				self.aistate = 3
				self.aistate2 = npcs[self.id].retreatdistance
			end
		end
	end,
})

AI(AISkeleton,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			local roll = math.random(100) - 1
			local intf = self.intf
			local dist = self:distance( target:get_position() )
			if dist <= 1 and (self.aistate == 1 or roll < 2*intf+20) then
				self:attack( target:get_position() )
				self.aistate = 0
				return
			end
			if dist > 1 and (self.aistate == 1 or roll < 2*intf+65) then
				self:seek( target:get_position() )
				self.aistate = 0
				return
			end
			self.aistate = 1
			self.scount = self.scount - ((math.random(10) + 9 - 2*intf) * 5)
		end
	end,
})

AI(AISkelArcher,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			local roll = math.random(100) - 1
			local intf = self.intf
			local dist = self:distance( target:get_position() )
			local chance = 2 * intf + 13
			if dist <= 3 then
				if (self.aistate == 0 and roll < chance + 50) or
					(self.aistate > 1 and roll < chance) then
					self:seek_away( target:get_position() )
					self.aistate = 0
				end
				self.aistate = math.min( self.aistate + 1, 2 )
			elseif roll < chance then
				self:send_missile( MT_ARROW, target:get_position() )
			end
		end
	end,
})

AI(AIScavenger,{
	-- aistate
	--	0: general
	--	1: last action was delay
	--	2: eating/digging
	-- aistate2: boolean true = carcass not found
	OnAct = function(self)
		local intf = self.intf
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			if self.aistate == 0 or self.aistate == 1 then
				-- general
				if ( 2 * self.hp < self.hpmax ) then
					if (self.aistate2 == 0) then
						self.aistate = 2
						return
					end
				end
				self.aistate2 = 0
				local dist = self:distance(target:get_position())
				local roll = math.random(100) - 1
				if (dist <= 1) then
					if ((self.aistate > 0) or (roll < (2*intf + 20))) then
						-- attack target
						self:attack(target:get_position())
						self.aistate = 0
					else
						-- do delay
						self.aistate = 1
						self.scount = self.scount - ((math.random(10) + 9 - 2*intf) * 5)
					end
				else
					if ((self.aistate > 0) or (roll < (4*intf + 65))) then
						-- move toward target
						self:seek(target:get_position())
						self.aistate = 0
					else
						-- do delay
						self.aistate = 1
						self.scount = self.scount - ((math.random(10) + 14 - 2*intf) * 5)
					end
				end
			else
				-- eating/digging
				local cell = cells[level.get_cell(self:get_position())]
				if (cell.proto and (cell.proto.pid == 'corpse_base')) then
					-- standing on a carcass, feed
					self.flags[nfNoHeal] = true
					ui.play_sound(npcs[self.id].sound .. "a" .. math.random(2) .. ".wav",self.x,self.y)
					self.hp = self.hp + 1
					if 4 * self.hp > 3 * self.hpmax then
						-- healed enough, go back to normal mode
						self.aistate = 0
						-- remove carcass
						level.set_cell(self:get_position(),"bloody_floor")
					end
					-- do delay
					-- regeneration speed: 1.82 seconds per hit point (Jarulf 5.1)
					self.scount = self.scount - 182
				else
					-- seek nearest carcass
					self.flags[nfNoHeal] = false
					local c = level.find_nearest(self:get_position(),cfCorpse)
					if c then
						self:seek( c )
					else
						-- no carcass found
						-- fall back to general AI for a turn
						self.aistate = 1
						self.aistate2 = 1
					end
				end
			end
		end
	end,
})

AI(AIWingedFiend,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			local roll = math.random(100) - 1
			local intf = self.intf
			local dist = self:distance( target:get_position() )
			if dist == 1 then
				if self.aistate == 2 then
					self:seek_away( target:get_position() )
					self.aistate = 1
				elseif roll < 4*intf + 8 then
					self:attack( target:get_position() )
					self.aistate = 2
				else
					self.aistate = 0
				end
			--[[elseif dist > 3 and intf == 2 then
				self.flags[ nfCharge ] = true ]]
			elseif ( self.aistate < 2 ) and ( roll <= 13 + intf + 50 * self.aistate ) then
				self:seek( target:get_position() )
				self.aistate = 1
			else
				self.aistate = 0
			end
		end
	end,
})

AI(AIHidden,{
	OnHit = function(self)
	  self.aistate = 2
	end,

	OnAct = function(self)
		local target = self:target_closest(15)
		if target then
			local roll = math.random(100) - 1
			local intf = self.intf
			local dist = self:distance( target:get_position() )

			if self.aistate == 2 then
				if dist + intf < 8  then
					self:seek_away( target:get_position() )
				end
				if self.hp == self.hpmax then
					self.aistate = 0
				end
			elseif dist + intf < 5 and self.flags[ nfInvisible ] then
				if self:is_visible() then
					ui.msg(self:get_name(0)..' appears.')
				end
				self.flags[ nfInvisible ]    = false
				self.flags[ nfInvulnerable ] = false
				self.scount = self.scount - 55
			elseif dist + intf > 5 and not self.flags[ nfInvisible ] then
				if self:is_visible() then
					ui.msg(self:get_name(0)..' disappears.')
				end
				self.flags[ nfInvisible ] = true
				if intf == 3 then
					self.flags[ nfInvisible ] = true
				end
				self.scount = self.scount - 55
			elseif ( dist == 1 ) and ( roll < 4 * intf + 10 ) then
				self:attack( target:get_position() )
				self.aistate = 0
			elseif ( dist > 1 ) and ( roll < intf + 14 + self.aistate * 50 ) then
				self:seek( target:get_position() )
				self.aistate = 1
			else
				self.aistate = 0
			end
		end
	end,
})

AI(AIGoat,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			local roll = math.random(100) - 1
			local intf = self.intf
			local dist = self:distance( target:get_position() )
			if dist == 1 then
				if roll < 2 * intf + 23 then
					if 2 * self.hp >= self.hpmax or math.random(2) == 1 then
						self:attack( target:get_position() )
					else
						ui.msg(self:get_name(0)..' spins.')
						-- TODO: Special attack has different to-hit and dmg
--[[ Jarulf: "Goat Men have a second spinning attack. They will only perform this attack once their HP gets low (see chapter 5.5.9). Flesh,
Stone and Fire Clan have a base To Hit of 0, 85 and 120 for the three difficulty levels while the damage is 0-0, 4-4 and 6-6.
Night Clan have a base To Hit of 15, 100 and 135 while the damage is 30-30, 64-64 and 126-126." --]]
					end
					self.scount = self.scount - self.spdatk
				end
			elseif dist <= 3 or math.random(4) > 1 or not self:is_visible() then
				if roll < intf + 28 + self.aistate * 50 then
					self.aistate = 1
					self:seek( target:get_position() )
				else
					self.aistate = 0
				end
			else
				self:circle( target:get_position() )
			end
		end
	end,
})

AI(AIGoatArcher,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if target then
				if self:is_visible() then
					local roll = math.random(100) - 1
					local intf = self.intf
					local dist = self:distance( target:get_position() )
					if dist <= 3 and roll < 2*intf+70 then
						self:seek_away( target:get_position() )
					else
						self:send_missile( MT_ARROW, target:get_position() )
					end
					return
				end
			end
			self:seek( self:get_target() )
		end
	end,
})

AI(AIOverlord,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			local roll = math.random(100) - 1
			local intf = self.intf
			local dist = self:distance( target:get_position() )
			if dist <= 1 and (self.aistate == 1 or roll < 2*intf+20) then
				self:attack( target:get_position() )
				self.aistate = 0
				return
			end
			if dist > 1 and (self.aistate == 1 or roll < 2*intf+65) then
				self:seek( target:get_position() )
				self.aistate = 0
				return
			end
			self.aistate = 1
			self.scount = self.scount - ((math.random(10) + 9 - 2*intf) * 5)
		end
	end,
})

AI(AIHornedDemon, {
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if self.flags[nfCharge] then
				self:seek( self:get_target() )
				self.aistate = 0
			elseif target then
				local roll = math.random(100)-1
				local intf = self.intf
				local dist = self:distance( target:get_position() )

				if dist == 1 then
					if roll < 2 * intf + 28 then
						self:attack(target:get_position() )
						self.aistate = 0
					else
						self.aistate = self.aistate + 1
					end
				elseif dist < 4 then
					if self.aistate == 0 and roll < 2 * intf + 33 then
						self:seek( target:get_position() )
						self.aistate = 0
					elseif self.aistate > 0 and roll < 2 * intf + 83 then
						self:seek( target:get_position() )
						self.aistate = 0
					else
						self.scount = self.scount - ((math.random(10) + 10) * 5)
						self.aistate = self.aistate + 1
					end
				else
					if math.random(4) > 2 then
						self:circle( target:get_position() )
						self.aistate = 0
						return
					end
					if self.aistate == 0 and roll < 2 * intf + 33 then
						if self:can_charge( target:get_position() ) then
							self.flags[nfCharge] = true
							self.aistate = 0
						end
						self:seek( self:get_target() )
					elseif self.aistate > 0 and roll < 2 * intf + 83 then
						self:seek( target:get_position() )
						self.aistate = 0
					else
						self.scount = self.scount - ((math.random(10) + 10) * 5)
						self.aistate = self.aistate + 1
					end

				end
			end
		end
	end,

	OnAttack = function(self, tgt)
		if self.flags[nfCharge] then
			tgt:knockback( self:get_position() )
		end
	end
})

AI(AIMage, {
	-- aistate
	--	0: general
	--	1: last action was delay
	--  2: retreat mode

	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if not target then return end
			local dist = self:distance( target:get_position() )
			local roll = math.random(100) - 1
			local intf = self.intf

			if self.aistate == 2 then
			--retreat mode
				if dist < 3 then
					self:seek_away( target:get_position () )
					NPC_Spells["mage_fadeout"](self)
					return
				else
					self.aistate = 0
					NPC_Spells["mage_fadein"](self)
					return
				end
			end
			if dist == 1 then
				if self.flags[nfInvisible] then
					NPC_Spells["mage_fadein"](self)
					return
				elseif self.hp*2 < self.hpmax then
					self.aistate = 2
				elseif self.aistate == 1 then
					self:cast_spell('flash')
					self.aistate = 0
				elseif roll < 2 * intf + 20  then
					self:cast_spell('flash')
					self.aistate = 0
				else
					self.aistate = 1
					self.scount = self.scount - math.random(5) + 5 - intf
					return
				end
			else
				if self:is_visible() and roll < 5 * intf + 50 then
					if self.flags[nfInvisible] then
						NPC_Spells["mage_fadein"](self)
						return
					end
					self:cast_spell('fireball')
					self.aistate = 0
					return
				else
					if math.random(100) > 30 then
						NPC_Spells["mage_fadein"](self)
						self.aistate = 1
						self.scount = self.scount - math.random(5) + 5 - intf
						return
					else
						NPC_Spells["mage_fadeout"](self)
						self:circle( target:get_position() )
						self.aistate = 0
						return
					end
				end
			end
		end
	end,
})

--== Unique AI scripts ==--

AI(AIButcher,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if target then
				if self:distance( target:get_position() ) <= 1 then
					self:attack( target:get_position() )
				else
					self:seek( target:get_position() )
				end
			else
				self:seek( self:get_target() )
			end
		end
	end,
})

AI(AIGolem,{
	OnAct = function(self)
		if self:is_active() then
			local target = self:target_closest(15)
			if target then
				if self:distance( target:get_position() ) <= 1 then
					self:attack( target:get_position() )
				else
					self:seek( target:get_position() )
				end
			else
				self:seek( player:get_position() )
			end
		end
	end,
})

AI(AIGuardian,{
	OnAct = function(self)
	-- aistate means player's firebolt spell level
		local target = self:target_closest(15)
		if target then
			self:cast_spell('firebolt', self.aistate)
			self.hp = math.max(self.hp - 80,0)
		else
			self.hp = math.max(self.hp - 5,0)
		end
		if self.hp == 0 then
			self.scount = 0
			self:die()
		end
	end,
})

AI(AILeoric,{

	OnAct = function(self)
	-- aistate
		--	0: general
		--	1: last action was delay
		--	2: circle walk
		if not self:is_active() then
			return
		end

		local roll = math.random(100) - 1
		if self:is_visible() then
			local target = self:target_closest(15)
			if not target then return end
			local dist = self:distance(target:get_position())
			if dist <= 2 then
				if roll < 5 then
					NPC_Spells["leoric_revive"](self)
					return
				elseif dist == 1 then
					if roll < 2*self.intf + 20 then
						-- attack target
						self:attack(target:get_position())
						self.aistate = 0
					end
					return
				end
			else
				if self.aistate < 2 and math.random(4) == 1 then
					-- start circle walk
					self.aistate = 2
					self.aistate2 = 2 * dist
					self:circle(self:get_target())
					return
				elseif roll < 4*self.intf + 35 then
					NPC_Spells["leoric_revive"](self)
					return
				end
			end
		end
		if self.aistate == 0 then
			if roll < self.intf + 75 then
				self:seek(self:get_target())
			end
		elseif self.aistate == 1 then
			if roll < (self.intf + 25) then
				self:seek(self:get_target())
				self.aistate = 0
			end
		elseif self.aistate == 2 then
			self.aistate2 = self.aistate2 - 1
			if self.aistate2 == 0 then
				-- enough circling, go back to normal
				self.aistate = 0
			end
			self:circle(self:get_target())
		else
			self.aistate = 1
			self.scount = scount - ((math.random(10) + 9) * 5)
		end
	end,
})
