declare("DropMonster")
function DropMonster(id,x,y)
	local m, c
	if (x == nil) then
		c = level.find_empty_coord("floor", cfNoItems, cfNoMonsters)
	else
		c = level.find_near_coord(coord.new(x, y), 2, cfNoItems, cfNoMonsters)
	end
	if c then
		m = level.drop_npc(id, c )
		return c.x,c.y,m
	end
end

declare("DropGold")
function DropGold(x,y)
	local c
	if (x == nil) then
		c = level.find_empty_coord("floor", cfNoItems, cfNoMonsters)
	else
		c = level.find_near_coord(coord.new(x, y), 2, cfNoItems, cfNoMonsters)
	end
	if c then
		level.drop_gold(c.x, c.y)
	end
	return c.x,c.y
end

Generator{
	name = "default",
	OnPlaceMonsters = function(lvl,groups)
		local monster_size = 4000-386 -- golem
		local full_list = table.icopy( npcs["level"..lvl] )

		if (levels[lvl].monsters_list == nil) then
			-- TODO: preload this list with base monster of any quest uniques appearing on the level
			levels[lvl].monsters_list = {}
		end

		if #full_list == 0 then
			error("Monster table for level "..lvl.." is empty!")
		end

		while #full_list > 0 do
			local roll = math.random(#full_list)
			if npcs[ full_list[roll] ].size <= monster_size then
				table.insert( levels[lvl].monsters_list, full_list[roll] )
				monster_size = monster_size - npcs[ full_list[roll] ].size
			end
			table.remove( full_list, roll )
		end

		if #levels[lvl].monsters_list == 0 then
			error("Monster table for level "..lvl.." generated empty!")
		end

		-- Jarulf 3.11
		-- "There are assumed to exist 185 monsters on all levels with the exception of level
		--  1 and 2 that are a bit smaller and thus has a somewhat less monsters."
		-- However observed counts are much lower e.g. level 1 = 123 monsters
		local count=0
		if (lvl < 3) then
			count = 125
		else
			count = 150
		end

		-- spawn the random uniques Jarulf 5.3.2
		-- "8. If any monster type that was picked has a unique monster set to appear on the
		--  dlvl in question, that unique monster will always appear.
		for _, n in ipairs(npcs["unique_list"]) do
			if (npcs[n].random and npcs[n].dlvl == lvl) then
				-- found a possible unique
				-- see if it's in the monster list
				for _, m in ipairs(levels[lvl].monsters_list) do
					if (npcs[n].proto.id == m) then
						log(n)
						local x,y = DropMonster(n)
						count = count - 1
						if (npcs[n].mob) then
						-- Jarulf 5.4: "The monsters of that mob also have the same special
						-- ability (AI script) as their boss and have their HP doubled"
							for i=1,7+math.random(5) do
								local ax, ay, m = DropMonster(m,x,y)
								m.hp    = m.hp * 2
								m.hpmax = m.hpmax * 2
								m.ai    = npcs[n].ai
								count = count - 1
							end
						end
						break
					end
				end
			end
		end

		repeat
			local monster = npcs[ table.random( levels[lvl].monsters_list ) ]
			local amount  = math.random( monster.amountmin, monster.amountmax )
			local x,y = DropMonster(monster.id)
			if (x) then
				if amount > 1 then
					for j=2,amount do
						DropMonster(monster.id,x,y)
						count = count - 1
					end
				end
			else
				error("no room to place monster!")
			end
		until count <= 0
	end,
}


Generator{
	name = "church",

	OnPlaceItems = function(lvl)
		local drop = function( id )
			level.set_cell( level.find_empty_square(), id )
		end
		local library = function()
			local x1,y1 = level.find_empty_square():get()
			local x2,y2 = x1,y1
			local cell_floor = cells['floor'].id
			while level.get_cell( coord.new( x1,y1-1 ) ) == cell_floor do y1 = y1 - 1 end
			while level.get_cell( coord.new( x2,y2+1 ) ) == cell_floor do y2 = y2 + 1 end
			while level.get_cell( coord.new( x1-1,y1 ) ) == cell_floor do x1 = x1 - 1 end
			while level.get_cell( coord.new( x2+1,y2 ) ) == cell_floor do x2 = x2 + 1 end
			if (x2-x1<2)or(y2-y1<2) then return end
			-- limit size of library
			local limit = math.random(2,6)
			if ((x2 - x1) > limit) then
				x2 = x1 + limit
			end
			if (limit < 4) then
				limit = 4
			else
				limit = math.random(2,6)
			end
			if ((y2 - y1) > limit) then
				y2 = y1 + limit
			end
			local bookshelf = true
			for y = y1+1,y2-1 do
				for x = x1+1, x2-1 do
					if ((y-y1)%2 == 1)and((x-x1)%2==1) then
						local c = coord.new(x,y)
						if level.get_cell(c) == cell_floor then
							if bookshelf then
								-- library always has one bookshelf
								level.set_cell(c,"bookshelf")
								bookshelf = false
							elseif math.random(10)<6 then
								level.set_cell(c,"library_book")
							else
								level.set_cell(c,"open_book")
			end end end end end
		end
		for i=1,math.random(2,4) do
			library()
		end

		for i=1,10 do drop( "sarcophagus" ) end

		-- Jarulf 3.1.1: Each level will average 7 small chests, 4 chests, 2.5 large chests
		for i=1,math.random(6,8) do
			drop( "small_chest" )
		end
		for i=1,math.random(3,5) do
			drop( "medium_chest" )
		end
		for i=1,math.random(2,3) do
			drop( "large_chest" )
		end

		for i=1,math.random(-1,3) do
			drop( level.random_shrine() )
		end
		--treasure room
		if math.random(2) == 1 then
			local x,y = DropGold()
			for i = 1, math.random(6,10) do
				x,y = DropGold(x, y)
			end
			for i = 1, math.random(-1,3) do
				local c = level.find_near_coord(coord.new(x, y), 2, cfNoItems, cfNoMonsters)
				if c then
					level.drop_random_scroll(c.x, c.y)
				end
			end
		end
		--random potions
		for i = 1, math.random(2,4) do
			local c = level.find_empty_coord("floor", cfNoItems, cfNoMonsters)
			if c then
				level.drop_random_potion(c.x, c.y)
			end
		end
		--random magical items
		for i = 0, math.random(0, math.ceil(level.level() / 4)) do
			local c = level.find_empty_coord("floor", cfNoItems, cfNoMonsters)
			if c then
				level.drop_random_item(c.x, c.y, levels[level.level()].depth * 2, 100)
			end
		end

		for i=1,8 do
			local c = level.find_empty_square()
			local count = math.random(5)
			for k=1,count do
				c = level.find_near_coord( c, 2, cfNoItems, cfNoMonsters )
				if c then
					level.set_cell( c, "barrel" )
				else
					break
				end
			end
		end
	end,
	OnPlaceMonsters = generators["default"].OnPlaceMonsters
}

Generator{
	name = "catacombs",

	OnPlaceItems = function(lvl)
		local drop = function( id )
			level.set_cell( level.find_empty_square(), id )
		end
		local library = function()
			local x1,y1 = level.find_empty_square():get()
			local x2,y2 = x1,y1
			local cell_floor = cells['floor'].id
			while level.get_cell( coord.new( x1,y1-1 ) ) == cell_floor do y1 = y1 - 1 end
			while level.get_cell( coord.new( x2,y2+1 ) ) == cell_floor do y2 = y2 + 1 end
			while level.get_cell( coord.new( x1-1,y1 ) ) == cell_floor do x1 = x1 - 1 end
			while level.get_cell( coord.new( x2+1,y2 ) ) == cell_floor do x2 = x2 + 1 end
			if (x2-x1<2)or(y2-y1<2) then return end
			-- limit size of library
			local limit = math.random(2,6)
			if ((x2 - x1) > limit) then
				x2 = x1 + limit
			end
			if (limit < 4) then
				limit = 4
			else
				limit = math.random(2,6)
			end
			if ((y2 - y1) > limit) then
				y2 = y1 + limit
			end
			local bookshelf = true
			for y = y1+1,y2-1 do
				for x = x1+1, x2-1 do
					if ((y-y1)%2 == 1)and((x-x1)%2==1) then
						local c = coord.new(x,y)
						if level.get_cell(c) == cell_floor then
							if bookshelf then
								-- library always has one bookshelf
								level.set_cell(c,"bookshelf")
								bookshelf = false
							elseif math.random(10)<6 then
								level.set_cell(c,"library_book")
							else
								level.set_cell(c,"open_book")
			end end end end end
		end
		for i=1,math.random(2,4) do
			library()
		end

		-- Jarulf 3.1.1: Each level will average 7 small chests, 4 chests, 2.5 large chests
		for i=1,math.random(6,8) do
			drop( "small_chest" )
		end
		for i=1,math.random(3,5) do
			drop( "medium_chest" )
		end
		for i=1,math.random(2,3) do
			drop( "large_chest" )
		end

		for i=1,math.random(-1,3) do
			drop( "weapon_rack" )
		end

		for i=1,math.random(-1,3) do
			drop( "armor_rack" )
		end

		for i=1,math.random(-1,3) do
			drop( level.random_shrine() )
		end
		--treasure room
		if math.random(2) == 1 then
			local x,y = DropGold()
			for i = 1, math.random(6,10) do
				x,y = DropGold(x, y)
			end
			for i = 1, math.random(-1,3) do
				local c = level.find_near_coord(coord.new(x,y), 2, cfNoItems, cfNoMonsters)
				if c then
					level.drop_random_scroll(c.x, c.y)
				end
			end
		end
		--random potions
		for i = 1, math.random(2,4) do
			local c = level.find_empty_coord("floor", cfNoItems, cfNoMonsters)
			if c then
				level.drop_random_potion(c.x, c.y)
			end
		end
		--random magical items
		for i = 0, math.random(0, math.ceil(level.level() / 4)) do
			local c = level.find_empty_coord("floor", cfNoItems, cfNoMonsters)
			if c then
				level.drop_random_item(c.x, c.y, levels[level.level()].depth * 2, 100)
			end
		end

		for i=1,8 do
			local c = level.find_empty_square()
			local count = math.random(5)
			for k=1,count do
				c = level.find_near_coord( c, 2, cfNoItems, cfNoMonsters )
				if c then
					level.set_cell( c, "barrel" )
				else
					break
				end
			end
		end
	end,

	OnPlaceMonsters = generators["default"].OnPlaceMonsters
}
