-- WEAPON TYPE - PROTOTYPES -------------------------------

Prototype{
  pid = "weapon",
  type = TYPE_WEAPON,
  sound2 = "sound/sfx/items/flipswor.wav",
  sound1 = "sound/sfx/items/invsword.wav"
}

Prototype{
  pid = "sword",
  proto = "weapon",
  flags = { ifWeakUndead, ifSlayAnimal },
  pic = "/",
  volume = 3
}

Prototype{
  pid = "club",
  proto = "weapon",
  flags = { ifSlayUndead, ifWeakAnimal },
  pic = "\\",
  volume = 3
}

Prototype{
  pid = "axe",
  iname = "axe",
  proto = "weapon",
  flags = { ifTwoHanded, ifAxe },
  pic = "+",
  volume = 6,
  sound2 = "sound/sfx/items/flipaxe.wav",
  sound1 = "sound/sfx/items/invaxe.wav"
}

Prototype{
  pid = "bow",
  iname = "bow",
  type = TYPE_BOW,
  double_random = true,
  flags = { ifTwoHanded },
  pic = "{",
  volume = 6,
  sound2 = "sound/sfx/items/flipbow.wav",
  sound1 = "sound/sfx/items/invbow.wav"
}

Prototype{
  pid = "staff",
  iname = "staff",
  type = TYPE_STAFF,
  flags = { ifTwoHanded },
  pic = "|",
  volume = 6,
  sound2 = "sound/sfx/items/flipstaf.wav",
  sound1 = "sound/sfx/items/invstaf.wav",

  OnCreate = function(self,ilvl)
	if self.spell ~= 0 then return end
    -- chance of staff carrying spell is 75% (Jarulf p. 43)
	if math.random(100) <= 75 then
  		-- pick spell based on ilvl
		local spell_list = {}
		for _,spell in ipairs(spells) do
			if spell.staff_level and spell.staff_level > 0 and spell.staff_level <= ilvl then
				table.insert(spell_list,spell)
			end
		end
		local spell = table.random( spell_list )

		-- apply spell
		self.name   = items[self.id].iname.." of "..spell.name
		self.spell  = spell.id
		self.magreq = spell.magic
		self.chargesmax = math.random(spell.charges_min, spell.charges_max)
		self.charges = self.chargesmax
	end
  end,
}

-- WEAPON TYPE - SWORD ------------------------------------

Item{
  name = "dagger",
  proto = "sword",
  damagemin = 1,
  damagemax = 4,
  durability = 16,
  price = 60,
  level = 1,
  volume = 2
}

Item{
  name = "short sword",
  iname = "sword",
  proto = "sword",
  damagemin = 2,
  damagemax = 6,
  durability = 20,
  price = 120,
  level = 1,
  minstr = 18
}

Item{
  name = "sword",
  proto = "sword",
  flags = { ifWeakUndead, ifSlayAnimal },
  no_random = true,
  damagemin = 1,
  damagemax = 5,
  durability = 8,
  price = 50,
  level = 1,
  minstr = 15,
  mindex = 20,
}

Item{
  name = "sabre",
  proto = "sword",
  damagemin = 1,
  damagemax = 8,
  durability = 45,
  price = 170,
  level = 1,
  minstr = 17
}

Item{
  name = "scimitar",
  proto = "sword",
  damagemin = 3,
  damagemax = 7,
  durability = 28,
  price = 200,
  level = 4,
  minstr = 23,
  mindex = 23
}

Item{
  name = "blade",
  proto = "sword",
  damagemin = 2,
  damagemax = 8,
  durability = 30,
  price = 280,
  level = 4,
  minstr = 25,
  mindex = 30
}

Item{
  name = "falchion",
  proto = "sword",
  damagemin = 4,
  damagemax = 8,
  durability = 20,
  price = 250,
  level = 6,
  minstr = 30
}

Item{
  name = "long sword",
  iname = "sword",
  proto = "sword",
  damagemin = 2,
  damagemax = 10,
  durability = 40,
  price = 350,
  level = 6,
  minstr = 40
}

Item{
  name = "claymore",
  proto = "sword",
  damagemin = 1,
  damagemax = 12,
  durability = 36,
  price = 450,
  level = 5,
  minstr = 35
}

Item{
  name = "broad sword",
  iname = "sword",
  proto = "sword",
  damagemin = 4,
  damagemax = 12,
  durability = 50,
  price = 750,
  level = 8,
  minstr = 45
}

Item{
  name = "bastard sword",
  iname = "sword",
  proto = "sword",
  damagemin = 6,
  damagemax = 15,
  durability = 60,
  price = 1000,
  level = 10,
  minstr = 50
}

Item{
  name = "two-handed sword",
  iname = "sword",
  proto = "sword",
  flags = {  ifWeakUndead, ifSlayAnimal, ifTwoHanded },
  damagemin = 8,
  damagemax = 16,
  durability = 75,
  price = 1800,
  level = 14,
  minstr = 65,
  volume = 6
}

Item{
  name = "great sword",
  iname = "sword",
  proto = "sword",
  flags = {  ifWeakUndead, ifSlayAnimal, ifTwoHanded },
  damagemin = 10,
  damagemax = 20,
  durability = 100,
  price = 3000,
  level = 17,
  minstr = 75,
  volume = 6
}

-- UNIQUE SWORDS ------------------------------------------

Item{
  name = "dagger",
  iname = "Black Razor",
  id	= "black_razor",
  proto = "sword",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  damagemin = 1,
  damagemax = 4,
  durability = 5,
  price = 2000,
  level = 1,
  volume = 2,
  vit = 2,
  dmgmodpercent = 150,
  durmod = -1,
}

Item{
  name = "claymore",
  iname = "the Bonesaw",
  id	= "the_bonesaw",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 1,
  damagemax = 12,
  durability = 36,
  price = 4400,
  level = 6,
  minstr = 35,
  str = 10,
  dex = -5,
  mag = -5,
  life = 10,
  mana = -10,
  dmgmod = 10,
}

Item{
  name = "sabre",
  iname = "the Defender",
  id	= "the_defender",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 1,
  damagemax = 8,
  durability = 45,
  price = 2000,
  level = 1,
  minstr = 17,
  armormin = 5,
  armormax = 5,
  vit = 5,
  tohit = -5,
}

Item{
  name = "bastard sword",
  iname = "Doombringer",
  id	= "doombringer",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 6,
  damagemax = 15,
  durability = 60,
  price = 18250,
  level = 19,
  minstr = 50,
  str = -5,
  mag = -5,
  dex = -5,
  vit = -5,
  life = -25,
  tohit = 25,
  dmgmodpercent = 250,
  lightmod = -20,
}

Item{
  name = "falchion",
  iname = "the Executioner's Blade",
  id	= "the_executioner's_blade",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 4,
  damagemax = 8,
  durability = 60,
  price = 7080,
  level = 3,
  minstr = 30,
  life = -10,
  dmgmodpercent = 150,
  lightmod = -10,
  durmod = 1,
}

Item{
  name = "scimitar",
  iname = "the Falcon's Talon",
  id	= "the_falcon's_talon",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 3,
  damagemax = 7,
  durability = 28,
  price = 7867,
  level = 15,
  minstr = 23,
  mindex = 23,
  dex = 10,
  tohit = 20,
  dmgmodpercent = -33,
  spdatk = SPD_FASTEST,
}

Item{
  name = "broad sword",
  iname = "Gibbous Moon",
  id	= "gibbous_moon",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 3,
  damagemin = 4,
  damagemax = 12,
  durability = 50,
  price = 6660,
  level = 2,
  minstr = 45,
  str = 2,
  mag = 2,
  dex = 2,
  vit = 2,
  mana = 15,
  dmgmodpercent = 25,
  lightmod = -30.
}

Item{
  name = "dagger",
  iname = "Gonnagal's Dirk",
  id	= "gonnagal's_dirk",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 1,
  damagemax = 4,
  durability = 16,
  price = 7040,
  level = 1,
  volume = 2,
  dex = -5,
  dmgmod = 4,
  --+25% fire resist
  spdatk = SPD_FAST
}

Item{
  name = "great sword",
  iname = "the Grandfather",
  id	= "the_grandfather",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 10,
  damagemax = 20,
  durability = 100,
  price = 119800,
  level = 27,
  minstr = 75,
  volume = 6,
  str = 5,
  mag = 5,
  dex = 5,
  vit = 5,
  life = 20,
  tohit = 20,
  dmgmodpercent = 70
}

Item{
  name = "two-handed sword",
  iname = "the Grizzly",
  id	= "the_grizzly",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique, ifTwoHanded },
  proto = "sword",
  damagemin = 8,
  damagemax = 16,
  durability = 150,
  price = 50000,
  level = 23,
  minstr = 65,
  volume = 6,
  str = 20,
  vit = -5,
  dmgmodpercent = 200,
  --knockback
  durmod = 1,
}

Item{
  name = "falchion",
  iname = "Gryphon's Claw",
  id	= "gryphon's_claw",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 4,
  damagemax = 8,
  durability = 20,
  price = 1000,
  level = 1,
  minstr = 30,
  mag = -2,
  dex = -5,
  dmgmodpercent = 100,
}

Item{
  name = "long sword",
  iname = "Ice Shank",
  id	= "ice_shank",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 2,
  damagemax = 10,
  durability = 15,
  price = 5250,
  level = 3,
  minstr = 40,
  --40% resist fire
  durmod = -1,

  OnCreate = function(self)
	self.str = math.random(5,10)
  end,
}
--[[
Item{
  name = "long sword",
  iname = "Inferno",
  id	= "inferno",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 2,
  damagemax = 10,
  durability = 40,
  price = 34600,
  level = 17,
  minstr = 40,
  mana = 20,
  --+75% resist fire
  --2-13 fire damage
  lightmod = 30,
}

Item{
  name = "sabre",
  iname = "Lightsabre",
  id	= "lightsabre",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 1,
  damagemax = 8,
  durability = 45,
  price = 19150,
  level = 13,
  minstr = 17,
  tohit = 20,
  --+50% resist lightning
  --1-10 lightning damage
  lightmod = 20,
}
]]
Item{
  name = "broad sword",
  iname = "Shadowhawk",
  id	= "shadowhawk",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 4,
  damagemax = 12,
  durability = 50,
  price = 13750,
  level = 8,
  minstr = 45,
  tohit = 15,
  --15% resist all,
  lifesteal = 5,
  lightmod = -20,
}

Item{
  name = "dagger",
  iname = "Wizardspike",
  id	= "wizardspike",
  flags = { ifWeakUndead, ifSlayAnimal, ifUnique },
  proto = "sword",
  damagemin = 1,
  damagemax = 4,
  durability = 16,
  price = 12920,
  level = 11,
  volume = 2,
  mag = 15,
  mana = 35,
  tohit = 25,
  --+15% resist all
}

-- WEAPON TYPE - BOW --------------------------------------

Item{
  name = "short bow",
  proto = "bow",
  damagemin = 1,
  damagemax = 4,
  durability = 30,
  price = 100,
  level = 1
}

Item{
  name = "long bow",
  proto = "bow",
  damagemin = 1,
  damagemax = 6,
  durability = 35,
  price = 250,
  level = 5,
  minstr = 25,
  mindex = 30
}

Item{
  name = "hunter's bow",
  proto = "bow",
  damagemin = 2,
  damagemax = 5,
  durability = 40,
  price = 350,
  level = 3,
  minstr = 20,
  mindex = 35
}

Item{
  name = "composite bow",
  proto = "bow",
  damagemin = 3,
  damagemax = 6,
  durability = 45,
  price = 600,
  level = 7,
  minstr = 25,
  mindex = 40
}

Item{
  name = "short battle bow",
  proto = "bow",
  damagemin = 3,
  damagemax = 7,
  durability = 45,
  price = 750,
  level = 9,
  minstr = 30,
  mindex = 50
}

Item{
  name = "long battle bow",
  proto = "bow",
  damagemin = 1,
  damagemax = 10,
  durability = 50,
  price = 1000,
  level = 11,
  minstr = 30,
  mindex = 60
}

Item{
  name = "short war bow",
  proto = "bow",
  damagemin = 4,
  damagemax = 8,
  durability = 55,
  price = 1500,
  level = 15,
  minstr = 35,
  mindex = 70
}

Item{
  name = "long war bow",
  proto = "bow",
  damagemin = 1,
  damagemax = 14,
  durability = 60,
  price = 2000,
  level = 19,
  minstr = 45,
  mindex = 80
}

-- UNIQUE BOWS --------------------------------------------

Item{
  name = "long bow",
  iname = "the Blackoak Bow",
  id	= "the_blackoak_bow",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 1,
  damagemax = 6,
  durability = 35,
  price = 2500,
  level = 5,
  minstr = 25,
  mindex = 30,
  dex = 10,
  vit = -10,
  dmgmodpercent = 50,
  lightmod = -10,
}

Item{
  name = "composite bow",
  iname = "Bow of the Dead",
  id	= "bow_of_the_dead",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 3,
  damagemax = 6,
  durability = 30,
  price = 2500,
  level = 5,
  minstr = 25,
  mindex = 40,
  vit = -3,
  dex = 4,
  tohit = 10,
  lightmod = -20,
  durmod = -1
}


Item{
  name = "long bow",
  iname = "the Celestial Bow",
  id	= "the_celestial_bow",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 1,
  damagemax = 6,
  durability = 35,
  price = 1200,
  level = 2,
  mindex = 30,
  armormin = 5,
  armormax = 5,
  dmgmod   = 2,
}

Item{
  name = "composite bow",
  iname = "Deadly Hunter",
  id	= "deadly_hunter",
  flags = { ifTwoHanded, ifUnique, ifBaneDemon },
  proto = "bow",
  damagemin = 3,
  damagemax = 6,
  durability = 45,
  price = 8750,
  level = 3,
  minstr = 25,
  mindex = 40,
  mag = -5,
  tohit = 20,
}

Item{
  name = "long battle bow",
  iname = "Eaglehorn",
  id	= "eaglehorn",
  flags = { ifTwoHanded, ifUnique, ifIndest },
  proto = "bow",
  damagemin = 1,
  damagemax = 10,
  durability = 50,
  price = 42500,
  level = 26,
  minstr = 30,
  mindex = 60,
  dex = 20,
  tohit = 50,
  dmgmodpercent = 100,
}
--[[
Item{
  name = "hunter's bow",
  iname = "Flamedart",
  id	= "flamedart",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 2,
  damagemax = 5,
  durability = 40,
  price = 14250,
  level = 10,
  minstr = 20,
  mindex = 35,
  tohit = 20,
  --+40% resist fire
  --1-6 fire arrows
}
]]
Item{
  name = "long bow",
  iname = "Fleshstinger",
  id	= "fleshstinger",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 1,
  damagemax = 6,
  durability = 37,
  price = 16500,
  level = 13,
  minstr = 25,
  mindex = 30,
  dex = 15,
  tohit = 40,
  dmgmodpercent = 80,
  durmod = 1,
}

Item{
  name = "short bow",
  iname = "the Needler",
  id	= "the_needler",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 1,
  damagemax = 3,
  durability = 30,
  price = 8900,
  level = 2,
  tohit = 50,
  spdatk = SPD_FAST,
}

Item{
  name = "short bow",
  iname = "the Rift Bow",
  id	= "the_rift_bow",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 1,
  damagemax = 4,
  durability = 30,
  price = 1800,
  level = 1,
  dex = -3,
  dmgmod = 2,
  --random speed arrows
}

Item{
  name = "long war bow",
  iname = "Windforce",
  id	= "windforce",
  flags = { ifTwoHanded, ifUnique },
  proto = "bow",
  damagemin = 1,
  damagemax = 14,
  durability = 60,
  price = 37750,
  level = 17,
  minstr = 45,
  mindex = 80,
  str = 5,
  dmgmodpercent = 200,
  --knockback
}

-- WEAPON TYPE - CLUB -------------------------------------

Item{
  name = "club",
  proto = "club",
  damagemin = 1,
  damagemax = 6,
  durability = 20,
  price = 20,
  level = 1
}

Item{
  name = "spiked club",
  proto = "club",
  damagemin = 3,
  damagemax = 6,
  durability = 20,
  price = 225,
  level = 4,
  minstr = 18
}

Item{
  name = "mace",
  proto = "club",
  damagemin = 1,
  damagemax = 8,
  durability = 32,
  price = 200,
  level = 2,
  minstr = 16
}

Item{
  name = "morning star",
  proto = "club",
  damagemin = 1,
  damagemax = 10,
  durability = 40,
  price = 300,
  level = 3,
  minstr = 26
}

Item{
  name = "flail",
  proto = "club",
  damagemin = 2,
  damagemax = 12,
  durability = 36,
  price = 500,
  level = 7,
  minstr = 30,
  volume = 6
}

Item{
  name = "war hammer",
  proto = "club",
  damagemin = 5,
  damagemax = 9,
  durability = 50,
  price = 600,
  level = 5,
  minstr = 40,
  volume = 6
}

Item{
  name = "maul",
  proto = "club",
  flags = { ifSlayUndead, ifWeakAnimal, ifTwoHanded },
  damagemin = 6,
  damagemax = 20,
  durability = 50,
  price = 900,
  level = 10,
  minstr = 55,
  volume = 6
}

-- UNIQUE CLUBS -------------------------------------------

Item{
  name = "morning star",
  iname = "Baranas's Star",
  id = "baranas's_star",
  flags = { ifSlayUndead, ifWeakAnimal, ifUnique },
  proto = "club",
  damagemin = 1,
  damagemax = 10,
  durability = 60,
  price = 6850,
  level = 5,
  minstr = 26,
  dex = -4,
  vit = 4,
  tohit = 12,
  dmgmodpercent = 80,
  spdatk = SPD_QUICK,
  durmod = 1,
}

Item{
  name = "flail",
  iname = "the Celestial Star",
  id = "the_celestial_star",
  flags = { ifSlayUndead, ifWeakAnimal, ifUnique },
  proto = "club",
  damagemin = 2,
  damagemax = 12,
  durability = 36,
  price = 7810,
  level = 2,
  volume = 6,
  armormin = -8,
  armormax = -8,
  dmgmod = 10,
  lightmod = 20,
}

Item{
  name = "mace",
  iname = "Civerb's Cudgel",
  id = "civerb's_cudgel",
  flags = { ifSlayUndead, ifWeakAnimal, ifUnique, ifBaneDemon },
  proto = "club",
  damagemin = 1,
  damagemax = 8,
  durability = 32,
  price = 2000,
  level = 1,
  minstr = 16,
  mag = -2,
  dex = -5,
}

Item{
  name = "mace",
  iname = "Crackrust",
  id = "crackrust",
  flags = { ifSlayUndead, ifWeakAnimal, ifUnique, ifIndest },
  proto = "club",
  damagemin = 1,
  damagemax = 8,
  durability = 32,
  price = 11375,
  level = 2,
  minstr = 16,
  str = 2,
  mag = 2,
  dex = 2,
  vit = 2,
  --+15% resist all
  dmgmodpercent = 50,
  spelllevel = -1,
}

Item{
  name = "maul",
  iname = "the Cranium Basher",
  id = "the_cranium_basher",
  flags = { ifSlayUndead, ifWeakAnimal, ifTwoHanded, ifUnique, ifIndest },
  proto = "club",
  damagemin = 6,
  damagemax = 20,
  durability = 50,
  price = 36500,
  level = 12,
  minstr = 55,
  volume = 6,
  str = 15,
  mana = -150,
  dmgmod = 20,
  --+5% resist all
}

Item{
  name = "mace",
  iname = "Dreamflange",
  id = "dreamflange",
  flags = { ifSlayUndead, ifWeakAnimal, ifUnique },
  proto = "club",
  damagemin = 1,
  damagemax = 8,
  durability = 32,
  price = 26450,
  level = 26,
  minstr = 16,
  mag = 30,
  mana = 50,
  --50% resist magic
  spelllevel = 1,
  lightmod = 20,
}

Item{
  name = "spiked club",
  iname = "Gnarled Root",
  id = "gnarled_root",
  flags = { ifSlayUndead, ifWeakAnimal, ifUnique },
  proto = "club",
  damagemin = 3,
  damagemax = 6,
  durability = 20,
  price = 9820,
  level = 9,
  minstr = 18,
  armormin = -10,
  armormax = -10,
  mag = 5,
  dex = 10,
  tohit = 20,
  --10% resist all
  dmgmodpercent = 300,
}


Item{
  name = "maul",
  iname = "Hammer of Jholm",
  id = "hammer_of_jholm",
  flags = { ifSlayUndead, ifWeakAnimal, ifTwoHanded, ifUnique, ifIndest },
  proto = "club",
  damagemin = 6,
  damagemax = 20,
  durability = 50,
  price = 8700,
  level = 1,
  minstr = 55,
  volume = 6,
  str = 3,
  tohit = 15,

  OnCreate = function(self)
	self.dmgmodpercent = math.random(4,10)
  end,
}
--[[
Item{
  name = "war hammer",
  iname = "Schaefer's Hammer",
  id = "schaefer's_hammer",
  flags = { ifSlayUndead, ifWeakAnimal, ifUnique },
  proto = "club",
  damagemin = 5,
  damagemax = 9,
  durability = 50,
  price = 56125,
  level = 16,
  minstr = 40,
  volume = 6,
  life = 50,
  --75% resist lightning
  tohit = 30,
  dmgmodpercent = -100,
  --1-50 lightning damage
  lightmod = 10,
}
]]
-- WEAPON TYPE - STAFF ------------------------------------

Item{
  name = "short staff",
  proto = "staff",
  damagemin = 2,
  damagemax = 4,
  durability = 25,
  price = 30,
  level = 1
}

Item{
  name = "long staff",
  proto = "staff",
  damagemin = 4,
  damagemax = 8,
  durability = 35,
  price = 100,
  level = 4
}

Item{
  name = "composite staff",
  proto = "staff",
  damagemin = 5,
  damagemax = 10,
  durability = 45,
  price = 500,
  level = 6
}

Item{
  name = "quarter staff",
  proto = "staff",
  damagemin = 6,
  damagemax = 12,
  durability = 55,
  price = 1000,
  level = 9,
  minstr = 20
}

Item{
  name = "war staff",
  proto = "staff",
  damagemin = 8,
  damagemax = 16,
  durability = 75,
  price = 1500,
  level = 12,
  minstr = 30
}

-- UNIQUE STAVES ------------------------------------------

Item{
  name = "staff of Firebolt",
  id   = "sorcerer_staff",
  proto = "staff",
  flags = { ifTwoHanded, ifSpellBound },
  no_random = true,
  damagemin = 2,
  damagemax = 4,
  durability = 25,
  price = 520,
  level = 1,
  spell = "firebolt",
  chargesmax = 40,

  OnCreate = function(self)
	self.dur = self.durmax
  end
}

Item{
  name = "short staff",
  iname = "Gleamsong",
  id	= "gleamsong",
  flags = { ifTwoHanded, ifUnique, ifSpellBound },
  proto = "staff",
  damagemin = 2,
  damagemax = 4,
  durability = 25,
  price = 6520,
  level = 8,
  spell = "phasing",
  charges = 10,
  chargesmax = 76,
  mana = 25,
  str = -3,
  vit = -3,
}
--[[
Item{
  name = "long staff",
  iname = "Immolator",
  id	= "immolator",
  flags = { ifTwoHanded, ifUnique },
  proto = "staff",
  damagemin = 4,
  damagemax = 8,
  durability = 35,
  price = 3900,
  level = 4,
  mana = 10,
  vit = -5,
  --resist fire 20%
  --4 fire damage
}
]]
Item{
  name = "quarter staff",
  iname = "Mindcry",
  id	= "mindcry",
  flags = { ifTwoHanded, ifUnique, ifSpellBound },
  proto = "staff",
  damagemin = 6,
  damagemax = 12,
  durability = 55,
  price = 41500,
  level = 20,
  minstr = 20,
  spell = "guardian",
  charges = 13,
  chargesmax = 69,
  mag = 15,
  --15% resist all,
  spelllevel = 1,
}

Item{
  name = "long staff",
  iname = "Naj's Puzzler",
  id	= "naj's_puzzler",
  flags = { ifTwoHanded, ifUnique, ifSpellBound },
  proto = "staff",
  damagemin = 4,
  damagemax = 8,
  durability = 35,
  price = 34000,
  level = 18,
  spell = "teleport",
  charges = 23,
  chargesmax = 57,
  mag = 20,
  dex = 10,
  --20% resist all
  life = -25,
}

Item{
  name = "short staff",
  iname = "the Protector",
  id	= "the_protector",
  flags = { ifTwoHanded, ifUnique, ifSpellBound },
  proto = "staff",
  damagemin = 2,
  damagemax = 4,
  durability = 25,
  price = 17240,
  level = 16,
  spell = "healing",
  charges = 2,
  chargesmax = 86,
  armormin = 40,
  armormax = 40,
  vit = 5,
  dmgtaken = -5,
  --1-3 damage to attacker (thorns)
}

Item{
  name = "war staff",
  iname = "Rod of Onan",
  id	= "rod_of_onan",
  flags = { ifTwoHanded, ifUnique, ifSpellBound },
  proto = "staff",
  damagemin = 8,
  damagemax = 16,
  durability = 75,
  price = 44167,
  level = 22,
  minstr = 30,
  spell = "golem",
  charges = 21,
  chargesmax = 50,
  str = 5,
  mag = 5,
  dex = 5,
  vit = 5,
  dmgmodpercent = 100,
}

Item{
  name = "long staff",
  iname = "Staff of Shadows",
  id	= "staff_of_shadows",
  flags = { ifTwoHanded, ifUnique },
  proto = "staff",
  damagemin = 4,
  damagemax = 8,
  durability = 35,
  price = 1250,
  level = 2,
  mag = -10,
  tohit = 10,
  dmgmodpercent = 60,
  lightmod = -20,
  spdatk = SPD_QUICK,
}
--[[
Item{
  name = "war staff",
  iname = "Storm Spire",
  id	= "storm_spire",
  flags = { ifTwoHanded, ifUnique },
  proto = "staff",
  damagemin = 8,
  damagemax = 16,
  durability = 75,
  price = 22500,
  level = 8,
  minstr = 30,
  str = 10,
  mag = -10,
  --50% resist lightning
  --2-8 lightning damage
}

Item{
  name = "composite staff",
  iname = "Thundercall",
  id	= "thundercall",
  flags = { ifTwoHanded, ifUnique, ifSpellBound },
  proto = "staff",
  damagemin = 5,
  damagemax = 10,
  durability = 45,
  price = 22250,
  level = 14,
  spell = "lightning",
  charges = 3,
  chargesmax = 76,
  tohit = 35,
  --1-10 lightning damage
  --30% resist lightning
  lightmod = 20,
}
]]
-- WEAPON TYPE - AXE --------------------------------------

Item{
  name = "small axe",
  proto = "axe",
  damagemin = 2,
  damagemax = 10,
  durability = 24,
  price = 150,
  level = 2
}

Item{
  name = "axe",
  proto = "axe",
  damagemin = 4,
  damagemax = 12,
  durability = 32,
  price = 450,
  level = 4,
  minstr = 22
}

Item{
  name = "large axe",
  proto = "axe",
  damagemin = 6,
  damagemax = 16,
  durability = 40,
  price = 750,
  level = 6,
  minstr = 30
}

Item{
  name = "broad axe",
  proto = "axe",
  damagemin = 8,
  damagemax = 20,
  durability = 50,
  price = 1000,
  level = 8,
  minstr = 50
}

Item{
  name = "battle axe",
  proto = "axe",
  damagemin = 10,
  damagemax = 25,
  durability = 60,
  price = 1500,
  level = 10,
  minstr = 65
}

Item{
  name = "great axe",
  proto = "axe",
  damagemin = 12,
  damagemax = 30,
  durability = 75,
  price = 2500,
  level = 12,
  minstr = 80
}

-- UNIQUE AXES --------------------------------------------

Item{
  name = "small axe",
  iname = "Aguinara's Hatchet",
  id = "aguinara's_hatchet",
  flags = { ifTwoHanded, ifAxe, ifUnique },
  proto = "axe",
  damagemin = 2,
  damagemax = 10,
  durability = 24,
  price = 24800,
  level = 12,
  mag = 10,
  --75% resist magic
  spelllevel = 1,
}

Item{
  name = "broad axe",
  iname = "Bloodslayer",
  id = "bloodslayer",
  flags = { ifTwoHanded, ifAxe, ifUnique, ifBaneDemon },
  proto = "axe",
  damagemin = 8,
  damagemax = 20,
  durability = 50,
  price = 2500,
  level = 3,
  str = -5,
  mag = -5,
  dex = -5,
  vit = -5,
  dmgmodpercent = 100,
  spelllevel = -1,
}

Item{
  name = "battle axe",
  iname = "the Celestial Axe",
  id = "the_celestial_axe",
  flags = { ifTwoHanded, ifAxe, ifUnique },
  proto = "axe",
  damagemin = 10,
  damagemax = 25,
  durability = 60,
  price = 14100,
  level = 4,
  str = -15,
  life = 15,
  tohit = 15
}

Item{
  name = "battle axe",
  iname = "Hellslayer",
  id = "hallslayer",
  flags = { ifTwoHanded, ifAxe, ifUnique },
  proto = "axe",
  damagemin = 10,
  damagemax = 25,
  durability = 60,
  price = 26200,
  level = 15,
  minstr = 65,
  str = 8,
  vit = 8,
  life = 25,
  mana = -25,
  dmgmodpercent = 100,
}

Item{
  name = "large axe",
  iname = "the Mangler",
  id = "the_mangler",
  flags = { ifTwoHanded, ifAxe, ifUnique },
  proto = "axe",
  damagemin = 6,
  damagemax = 16,
  durability = 40,
  price = 2850,
  level = 2,
  minstr = 30,
  mag = -5,
  dex = -5,
  mana = -10,
  dmgmodpercent = 200,
}

Item{
  name = "great axe",
  iname = "Messerschmidts Reaver",
  id = "messerschmidts_reaver",
  flags = { ifTwoHanded, ifAxe, ifUnique },
  proto = "axe",
  damagemin = 12,
  damagemax = 30,
  durability = 75,
  price = 58000,
  level = 25,
  minstr = 80,
  str = 5,
  mag = 5,
  dex = 5,
  vit = 5,
  life = -50,
  dmgmod = 15,
  dmgmodpercent = 200,
  --2-12 fire damage
}

Item{
  name = "large axe",
  iname = "Sharp Beak",
  id = "sharp_beak",
  flags = { ifTwoHanded, ifAxe, ifUnique },
  proto = "axe",
  damagemin = 6,
  damagemax = 16,
  durability = 40,
  price = 2850,
  level = 2,
  minstr = 30,
  mag = -10,
  life = 20,
  mana = -10
}

Item{
  name = "broad axe",
  iname = "Stonecleaver",
  id = "stonecleaver",
  flags = { ifTwoHanded, ifAxe, ifUnique },
  proto = "axe",
  damagemin = 8,
  damagemax = 20,
  durability = 50,
  price = 23900,
  level = 7,
  minstr = 50,
  life = 30,
  tohit = 20,
  dmgmodpercent = 50,
  --40% resist lightning
}

Item{
  name = "large axe",
  iname = "Wicked Axe",
  id = "wicked_axe",
  flags = { ifTwoHanded, ifAxe, ifUnique, ifIndest },
  proto = "axe",
  damagemin = 6,
  damagemax = 16,
  durability = 40,
  price = 750,
  level = 6,
  minstr = 30,
  dex = 10,
  vit = -10,
  tohit = 30,

  OnCreate = function(self)
    self.dmgtaken = math.random(1,6)
  end,
}
