--== POTIONS ===========================--

Prototype{
  pid = "potion",
  type = TYPE_POTION,
  pic = "!",
  volume = 1,
  sound2 = "sound/sfx/items/flippot.wav",
  sound1 = "sound/sfx/items/invpot.wav"
}

Item{
  id = "potion_healing",
  name = "potion of healing",
  proto = "potion",
  color = RED,
  price = 50,
  level = 1,

  OnUse = function(self,target)
    target:msg("You feel better.")
    local temp = target.hpmax / 4
    target.hp = math.min(target.hp + math.random( temp, 3* temp ),target.hpmax)
  end,
}

Item{
  id = "potion_mana",
  name = "potion of mana",
  proto = "potion",
  color = BLUE,
  price = 50,
  level = 1,

  OnUse = function(self,target)
    target:msg("You feel megical energies restoring.")
    local temp = target.mpmax / 4
    target.mp = math.min(target.mp + math.random( temp, 3* temp ),target.mpmax)
  end,
}

Item{
  id = "potion_full_healing",
  name = "potion of full healing",
  proto = "potion",
  color = LIGHTRED,
  price = 150,
  level = 1,

  OnUse = function(self,target)
    target:msg("You feel like new.")
    target.hp = target.hpmax
  end,
}

Item{
  id = "potion_full_mana",
  name = "potion of full mana",
  proto = "potion",
  color = LIGHTBLUE,
  price = 150,
  level = 1,

  OnUse = function(self,target)
    target:msg("You feel magically fully restored.")
    target.mp = target.mpmax
  end,
}

Item{
  id = "potion_rejuvenation",
  name = "potion of rejuvenation",
  proto = "potion",
  color = MAGENTA,
  price = 165,
  level = 3,

  OnUse = function(self,target)
    target:msg("You feel better.")
    local temp = target.hpmax / 4
    target.hp = math.min(target.hp + math.random( temp, 3* temp ),target.hpmax)
    temp = target.mpmax / 4
    target.mp = math.min(target.mp + math.random( temp, 3* temp ),target.mpmax)
  end,
}

Item{
  id = "potion_full_rejuvenation",
  name = "potion of full rejuvenation",
  proto = "potion",
  color = LIGHTMAGENTA,
  price = 375,
  level = 7,

  OnUse = function(self,target)
    target:msg("You feel like new.")
    target.hp = target.hpmax
    target.mp = target.mpmax
  end,
}

--== BOOKS =============================--

Prototype{
	pid = "book",
	name = "book",
	type = TYPE_BOOK,
	pic = '"',
	volume = 4,
	color = LIGHTBLUE,
	sound2 = "sound/sfx/items/flipbook.wav",
	sound1 = "sound/sfx/items/invbook.wav",

	OnCreate = function(self,ilvl)
		-- pick spell based on ilvl
		local spell_list = {}
		for _,spell in ipairs(spells) do
			if spell.book_level and spell.book_level > 0 and spell.book_level <= ilvl then
				table.insert(spell_list,spell)
			end
		end
		local spell = table.random( spell_list )

		-- apply spell
		self.name       = self.name.." of "..spell.name
		self.spell      = spell.id
		self.magreq     = spell.magic
		self.price      = spell.book_price
	end,
}

Item{
	id = "book2",
	proto = "book",
	level = 2,
}

Item{
	id = "book8",
	proto = "book",
	level = 8,
}

Item{
	id = "book14",
	proto = "book",
	level = 14,
}

Item{
	id = "book20",
	proto = "book",
	level = 20,
}
