--[[
TODO: Proper OnApply functions for the following Suffixes:
Corruption?, Piercing, Puncturing, Bashing, Ages?, Bear, Thieves, Thorns,
Devastation, Peril

Corruption, Ages may need editting.

Uncomment Flame and Lightning when game supports them
--]]

--== + Strength ==========================--

Suffix{
	name = " of Frailty",
	min = 6,
	max = 10,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	flags = { ifCursed },
	level = 3,
	multiplier = -3,

	OnApply = function(item,value)
		item.str = item.str - value
	end,
}

Suffix{
	name = " of Weakness",
	min = 1,
	max = 5,
	flags = { ifCursed },
	level = 1,
	multiplier = -2,

	OnApply = function(item,value)
		item.str = item.str - value
	end,
}

Suffix{
	name = " of Strength",
	min = 1,
	max = 5,
	level = 1,
	multiplier = 2,
	price_base = 200,
	price_max  = 1000,

	OnApply = function(item,value)
		item.str = item.str + value
	end,
}

Suffix{
	name = " of Might",
	min = 6,
	max = 10,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 5,
	multiplier = 3,
	price_base = 1200,
	price_max  = 2000,

	OnApply = function(item,value)
		item.str = item.str + value
	end,
}

Suffix{
	name = " of Power",
	min = 11,
	max = 15,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 11,
	multiplier = 4,
	price_base = 2200,
	price_max  = 3000,

	OnApply = function(item,value)
		item.str = item.str + value
	end,
}

Suffix{
	name = " of Giants",
	min = 16,
	max = 20,
	occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 17,
	multiplier = 7,
	price_base = 3200,
	price_max  = 5000,

	OnApply = function(item,value)
		item.str = item.str + value
	end,
}

Suffix{
	name = " of Titans",
	min = 21,
	max = 30,
	occurence = { TYPE_WEAPON, TYPE_RING, TYPE_AMULET },
	level = 23,
	multiplier = 10,
	price_base = 5200,
	price_max  = 10000,

	OnApply = function(item,value)
		item.str = item.str + value
	end,
}

--== + Magic ==========================--

Suffix{
	name = " of the Fool",
	min = 6,
	max = 10,
	flags = { ifCursed },
	level = 3,
	multiplier = -3,

	OnApply = function(item,value)
		item.mag = item.mag - value
	end,
}

Suffix{
	name = " of Dyslexia",
	min = 1,
	max = 5,
	flags = { ifCursed },
	level = 1,
	multiplier = -2,

	OnApply = function(item,value)
		item.mag = item.mag - value
	end,
}

Suffix{
	name = " of Magic",
	min = 1,
	max = 5,
	level = 1,
	multiplier = 2,
	price_base = 200,
	price_max  = 1000,

	OnApply = function(item,value)
		item.mag = item.mag + value
	end,
}

Suffix{
	name = " of the Mind",
	min = 6,
	max = 10,
	level = 5,
	multiplier = 3,
	price_base = 1200,
	price_max  = 2000,

	OnApply = function(item,value)
		item.mag = item.mag + value
	end,
}

Suffix{
	name = " of Brilliance",
	min = 11,
	max = 15,
	level = 11,
	multiplier = 4,
	price_base = 2200,
	price_max  = 3000,

	OnApply = function(item,value)
		item.mag = item.mag + value
	end,
}

Suffix{
	name = " of Sorcery",
	min = 16,
	max = 20,
	occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_STAFF, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 17,
	multiplier = 7,
	price_base = 3200,
	price_max  = 5000,

	OnApply = function(item,value)
		item.mag = item.mag + value
	end,
}

Suffix{
	name = " of Wizardry",
	min = 21,
	max = 30,
	occurence = { TYPE_STAFF, TYPE_RING, TYPE_AMULET },
	level = 23,
	multiplier = 10,
	price_base = 5200,
	price_max  = 10000,

	OnApply = function(item,value)
		item.mag = item.mag + value
	end,
}

--== + Dexterity ==========================--
Suffix{
	name = " of Paralysis",
	min = 6,
	max = 10,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_RING, TYPE_BOW, TYPE_AMULET },
	flags = { ifCursed },
	level = 3,
	multiplier = -3,

	OnApply = function(item,value)
		item.dex = item.dex - value
	end,
}

Suffix{
	name = " of Atrophy",
	min = 1,
	max = 5,
	flags = { ifCursed },
	level = 1,
	multiplier = -2,

	OnApply = function(item,value)
		item.dex = item.dex - value
	end,
}

Suffix{
	name = " of Dexterity",
	min = 1,
	max = 5,
	level = 1,
	multiplier = 2,
	price_base = 200,
	price_max  = 1000,

	OnApply = function(item,value)
		item.dex = item.dex + value
	end,
}

Suffix{
	name = " of Skill",
	min = 6,
	max = 10,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 5,
	multiplier = 3,
	price_base = 1200,
	price_max  = 2000,

	OnApply = function(item,value)
		item.dex = item.dex + value
	end,
}

Suffix{
	name = " of Accuracy",
	min = 11,
	max = 15,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 11,
	multiplier = 4,
	price_base = 2200,
	price_max  = 3000,

	OnApply = function(item,value)
		item.dex = item.dex + value
	end,
}

Suffix{
	name = " of Precision",
	min = 16,
	max = 20,
	occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 17,
	multiplier = 7,
	price_base = 3200,
	price_max  = 5000,

	OnApply = function(item,value)
		item.dex = item.dex + value
	end,
}

Suffix{
	name = " of Perfection",
	min = 21,
	max = 30,
	occurence = { TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 23,
	multiplier = 10,
	price_base = 5200,
	price_max  = 10000,

	OnApply = function(item,value)
		item.dex = item.dex + value
	end,
}

--== + Vitality ==========================--
Suffix{
	name = " of Illness",
	min = 6,
	max = 10,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	flags = { ifCursed },
	level = 3,
	multiplier = -3,

	OnApply = function(item,value)
		item.vit = item.vit - value
	end,
}

Suffix{
    name = " of Disease",
	min = 1,
	max = 5,
	flags = { ifCursed },
	level = 1,
	multiplier = -2,

	OnApply = function(item,value)
		item.vit = item.vit - value
	end,
}

Suffix{
	name = " of Vitality",
	min = 1,
	max = 5,
	level = 1,
	multiplier = 2,
 	price_base = 200,
	price_max  = 1000,

	OnApply = function(item,value)
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of Zest",
	min = 6,
	max = 10,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 5,
	multiplier = 3,
	price_base = 1200,
	price_max  = 2000,

	OnApply = function(item,value)
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of Vim",
	min = 11,
	max = 15,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 11,
	multiplier = 4,
	price_base = 2200,
	price_max  = 3000,

	OnApply = function(item,value)
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of Vigor",
	min = 16,
	max = 20,
	occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 17,
	multiplier = 7,
	price_base = 3200,
	price_max  = 5000,

	OnApply = function(item,value)
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of Life",
	min = 21,
	max = 30,
	occurence = { TYPE_RING, TYPE_AMULET },
	level = 23,
	multiplier = 10,
	price_base = 5200,
	price_max  = 10000,

	OnApply = function(item,value)
		item.vit = item.vit + value
	end,
}

--== + All Atribytes ==========================--

Suffix{
	name = " of Trouble",
	min = 6,
	max = 10,
	flags = { ifCursed },
	level = 12,
	multiplier = -10,

	OnApply = function(item,value)
		item.str = item.str - value
		item.mag = item.mag - value
		item.dex = item.dex - value
		item.vit = item.vit - value
	end,
}

Suffix{
	name = " of the Pit",
	min = 1,
	max = 5,
	flags = { ifCursed },
	level = 5,
	multiplier = -5,

	OnApply = function(item,value)
		item.str = item.str - value
		item.mag = item.mag - value
		item.dex = item.dex - value
		item.vit = item.vit - value
	end,
}

Suffix{
	name = " of the Sky",
	min = 1,
	max = 3,
	level = 5,
	multiplier = 5,
	price_base = 800,
	price_max  = 4000,

	OnApply = function(item,value)
		item.str = item.str + value
		item.mag = item.mag + value
		item.dex = item.dex + value
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of the Moon",
	min = 4,
	max = 7,
	level = 11,
	multiplier = 10,
	price_base = 4800,
	price_max  = 8000,

	OnApply = function(item,value)
		item.str = item.str + value
		item.mag = item.mag + value
		item.dex = item.dex + value
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of the Stars",
	min = 8,
	max = 11,
	occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 17,
	multiplier = 15,
	price_base = 8800,
	price_max  = 12000,

	OnApply = function(item,value)
		item.str = item.str + value
		item.mag = item.mag + value
		item.dex = item.dex + value
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of the Heavens",
	min = 12,
	max = 15,
	occurence = { TYPE_WEAPON, TYPE_BOW, TYPE_RING, TYPE_AMULET },
	level = 25,
	multiplier = 20,
	price_base = 12800,
	price_max  = 20000,

	OnApply = function(item,value)
		item.str = item.str + value
		item.mag = item.mag + value
		item.dex = item.dex + value
		item.vit = item.vit + value
	end,
}

Suffix{
	name = " of the Zodiac",
	min = 16,
	max = 20,
	occurence = { TYPE_RING, TYPE_AMULET },
	level = 30,
	multiplier = 30,
	price_base = 20800,
	price_max  = 40000,

	OnApply = function(item,value)
		item.str = item.str + value
		item.mag = item.mag + value
		item.dex = item.dex + value
		item.vit = item.vit + value
	end,
}

--== + Life ==========================--

Suffix{
	name = " of the Vulture",
	min = 11,
	max = 25,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	flags = { ifCursed },
	level = 4,
	multiplier = -4,

	OnApply = function(item,value)
		item.life = item.life - value
	end,
}

Suffix{
	name = " of the Jackal",
	min = 1,
	max = 10,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	flags = { ifCursed },
	level = 1,
	multiplier = -2,

	OnApply = function(item,value)
		item.life = item.life - value
	end,
}

Suffix{
	name = " of the Fox",
	min = 10,
	max = 15,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	level = 1,
	multiplier = 2,
	price_base = 100,
	price_max  = 1000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

Suffix{
	name = " of the Jaguar",
	min = 16,
	max = 20,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	level = 5,
	multiplier = 3,
	price_base = 1100,
	price_max  = 2000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

Suffix{
	name = " of the Eagle",
	min = 21,
	max = 30,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	level = 9,
	multiplier = 5,
	price_base = 2100,
	price_max  = 4000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

Suffix{
	name = " of the Wolf",
	min = 31,
	max = 40,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	level = 15,
	multiplier = 7,
	price_base = 4100,
	price_max  = 6000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

Suffix{
	name = " of the Tiger",
	min = 41,
	max = 50,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	level = 21,
	multiplier = 9,
	price_base = 6100,
	price_max  = 10000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

Suffix{
	name = " of the Lion",
	min = 51,
	max = 60,
	occurence = { TYPE_ARMOR, TYPE_RING, TYPE_AMULET },
	level = 27,
	multiplier = 11,
	price_base = 10100,
	price_max  = 15000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

Suffix{
	name = " of the Mammoth",
	min = 61,
	max = 80,
	occurence = { TYPE_ARMOR },
	level = 35,
	multiplier = 12,
	price_base = 15100,
	price_max  = 19000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

Suffix{
	name = " of the Whale",
	min = 81,
	max = 100,
	occurence = { TYPE_ARMOR },
	level = 60,
	multiplier = 13,
	price_base = 19100,
	price_max  = 30000,

	OnApply = function(item,value)
		item.life = item.life + value
	end,
}

--== + Damage ==========================--

Suffix{
	name = " of Quality",
	min = 1,
	max = 2,
	occurence = { TYPE_WEAPON, TYPE_STAFF, TYPE_BOW, },
	level = 2,
	multiplier = 2,
	price_base = 100,
	price_max  = 200,

	OnApply = function(item,value)
		item.dmgmod = item.dmgmod + value
	end,
}

Suffix{
	name = " of Maiming",
	min = 3,
	max = 5,
	occurence = { TYPE_WEAPON, TYPE_STAFF, TYPE_BOW, },
	level = 7,
	multiplier = 3,
	price_base = 1300,
	price_max  = 1500,

	OnApply = function(item,value)
		item.dmgmod = item.dmgmod + value
	end,
}

Suffix{
	name = " of Slaying",
	min = 6,
	max = 8,
	occurence = { TYPE_WEAPON },
	level = 15,
	multiplier = 5,
	price_base = 2600,
	price_max  = 3000,

	OnApply = function(item,value)
		item.dmgmod = item.dmgmod + value
	end,
}

Suffix{
	name = " of Gore",
	min = 9,
	max = 12,
	occurence = { TYPE_WEAPON },
	level = 25,
	multiplier = 8,
	price_base = 4100,
	price_max  = 5000,

	OnApply = function(item,value)
		item.dmgmod = item.dmgmod + value
	end,
}

Suffix{
	name = " of Carnage",
	min = 13,
	max = 16,
	occurence = { TYPE_WEAPON },
	level = 35,
	multiplier = 10,
	price_base = 5100,
	price_max  = 10000,

	OnApply = function(item,value)
		item.dmgmod = item.dmgmod + value
	end,
}

Suffix{
	name = " of Slaughter",
	min = 17,
	max = 20,
	occurence = { TYPE_WEAPON },
	level = 60,
	multiplier = 13,
	price_base = 10100,
	price_max  = 15000,

	OnApply = function(item,value)
		item.dmgmod = item.dmgmod + value
	end,
}

--== + Damage Taken ==========================--

Suffix{
	name = " of Pain",
	min = 2,
	max = 4,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	flags = { ifCursed },
	level = 4,
	multiplier = -4,

	OnApply = function(item,value)
		item.dmgtaken = item.dmgtaken + value
	end,
}

Suffix{
	name = " of Tears",
	min = 1,
	max = 1,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	flags = { ifCursed },
	level = 2,
	multiplier = -2,

	OnApply = function(item,value)
		item.dmgtaken = item.dmgtaken + value
	end,
}

Suffix{
	name = " of Health",
	min = 1,
	max = 1,
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	level = 2,
	multiplier = 2,
	price_base = 200,
	price_max  = 200,

	OnApply = function(item,value)
		item.dmgtaken = item.dmgtaken - value
	end,
}

Suffix{
	name = " of Protection",
	min = 2,
	max = 2,
	occurence = { TYPE_ARMOR, TYPE_SHIELD },
	level = 6,
	multiplier = 4,
	price_base = 400,
	price_max  = 400,

	OnApply = function(item,value)
		item.dmgtaken = item.dmgtaken - value
	end,
}

Suffix{
	name = " of Absorption",
	min = 3,
	max = 3,
	occurence = { TYPE_ARMOR, TYPE_SHIELD },
	level = 12,
	multiplier = 10,
	price_base = 1000,
	price_max  = 1000,

	OnApply = function(item,value)
		item.dmgtaken = item.dmgtaken - value
	end,
}

Suffix{
	name = " of Deflection",
	min = 4,
	max = 4,
	occurence = { TYPE_ARMOR },
	level = 20,
	multiplier = 15,
	price_base = 2500,
	price_max  = 2500,

	OnApply = function(item,value)
		item.dmgtaken = item.dmgtaken - value
	end,
}

Suffix{
	name = " of Osmosis",
	min = 5,
	max = 6,
	occurence = { TYPE_ARMOR },
	level = 50,
	multiplier = 20,
	price_base = 7500,
	price_max  = 10000,

	OnApply = function(item,value)
		item.dmgtaken = item.dmgtaken - value
	end,
}

--[[
--== + Mana ==========================--

Suffix{
	name = " of Corruption",
	occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON },
	flags = { ifCorrupt },
	level = 5,
	multiplier = 2,
        price_base = -1000,
	price_max  = -1000,

	OnApply = function(item,value)
		item.dmgmod = item.dmgmod + value
	end,
}

--== + Fire Damage ==========================--
Suffix{
	name = " of Flame",
	min = 1,
	max = 3,
	occurence = { TYPE_BOW },
	level = 1,
	multiplier = 2,
        price_base = 2000,
	price_max  = 2000,

        OnApply = function(item,value)
		item.dmgmodfire = item.dmgmodfire + value
        end,
}

Suffix{
       name = " of Fire",
       min = 1,
       max = 6,
       occurence = { TYPE_BOW },
       level = 11,
       multiplier = 4,
       price_base = 4000,
       price_max  = 4000,

       OnApply = function(item,value)
               item.dmgmodfire = item.dmgmodfire + value
       end,
}

Suffix{
       name = " of Burning",
       min = 1,
       max = 16,
       occurence = { TYPE_BOW },
       level = 35,
       multiplier = 6,
       price_base = 6000,
       price_max  = 6000,

       OnApply = function(item,value)
               item.dmgmodfire = item.dmgmodfire + value
       end,
}

--== + Lightning Damage ==========================--

Suffix{
       name = " of Shock",
       min = 1,
       max = 6,
       occurence = { TYPE_BOW },
       level = 13,
       multiplier = 2,
       price_base = 6000,
       price_max  = 6000,

       OnApply = function(item,value)
               item.dmgmodlightning = item.dmgmodlightning + value
       end,
}

Suffix{
       name = " of Lightning",
       min = 1,
       max = 10,
       occurence = { TYPE_BOW },
       level = 21,
       multiplier = 4,
       price_base = 8000,
       price_max  = 8000,

       OnApply = function(item,value)
               item.dmgmodlightning = item.dmgmodlightning + value
       end,
}

Suffix{
       name = " of Thunder",
       min = 1,
       max = 20,
       occurence = { TYPE_BOW },
       level = 60,
       multiplier = 6,
       price_base = 12000,
       price_max  = 12000,

       OnApply = function(item,value)
               item.dmgmodlightning = item.dmgmodlightning + value
       end,
}]]

--== + Steal Life % ==========================--

Suffix{
       name = " of the Leech",
       min = 30,
       max = 30,
       occurence = { TYPE_WEAPON },
       level = 8,
       multiplier = 4,
       price_base = 7500,
       price_max  = 7500,

       OnApply = function(item,value)
               item.lifesteal = item.lifesteal + value
       end,
}

Suffix{
       name = " of Blood",
       min = 50,
       max = 50,
       occurence = { TYPE_WEAPON },
       level = 19,
       multiplier = 3,
       price_base = 15000,
       price_max  = 15000,

       OnApply = function(item,value)
               item.lifesteal = item.lifesteal + value
       end,
}

--== + Steal Mana % ==========================--

Suffix{
       name = " of the Bat",
       min = 30,
       max = 30,
       occurence = { TYPE_WEAPON },
       level = 8,
       multiplier = 3,
       price_base = 7500,
       price_max  = 7500,

       OnApply = function(item,value)
               item.manasteal = item.manasteal + value
       end,
}

Suffix{
       name = " of Vampires",
       min = 50,
       max = 50,
       occurence = { TYPE_WEAPON },
       level = 19,
       multiplier = 3,
       price_base = 15000,
       price_max  = 15000,

       OnApply = function(item,value)
               item.manasteal = item.manasteal + value
       end,
}

--== + Damage / Penetrate Armor ==========================--
-- These should lower target's AC on hit.
--[[
Suffix{
       name = " of Piercing",
       min = 2,
       max = 6,
       occurence = { TYPE_WEAPON, TYPE_BOW },
       level = 1,
       multiplier = 3,
       price_base = 1000,
       price_max  = 1000,

       OnApply = function(item,value)
               item.dmgmod = item.dmgmod + value
       end,
}

Suffix{
       name = " of Puncturing",
       min = 4,
       max = 12,
       occurence = { TYPE_WEAPON, TYPE_BOW },
       level = 9,
       multiplier = 6,
       price_base = 2000,
       price_max  = 2000,

       OnApply = function(item,value)
               item.dmgmod = item.dmgmod + value
       end,
}

Suffix{
       name = " of Bashing",
       min = 8,
       max = 24,
       occurence = { TYPE_WEAPON },
       level = 17,
       multiplier = 12,
       price_base = 4000,
       price_max  = 4000,

       OnApply = function(item,value)
               item.dmgmod = item.dmgmod + value
       end,
}
--]]

--== + Light Radius % ==========================--

Suffix{
       name = " of the Dark",
       min = 40,
       max = 40,
       occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_AMULET, TYPE_RING },
       flags = { ifCursed },
       level = 6,
       multiplier = -3,

       OnApply = function(item,value)
               item.lightmod = item.lightmod - value
       end,
}

Suffix{
       name = " of the Night",
       min = 20,
       max = 20,
       occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_AMULET, TYPE_RING },
       flags = { ifCursed },
       level = 3,
       multiplier = -2,

       OnApply = function(item,value)
               item.lightmod = item.lightmod - value
       end,
}

Suffix{
       name = " of Light",
       min = 20,
       max = 20,
       occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_AMULET, TYPE_RING },
       level = 4,
       multiplier = 2,
       price_base = 750,
       price_max  = 750,

       OnApply = function(item,value)
               item.lightmod = item.lightmod + value
       end,
}

Suffix{
       name = " of Radiance",
       min = 40,
       max = 40,
       occurence = { TYPE_ARMOR, TYPE_WEAPON, TYPE_AMULET, TYPE_RING },
       level = 8,
       multiplier = 3,
       price_base = 1500,
       price_max  = 1500,

       OnApply = function(item,value)
               item.lightmod = item.lightmod + value
       end,
}

--== Weapon Speed ==========================--

Suffix{
       name = " of Readiness",
       min = SPD_QUICK,
       max = SPD_QUICK,
       occurence = { TYPE_WEAPON, TYPE_STAFF, TYPE_BOW },
       level = 1,
       multiplier = 2,
       price_base = 2000,
       price_max  = 2000,

       OnApply = function(item,value)
               item.spdatk = item.spdatk + value
       end,
}

Suffix{
       name = " of Swiftness",
       min = SPD_FAST,
       max = SPD_FAST,
       occurence = { TYPE_WEAPON, TYPE_STAFF, TYPE_BOW },
       level = 10,
       multiplier = 4,
       price_base = 4000,
       price_max  = 4000,

       OnApply = function(item,value)
               item.spdatk = item.spdatk + value
       end,
}

Suffix{
       name = " of Speed",
       min = SPD_FASTER,
       max = SPD_FASTER,
       occurence = { TYPE_WEAPON, TYPE_STAFF },
       level = 19,
       multiplier = 8,
       price_base = 8000,
       price_max  = 8000,

       OnApply = function(item,value)
               item.spdatk = item.spdatk + value
       end,
}

Suffix{
       name = " of Haste",
       min = SPD_FASTEST,
       max = SPD_FASTEST,
       occurence = { TYPE_WEAPON, TYPE_STAFF },
       level = 27,
       multiplier = 16,
       price_base = 16000,
       price_max  = 16000,

       OnApply = function(item,value)
               item.spdatk = item.spdatk + value
       end,
}

--== Hit Recovery Speed ==========================--

Suffix{
       name = " of Balance",
       min = SPD_FAST,
       max = SPD_FAST,
       occurence = { TYPE_ARMOR, TYPE_RING, TYPE_AMULET },
       level = 1,
       multiplier = 2,
       price_base = 2000,
       price_max  = 2000,

       OnApply = function(item,value)
               item.spdhit = item.spdhit + value
       end,
}

Suffix{
       name = " of Stability",
       min = SPD_FASTER,
       max = SPD_FASTER,
       occurence = { TYPE_ARMOR, TYPE_RING, TYPE_AMULET },
       level = 10,
       multiplier = 4,
       price_base = 4000,
       price_max  = 4000,

       OnApply = function(item,value)
               item.spdhit = item.spdhit + value
       end,
}

Suffix{
       name = " of Harmony",
       min = SPD_FASTEST,
       max = SPD_FASTEST,
       occurence = { TYPE_ARMOR, TYPE_RING, TYPE_AMULET },
       level = 20,
       multiplier = 8,
       price_base = 8000,
       price_max  = 8000,

       OnApply = function(item,value)
               item.spdhit = item.spdhit + value
       end,
}

--== + Durability ==========================--

Suffix{
       name = " of Fragility",
       min = 1,
       max = 1,
       occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON },
       flags = { ifCursed },
       level = 3,
       multiplier = -4,

       OnApply = function(item,value)
			item.durmod = -1
			item.durmax = value
            item.dur = value
       end,
}

Suffix{
       name = " of Brittleness",
       min = 26,
       max = 75,
       occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON },
       flags = { ifCursed },
       level = 1,
       multiplier = -2,

       OnApply = function(item,value)
				item.dur = math.max(1,item.dur - (value*item.durmax)/100)
				item.durmax = math.max(item.durmax - (value*item.durmax)/100)
				item.durmod = -1
       end,
}

Suffix{
       name = " of Sturdiness",
       min = 26,
       max = 75,
       occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON },
       level = 1,
       multiplier = 2,
       price_base = 100,
       price_max  = 100,

       OnApply = function(item,value)
				item.dur = item.dur + (value*item.durmax)/100
				item.durmax = item.durmax + (value*item.durmax)/100
				item.durmod = 1
       end,
}

Suffix{
       name = " of Craftmanship",
       min = 51,
       max = 100,
       occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON },
       level = 6,
       multiplier = 2,
       price_base = 200,
       price_max  = 200,

       OnApply = function(item,value)
				item.dur = item.dur + (value*item.durmax)/100
				item.durmax = item.durmax + (value*item.durmax)/100
				item.durmod = 1
       end,
}

Suffix{
       name = " of Structure",
       min = 101,
       max = 200,
       occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON },
       level = 12,
       multiplier = 2,
       price_base = 300,
       price_max  = 300,

       OnApply = function(item,value)
				item.dur = item.dur + (value*item.durmax)/100
				item.durmax = item.durmax + (value*item.durmax)/100
				item.durmod = 1
       end,
}

Suffix{
       name = " of Many",
       min = 100,
       max = 100,
       occurence = { TYPE_BOW },
       level = 3,
       multiplier = 2,
       price_base = 750,
       price_max  = 750,

       OnApply = function(item,value)
				item.dur = item.dur + (value*item.durmax)/100
				item.durmax = item.durmax + (value*item.durmax)/100
				item.durmod = 1
       end,
}

Suffix{
       name = " of Plenty",
       min = 200,
       max = 200,
       occurence = { TYPE_BOW },
       level = 7,
       multiplier = 3,
       price_base = 1500,
       price_max  = 1500,

       OnApply = function(item,value)
               item.dur = item.dur + (value*item.durmax)/100
			   item.durmax = item.durmax + (value*item.durmax)/100
               item.durmod = 1
       end,
}

Suffix{
       name = " of the Ages",
       occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_WEAPON, TYPE_STAFF },
       flags = { ifIndest },
       level = 25,
       multiplier = 5,
       price_base = 600,
       price_max  = 600,
}

Suffix{
       name = " of Blocking",
       min = SPD_FAST,
       max = SPD_FAST,
       occurence = { TYPE_SHIELD },
       level = 5,
       multiplier = 4,
       price_base = 4000,
       price_max  = 4000,

       OnApply = function(item,value)
               item.spdblk = item.spdblk + value
       end,
}

--== Miscelaneous effects ==========================--

Suffix{
       name = " of the Bear",
       occurence = { TYPE_WEAPON, TYPE_STAFF, TYPE_BOW },
	   flags = { ifKnockback },
       level = 5,
       multiplier = 2,
       price_base = 750,
       price_max  = 750,
}

Suffix{
       name = " of Thieves",
       occurence = { TYPE_ARMOR, TYPE_SHIELD, TYPE_RING, TYPE_AMULET },
	   flags = { ifTrapResist },
       level = 11,
       multiplier = 2,
       price_base = 1500,
       price_max  = 1500,
}
--[[
Suffix{
	name = " of Thorns",
	min = 1,
	max = 3,
	flags = {ifThorns},
	occurence = { TYPE_ARMOR, TYPE_SHIELD },
	level = 1,
	multiplier = 2,
	price_base = 500,
	price_max  = 500,

	OnApply = function(item,value)

	end,
}

Suffix{
	name = " of Devastation",
	min = ,
	max = ,
	occurence = { TYPE_WEAPON, TYPE_STAFF, TYPE_BOW },
	level = 1,
	multiplier = 3,
	price_base = 1200,
	price_max  = 1200,

	OnApply = function(item,value)
		--5% chance of doing x3 damage
	end,
}

Suffix{
	name = " of Peril",
	min = ,
	max = ,
	occurence = { TYPE_WEAPON, TYPE_STAFF, TYPE_BOW },
	level = 5,
	multiplier = 2,
	price_base = 500,
	price_max  = 500,

	OnApply = function(item,value)
		--x2 damage to monster, x1 to user
		--something like +100% dmg -50% lifesteal, I think.
	end,
}
--]]
