Cell{
  name = "floor",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ".",
  color = LIGHTGRAY
}

Cell{
  name = "bloody floor",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ".",
  color = RED
}

Cell{
  name = "marker",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ".",
  color = LIGHTGRAY
}


Cell{
  name = "shimmering portal",
  passable = true,
  blockvision = false,
  canchange = false,
  pic = "0",
  color = ColorPortal,

  OnStep = function(x, y)
    ui.msg_enter("You feel yanked in a direction that never existed!")
    if ( level.level() > 0 ) then
      level.change( 0, "shimmering_portal" )
    else
      level.change( player.portallevel, "shimmering_portal" )
    end
  end,
}

Cell{
  name = "decapitated body",
  passable = false,
  blockvision = false,
  canchange = true,
  pic = "%",
  color = LIGHTRED,
  activates = "bloody_corpse",

  OnAct = function(x, y)
    ui.msg("You search the body.")
	--TODO: ui.play_sound('sound/sfx/?')
    local drop = math.random(4)
    if drop <= 3 then level.drop_gold(x, y)
    else
      level.drop_random_item(x, y, level.level() * 2)
    end
  end,
}

-- This prototype is assumed for all edible carcasses in scavenger AI
Prototype{
	pid = "corpse_base",
	passable = true,
	blockvision = false,
	canchange = true,
	pic = "%",
}

Cell{
	proto = "corpse_base",
	name = "bloody corpse",
	color = RED,
}

Cell{
	proto = "corpse_base",
	name = "corpse",
	color = BROWN,
}

-- bones prototype used to create implicit bones cells in npc_monster.lua
Prototype{
	pid = "bones",
	name = "bones",
	passable = true,
	blockvision = false,
	canchange = true,
	pic = "%",
	color = LIGHTGRAY
}

Cell{
	proto = "bones",
}

Cell{
  name = "barrel fragments",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ",",
  color = BROWN
}


Cell{
  name = "barrel",
  passable = false,
  blockvision = false,
  canchange = false,
  activates = "barrel_fragments",
  pic = "0",
  color = BROWN,

  OnAct = function(x, y)
    local c = coord.new(x,y)
    if not( player.flags[nfAffected] ) then
		ui.msg("You destroy the barrel.")
	end
	if math.random(100) <= 20 then
	  level.set_cell( c, "floor" )
      ui.msg("The barrel explodes.")
	  ui.play_sound('sound/sfx/items/barlfire.wav',x,y)
	  level.explosion( c, RED, 1, 8, 16, 50, DAMAGE_FIRE)
	  for ex = x-1, x+1 do
		for ey = y-1, y+1 do
		  local ec = coord.new(ex,ey)
		  if level.get_cell(ec) == 'barrel' then
		    player.flags[nfAffected] = true
			cells['barrel'].OnAct(ex,ey)
			level.set_cell(ec,'floor')
			player.flags[nfAffected] = false
	  end end end

    else
	  ui.play_sound('sound/sfx/items/barrel.wav',x,y)
	  level.set_cell( c, "barrel_fragments" )
      local drop = math.random(30)
	  if ( drop == 1 ) then
        level.drop_random_item(x, y, level.level() * 2)
	  elseif ( drop <= 3 ) then
        level.drop_special(x, y)
      elseif ( drop <= 6 ) then
        level.drop_gold(x, y)
      elseif ( drop <= 12 ) then
        level.drop_skeleton(x,y)
    end end
  end,
}

Cell{
  name = "sarcophagus",
  passable = false,
  blockvision = false,
  canchange = false,
  activates = "open_sarcophagus",
  pic = "",
  piclow = "?",
  color = LIGHTGRAY,

  OnAct = function(x, y)
    ui.msg("You open the sarcophagus.")
	ui.play_sound('sound/sfx/items/sarc.wav',x,y)
    local drop = math.random(200)
	if drop <= 40 then level.drop_skeleton(x,y)
	elseif drop <= 85 then level.drop_gold(x, y)
    elseif drop <= 100 then
      level.drop_random_item(x, y, level.level() * 2)
    end
  end,
}

Prototype{
	pid = "chest",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = "",
	piclow = "?",
}

Prototype{
	proto = "chest",
	pid = "small chest",
	name = "small chest",
	color = BROWN,
	activates = "open_chest",
	OnAct = function(x, y)
		level.chest_drop(x,y,1)
	end,
}

Cell{
	proto = "small chest",
}

Cell{
	proto = "small chest",
	id = "small_chest_magic",
	OnAct = function(x, y)
		level.chest_drop(x,y,1,true)
	end
}

Prototype{
	proto = "chest",
	pid = "medium chest",
	name = "chest",
	color = LIGHTGRAY,
	activates = "open_chest",
	OnAct = function(x, y)
		level.chest_drop(x,y,2)
	end
}

Cell{
	proto = "medium chest",
	id = "medium_chest",
}

Cell{
	proto = "medium chest",
	id = "medium_chest_magic",
	OnAct = function(x, y)
		level.chest_drop(x,y,2,true)
	end
}

Prototype{
	proto = "chest",
	pid = "large chest",
	name = "large chest",
	color = WHITE,
	activates = "open_chest",
	OnAct = function(x, y)
		level.chest_drop(x,y,3)
	end
}

Cell{
	proto = "large chest",
}

Cell{
	proto = "large chest",
	id = "large_chest_magic",
	OnAct = function(x, y)
		level.chest_drop(x,y,3,true)
	end
}

Cell{
  proto = "chest",
  name = "open chest",
  color = DARKGRAY,
}

Cell{
  name = "open sarcophagus",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "",
  piclow = "?",
  color = DARKGRAY
}

Cell{
  name = "crucified skeleton",
  passable = false,
  blockvision = false,
  canchange = false,
  activates = "open_crucified_skeleton",
  pic = "",
  piclow = "?",
  color = BROWN,

  OnAct = function(x, y)
    ui.msg("You destroy the crucified skeleton.")
  end,
}

Cell{
  name = "open crucified skeleton",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "",
  piclow = "?",
  color = DARKGRAY
}

Prototype{
	pid = "rack",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = "&",
	color = LIGHTGRAY
}

Cell{
	proto = "rack",
	name = "empty_rack"
}

Cell{
	proto = "rack",
	name = "weapon_rack",
	activates = "empty_rack",
	color = BROWN,

	OnAct = function(x,y)
		local itype = table.random({"sword","axe","bow","club"})
		local ilvl = level.level()*2
		local id = level.random_item_proto(ilvl,itype)
		level.drop_random_base(id,x,y,ilvl,100,false)
	end
}

Cell{
	proto = "rack",
	name = "armor_rack",
	activates = "empty_rack",
	color = BROWN,

	OnAct = function(x,y)
		local itype = "light_armor"
		local mag_chance = 100
		local ilvl = level.level()*2
		if level.level() > 9 then
			itype = "heavy_armor"
			mag_chance = math.min(math.floor(11+0.89*(ilvl+1)),100)
		elseif level.level() > 6 then
			itype = "medium_armor"
			mag_chance = math.min(math.floor(55.5+0.445*(ilvl+1)),100)
		end
		local id = level.random_item_proto(ilvl,itype)
		level.drop_random_base(id,x,y,ilvl,mag_chance,false)
	end
}

Prototype{
	pid = "bookshelf",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = '"',
}

Cell{
	proto = "bookshelf",
	name = "bookshelf",
	color = BROWN,
	activates = "empty_bookshelf",
	OnAct = function(x, y)
		ui.msg("You search the bookshelf.")
		level.drop_item( level.random_item_id( level.level() * 2, { TYPE_BOOK } ), coord.new(x,y) )
	end
}

Cell{
	proto = "bookshelf",
	name = "empty bookshelf",
	color = DARKGRAY,
}

Prototype{
	pid = "book",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = '"',
	color = BROWN,

	OnAct = function(x, y)
		ui.msg("You open the book.")
		if (math.random(5) == 1) then
			level.drop_item( level.random_item_id( level.level() * 2, { TYPE_BOOK } ),coord.new(x,y) )
		else
			level.drop_random_scroll(coord.new(x,y))
		end
	end,
}

Cell{
	proto = "book",
	name = "library book",
	activates = "open_book",
}

Cell{
	proto = "book",
	name = "skeleton tome",
	activates = "open_book",
}

Cell{
	proto = "book",
	name = "open book",
	color = DARKGRAY,
}

Cell{
  name = "grass",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ".",
  color = GREEN
}

Prototype{
  pid = "stairs",
  passable = true,
  blockvision = false,
  canchange = false,
  pic = ">",
  color = YELLOW
}


Cell{
  name = "stairs up",
  proto = "stairs",
  pic = "<",
}

Cell{
  name = "stairs down",
  proto = "stairs",
}

Cell{
  id = "stairs_down_special",
  name = "stairs down",
  proto = "stairs",
  color = BLUE
}

Cell{
  id = "stairs_up_special",
  name = "stairs up",
  proto = "stairs",
  pic = "<",
  color = BLUE
}

Cell{
  id = "stairs_up_catacombs",
  name = "stairs up to town",
  proto = "stairs",
  pic = "<",
  color = WHITE
}

Cell{
  id = "stairs_down_catacombs",
  name = "stairs down to catacombs",
  proto = "stairs",
  color = WHITE
}

Cell{
  name = "statue",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "8",
  color = WHITE
}

Cell{
  name = "vault",
  passable = false,
  blockvision = true,
  canchange = false,
  pic = "#",
  color = LIGHTGRAY
}

Cell{
  name = "river",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "=",
  color = BLUE
}

Cell{
  name = "poisoned_river",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "=",
  color = YELLOW
}

Cell{
  name = "wooden bridge",
  passable = true,
  blockvision = false,
  canchange = false,
  pic = ":",
  color = BROWN
}

Cell{
  name = "town wall",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "%",
  color = DARKGRAY
}

Prototype{
	pid = "fountain",
	name = "fountain",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = "=",
}

Cell{
	proto = "fountain",
	color = BLUE
}

Cell{
	proto = "fountain",
	id = "poison_fountain",
	color = YELLOW
}

Cell{
  name = "muddy grass",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ".",
  color = BROWN
}

Cell{
  name = "path",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ":",
  color = BROWN
}

Cell{
  name = "sand",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ".",
  color = YELLOW
}

Cell{
  name = "town square",
  passable = true,
  blockvision = false,
  canchange = true,
  pic = ".",
  color = BROWN
}

Cell{
  name = "deep grass",
  passable = false,
  blockvision = true,
  canchange = false,
  pic = ".",
  color = GREEN
}

Cell{
  name = "stones",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "^",
  color = LIGHTGRAY
}

Cell{
  name = "heavy stones",
  passable = false,
  blockvision = true,
  canchange = false,
  pic = "^",
  color = DARKGRAY
}

Cell{
  name = "tomb stone",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "\241",
  piclow="+",
  color = DARKGRAY
}

Cell{
  name = "town barrel",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "0",
  color = DARKGRAY
}

Cell{
  name = "tree",
  passable = false,
  blockvision = true,
  canchange = false,
  pic = "T",
  color = BROWN
}

Cell{
  name = "closed door",
  passable = false,
  blockvision = true,
  canchange = false,
  activates = "open_door",
  pic = "+",
  color = BROWN,

  OnAct = function(x, y)
    ui.msg("You open the door.")
	ui.play_sound('sound/sfx/items/dooropen.wav',x,y)
  end,
}

Cell{
  name = "closed door",
  id = "closed_door_2",
  passable = false,
  blockvision = true,
  canchange = false,
  activates = "open_blocked_door",
  pic = "+",
  color = BROWN,

  OnAct = function(x, y)
    ui.msg("You open the door. Click.")
	ui.play_sound('sound/sfx/items/dooropen.wav',x,y)
  end,
}

Cell{
  name = "closed door",
  id = "closed_door_catacombs",
  passable = false,
  blockvision = true,
  canchange = false,
  activates = "closed_door_catacombs",
  pic = "+",
  color = BROWN,

  OnAct = function(x, y)
    local c = coord.new(x,y)
    if level.get_cell( player:get_position() ) == "floor" then
		level.set_cell( c, "open_blocked_door" )
		ui.msg("You open the door. Click.")
		ui.plays_sound('sound/sfx/items/dooropen.wav',x,y)
	else
		ui.msg("@<\"Maybe it's locked from the inside.\"@>")
	end
  end,
}

Cell{
  name = "locked door",
  passable = false,
  blockvision = true,
  canchange = false,
  pic = "+",
  color = BROWN
}

Cell{
  name = "open door",
  passable = true,
  blockvision = false,
  canchange = false,
  activates = "closed_door",
  pic = "'",
  color = DARKGRAY,

  OnAct = function(x, y)
    ui.msg("You close the door.")
	ui.play_sound('sound/sfx/items/doorclos.wav',x,y)
  end,
}

Cell{
  name = "open blocked door",
  passable = true,
  blockvision = false,
  canchange = false,
  activates = "open_blocked_door",
  pic = "'",
  color = LIGHTGRAY,

  OnAct = function(x, y)
    ui.msg("The door is blocked.")
	ui.play_sound('sound/sfx/items/doorclos.wav',x,y)
  end,
}

Prototype{
	pid = "wall",
	name = "stone wall",
	passable = false,
	blockvision = true,
	canchange = false,
	pic = "#",
	color = DARKGRAY
}

Cell{
	proto = "wall",
}

Cell{
	proto = "wall",
	name = "bloody stone wall",
	color = RED
}

Cell{
	proto = "wall",
	id = "moving_wall_1",
}

Cell{
	proto = "wall",
	id = "moving_wall_2",
}

Cell{
	proto = "wall",
	id = "moving_wall_3",
}

Prototype{
	pid = "grate",
	name = "grate",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = ":",
	color = WHITE
}

Cell{
	proto = "grate",
}

Cell{
	proto = "grate",
	id = "moving_grate_1",
}

Prototype{
	pid = "lever_base",
	name = "lever",
	passable = false,
	blockvision = false,
	canchange = false,
}

Prototype{
	proto = "lever_base",
	pid = "lever",
	activates = "lever_done",
	pic = '\\',
	color = GREEN,
}

Cell{
	proto = "lever",
	id = "lever1",

	OnAct = function(x, y)
		level.lever_action(x,y,1)
	end,
}

Cell{
	proto = "lever",
	id = "lever2",

	OnAct = function(x, y)
		level.lever_action(x,y,2)
	end,
}

Cell{
	proto = "lever",
	id = "lever3",

	OnAct = function(x, y)
		level.lever_action(x,y,3)
	end,
}

Cell{
	proto = "lever_base",
	id = "lever_done",
	pic = '/',
	color = DARKGRAY,
}

Cell{
  name = "King's sarcophagus",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "",
  piclow = "?",
  color = LIGHTGRAY
}

Cell{
  name = "visited shrine",
  passable = false,
  blockvision = false,
  canchange = false,
  pic = "_",
  color = LIGHTGRAY,
}

Prototype{
	pid = "shrine_base",
	passable = false,
	blockvision = false,
	canchange = false,
	activates = "visited_shrine",
	pic = "_",
	color = WHITE,
	minl = 1,
	maxl = 15,
	special = 1,
}

Cell{
	name = "abandoned shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<The hands of men may be guided by fate.@>")
		player.dex = math.min(player.dex + 2, klasses[player.klass].dexmax)
	end,
}

Cell{
	name = "creepy shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.plays_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Strength is bolstered by heavenly faith.@>")
		player.str = math.min(player.str + 2, klasses[player.klass].strmax)
	end,
}
--[[
Cell{
	name = "cryptic shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Arcane power brings destruction.@>")
		player.mp = player.mpmax
		--To do:
		--cast Nova spell of level (dungeon_level div 4 + 2)
	end,
}
]]
Cell{
	name = "divine shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Drink and be refreshed.@>")
		player.hp = player.hpmax
		player.mp = player.mpmax
		local c = coord.new(x,y);
		if level.level() < 4 then
			level.drop_item("potion_full_healing",c)
			level.drop_item("potion_full_mana",c)
		else
			level.drop_item("potion_full_rejuvenation",c)
			level.drop_item("potion_full_rejuvenation",c)
		end
	end,
}

Cell{
	name = "eerie shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.plays_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Knowledge and wisdom at the cost of self.@>")
		player.mag = math.min(player.mag + 2,klasses[player.klass].magmax)
	end,
}

Cell{
	name = "eldritch shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Crimson and Azure become as the sun.@>")
		for i,pot in pairs({ 'healing', 'mana' }) do
			while player.item["potion_"..pot] ~= nil do
				player.item["potion_"..pot] = "potion_rejuvenation"
			end
			while player.item["potion_full_"..pot] ~= nil do
				player.item["potion_full_"..pot] = "potion_full_rejuvenation"
			end
		end
	end,
}

Cell{
	name = "enchanted shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Magic is not always what it seems to be.@>")
		local _spells_ = {}

		for i = 1, #spells do
			if player.spells[i] > 0 then table.insert(_spells_, i) end
		end
		if #_spells_ == 0 then return end

		local _spell_ = math.random(#_spells_)
		local _loss_  = 1
		if level.level() > 14 then _loss_ = 2 end

		for i = 1, #_spells_ do
			if i == _spell_ then
				player.spells[_spells_[i]] = math.max(0,player.spells[_spells_[i]] - _loss_)
			else
				player.spells[_spells_[i]] = player.spells[_spells_[i]] + 1
			end
		end
	end,
}

Cell{
	name = "fascinating shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Intensity comes at the cost of wisdom.@>")
		player.mpmod = player.mpmod - math.max(1,math.floor(player.mpmax / 10))
		player.spells["firebolt"] = player.spells["firebolt"] + 2
	end,
}

--this shrine appear only on dungeon_level 1-8
Cell{
	name = "glimmering shrine",
	proto = "shrine_base",
	maxl = 8,

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		player.msg("@<Mysteries are revealed in the light of reason.@>")
		for item in player:items() do
			item:identify()
		end
	end,
}

Cell{
	name = "gloomy shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Those who defend seldom attack.@>")
		for item in player:items() do
			if item.itype == TYPE_WEAPON then
				item.dmgmin = math.max(1,item.dmgmin-1)
				item.dmgmax = math.max(1,item.dmgmax-1)
			elseif item.itype == TYPE_ARMOR or item.itype == TYPE_SHIELD or item.itype == TYPE_HELM then
				item.ac = item.ac + 2
			end
		end
	end,
}
--[[
Cell{
	name = "hidden shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<New strength is forged through destruction.@>")
		local _items_ = {}
		for i = 1, ITEMS_EQ do
			if player.eq[i] and player.eq[i].durmax > 0 then
				table.insert(_items_, i)
			end
		end
		if #_items_ == 0 then return end

		local _item_ = math.random(#_items_)
		for i = 1, #_items_ do
			if i == _item_ then
				player.eq[ _items_[i] ].durmax = math.max(1, player.eq[_items_[i] ].durmax-20)
				player.eq[ _items_[i] ].dur = math.max(1, player.eq[_items_[i] ].dur-20)
			else
				player.eq[ _items_[i] ].durmax = player.eq[ _items_[i] ].durmax+10
				player.eq[ _items_[i] ].dur = player.eq[ _items_[i] ].dur+10
			end
		end
	end,
}
]]
Cell{
	name = "holy shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic1.wav')
		ui.play_sound('sound/sfx/misc/teleport.wav')
		ui.msg("@<Wherever you go, there you are.@>")
		player.mp = player.mpmax
		player:phasing()
	end,
}

Cell{
	name = "magical shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.play_sound('sound/sfx/misc/mshield.wav')
		ui.msg("@<While the spirit is vigilant, the body thrives.@>")
		player.mp = player.mpmax
		spells['mana_shield'].script(2*math.ceil(level.level() / 4))
	end,
}

Cell{
	name = "mysterious shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Some are weakened as one grows strong.@>")
		local loss = math.random(4)
		for i,stat in pairs({'str','mag','dex','vit'}) do
			if i == loss then
				player[stat] = math.max(0, player[stat] - 1)
			else
				player[stat] = math.min(player[stat] + 5, klasses[player.klass][stat..'max'])
			end
		end
	end,
}

Cell{
	name = "ornate shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Salvation comes at the cost of wisdom.@>")
		player.mpmod = player.mpmod - math.max(1,math.floor(player.mpmax / 10))
		player.spells["holy_bolt"] = player.spells["holy_bolt"] + 2
	end,
}

Cell{
	name = "quiet shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<The essence of life flows from within.@>")
		player.vit = math.min(player.vit + 2, klasses[player.klass].vitmax)
	end,
}

Cell{
	name = "religious shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Time cannot diminish the power of steel.@>")
		for item in player:items() do
			item.dur = item.durmax
		end
	end,
}
--[[
Cell{
	name = "sacred shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Energy comes at the cost of wisdom.@>")
		player.mpmod = player.mpmod - math.max(1,math.floor(player.mpmax / 10))
		--To do:
		--player.spells["charged_bolt"] = player.spells["charged_bolt] + 2
	end,
}
]]
Cell{
	name = "secluded shrine",
	proto = "shrine_base",

  OnAct = function(x, y)
	ui.play_sound('sound/sfx/items/magic.wav')
    ui.msg("@<The way is made clear when viewed from above.@>")
    level.reveal()
  end,
}

Cell{
	name = "spiritual shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<Riches abound when least expected.@>")
		local multiplier = math.ceil( level.level() / 4 )
		for i=1, ITEMS_INV do
			if not player.item[i] then
				player:add_gold(math.random(10*multiplier)+5*multiplier)
			end
		end
	end,
}

Cell{
	name = "stone shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<The powers of mana refocused renews.@>")
		for item in player:items() do
			item.charges = item.chargesmax
		end
	end,
}
--[[
Cell{
	name = "thaumaturgic shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<What once was opened now is closed.@>")
	--To do:
    --refills all chests on the current level
	end,
}
]]
Cell{
	name = "weird shrine",
	proto = "shrine_base",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/items/magic.wav')
		ui.msg("@<The sword of justice is swift and sharp.@>")
		for item in player:items() do
			if item.itype == TYPE_WEAPON then
				item.dmgmax = item.dmgmax + 1
			end
		end
	end,
}

Cell{
	name = "blood fountain",
	passable = false,
	blockvision = false,
	canchange = false,
	activates = "blood_fountain",
	pic = "_",
	color = RED,

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/misc/fountain.wav')
		ui.msg("You drink from the fountain.")
		player.hp = math.min( player.hp+1, player.hpmax )
	end,
}

Cell{
	name = "fountain of tears",
	proto = "shrine_base",
	color = LIGHTBLUE,

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/misc/fountain.wav')
		ui.msg("You drink from the fountain.")
		local stat1 = math.random(4)
		local stat2 = math.random(4)
		local stats = {'str','mag','dex','vit'}
		while stat1 == stat2 do stat2 = math.random(4) end
		player[stats[stat1]] = math.min(player[stats[stat1]] + 1, klasses[player.klass][stats[stat1]..'max'])
		player[stats[stat2]] = math.max(player[stats[stat2]] - 1, 0)
	end,
}

Cell{
	name = "murky pool",
	proto = "shrine_base",
	color = BROWN,

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/misc/fountain.wav')
		ui.play_sound('sound/sfx/misc/infravis.wav')
		ui.msg("You drink from the pool.")
		spells['infravision'].script(2*math.ceil(level.level() / 4))
	end,
}

Cell{
	name = "purifying spring",
	proto = "shrine_base",
	activates = "purifying_spring",
	color = BLUE,

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/misc/fountain.wav')
		ui.msg("You drink from the spring.")
		player.mp = math.min( player.mp+1, player.mpmax )
	end,
}

-- Quest-related cells

Cell{
  name = "locked chest",
  passable = false,
  blockvision = false,
  canchange = false,
  activates = "locked_chest",
  pic = "",
  piclow = "?",
  color = WHITE,

  OnAct = function(x, y)
    local c = coord.new(x,y)
    if player.quest["sign"] == 2 then
	  level.drop_item("tavern_sign",c)
	  level.set_cell(c,"open_chest")
	else
      ui.msg("@<\"I can't open this yet.\"@>")
      player:play_sound(24);
    end
  end,
}

Cell{
	name = "pedestal",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = "_",
	color = LIGHTGRAY,
}

Cell{
	name = "magic rock",
	proto = "shrine_base",
	activates = "pedestal",
	color = BLUE,
	pic   = "*",

	OnAct = function(x, y)
		level.drop_item("sky_rock", coord.new(x,y))
	end,
}

Cell{
	name = "pedestal of blood",
	proto = "shrine_base",
	activates = "pedestal_of_blood",
	color = RED,

	OnAct = function(x, y)
		if player.quest["valor"] == 0 or player.quest["valor"] == 4 then
			return
		elseif player.quest["valor"] == 1 and player.item["blood_stone"] ~= nil then
			player.item["blood_stone"] = nil
			player.quest["valor"] = 2
			level.set_cell( coord.new( x-9, y-4 ), "closed_door")
			ui.msg("You put the blood stone onto the pedestal.")
		elseif player.quest["valor"] == 2  and player.item["blood_stone"] ~= nil then
			player.item["blood_stone"] = nil
			player.quest["valor"] = 3
			level.set_cell( coord.new( x+9, y-4 ), "closed_door")
			ui.msg("You put the blood stone onto the pedestal.")
		elseif player.quest["valor"] == 3 and player.item["blood_stone"] ~= nil then
			player.item["blood_stone"] = nil
			player.quest["valor"] = 4
			level.move_walls("moving_wall_1")
			level.drop_item("arkaine's_valor", coord.new(x, y-10))
			ui.msg("You put the blood stone onto the pedestal.")
		end
	end,
}

Cell{
	proto 	= "bookshelf",
	id 		= "zhar_bookshelf",
	name   	= "bookshelf",
	color  	= BROWN,
	activates = "empty_bookshelf",

	OnAct = function(x,y)
		local zhar = level.find("zhar_the_mad")
		if zhar then
			ui.play_sound("sound/sfx/monsters/zhar02.wav")
			ui.plot_talk("Arrrrgh! Your curiosity will be the death of you!!! (laughs) ")
			zhar.ai = AIMage
		end
		level.drop_item( level.random_item_id( level.level() * 2, { TYPE_BOOK } ),coord.new(x,y) )
	end,
}

-- Story Tomes
Prototype{
	pid = "story_tome",
	passable = false,
	blockvision = false,
	canchange = false,
	pic = '"',
	color = YELLOW,
}

Cell{
	-- Catacombs, level 5
	proto = "story_tome",
	name = "Book of Blood",
	activates = "book_of_blood",

	OnAct = function(x, y)
		player:play_sound(10)
		quests["valor"].OnJournal()
		if player.quest["valor"] == 0 then
			level.drop_item("blood_stone", coord.new(x,y))
			level.drop_item("blood_stone", coord.new(x-6, y-11))
			level.drop_item("blood_stone", coord.new(x+6, y-11))
			player.quest["valor"] = 1
		end
	end,
}

Cell{
	-- Catacombs, level 6
	proto = "story_tome",
	name = "Mythical Book",
	activates = "mythical_book",

	OnAct = function(x, y)
		quests["bone_chamber"].OnJournal()
		if player.quest["bone_chamber"] == 0 then
			player.quest["bone_chamber"] = 1
			level.move_walls("moving_wall_1")
		end
	end,
}

Cell{
	-- Catacombs, level 6
	proto = "story_tome",
	name = "Ancient Tome",
	activates = "ancient_tome",

	OnAct = function(x, y)
		if player.quest["bone_chamber"] < 2 then
			player.quest["bone_chamber"] = 2
			player.spells["guardian"] = math.min(15, player.spells["guardian"] + 1)
			ui.msg_enter("Arcane Knowledge gained.")
			local hydra = level.drop_npc( 'hydra',coord.new( x,y-2 ) )
			hydra.hpmax = (8*player.spells["guardian"]+4*player.level)
			hydra.hp 	= hydra.hpmax
			hydra.aistate = player.spells['firebolt']
		end
	end,
}

Cell{
	-- Catacombs, level 7
	proto = "story_tome",
	name = "Book of the Blind",
	activates = "book_of_the_blind",

	OnAct = function(x, y)
		player:play_sound('11')
		quests["halls_of_blind"].OnJournal()
		if player.quest["halls_of_blind"] == 0 then
			player.quest["halls_of_blind"] = 1
			local c = level.find_tile("marker")
			level.drop_item( "optic_amulet", c )
			level.set_cell( c, "floor" )
			level.move_walls("moving_wall_1")
		end
	end,
}

Cell{
	-- Hell, level 13
	proto = "story_tome",
	name = "Steel Tome",
	activates = "steel_tome",

	OnAct = function(x, y)
		player:play_sound('12')
		ui.plot_talk("The armories of Hell are home to the Warlord of Blood. In his wake lay the mutilated bodies of thousands. Angels and man alike have been cut down to fulfill his endless sacrifices to the dark ones who scream for one thing - blood.")
		-- initiate Warlord of Blood quest
	end,
}

Cell{
	-- Church, level 4
	proto = "story_tome",
	name = "The Great Conflict",
	activates = "the_great_conflict",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar01.wav')
		ui.plot_talk("Take heed and bear witness to the truths that lie herein, for they are the last legacy of the Horadrim. There is a war that rages on even now, beyond the fields that we know - between the Utopian Kingdoms of the High Heavens and the Chaotic Pits of the Burning Hells. This war is known as the Great Conflict, and it has raged and burned longer than any of the stars in the sky. Neither side ever gains sway for long as the forces of Light and Darkness constantly vie for control over all creation.")
	end,
}

Cell{
	-- Catacombs, level 8
	proto = "story_tome",
	name = "Wages of Sin are War",
	activates = "wages_of_sin_are_war",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar02.wav')
		ui.plot_talk("Take heed and bear witness to the truths that lie herein, for they are the last legacy of the Horadrim. When the eternal conflict between the High Heavens and the Burning Hells falls upon mortal soil, it is called the Sin War. Angels and Demons walk amongst humanity in disguise, fighting in secret, away from the prying eyes of mortals. Some daring, powerful mortals have even allied themselves with either side, and helped to dictate the course of the Sin War.")
	end,
}

Cell{
	-- Caves, level 12
	proto = "story_tome",
	name = "Tale of the Horadrim",
	activates = "tale_of_the_horadrim",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar06.wav')
		ui.plot_talk("Take heed and bear witness to the truths that lie herein, for they are the last legacy of the Horadrim. Nearly three hundred years ago, it came to be known that the three Prime Evils of the Burning Hells had mysteriously come to our world. The Three Brothers ravaged the lands of the East for decades, while humanity was left trembling in their wake. Our order - the Horadrim - was founded by a group of secretive Magi to hunt down and capture the three Evils once and for all. The original Horadrim captured two of the Three within powerful artifacts known as Soulstones and buried them deep beneath the desolate Eastern sands. The third Evil escaped capture and fled to the West with many of the Horadrim in pursuit. The third Evil - known as Diablo, the Lord of Terror - was eventually captured, his essence set in a Soulstone and buried within this Labyrinth. Be warned that the Soulstone must be kept from discovery by those not of the Faith. If Diablo were to be released, he would seek a body that would be easily controlled as he would be very weak - perhaps that of an old man or a child.")
	end,
}

Cell{
	-- Church, level 4
	proto = "story_tome",
	name = "The Realms Beyond",
	activates = "the_realms_beyond",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar07.wav')
		ui.plot_talk("All praises to Diablo - Lord of Terror and survivor of the Dark Exile. When he awakened from his long slumber, my Lord and master spoke to me of secrets that few mortals know. He told me the kingdoms of the High Heavens and the pits of the Burning Hells engage in an eternal war. He revealed the powers that have brought this discord to the realms of man. My master has named the battle for this world and all who exist here the Sin War.")
	end,
}

Cell{
	-- Catacombs, level 8
	proto = "story_tome",
	name = "Tale of the Three",
	activates = "tale_of_the_three",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar08.wav')
		ui.plot_talk("Glory and approbation to Diablo, Lord of Terror and leader of the Three. My lord spoke to me of his two brothers, Mephisto and Baal, who were banished to this world long ago. My lord wishes to bide his time and harness his awesome power so that he may free his captive brothers from their tombs beneath the sands of the east. Once my lord releases his brothers, The Sin War will once again know the fury of the three.")
	end,
}

Cell{
	-- Caves, level 12
	proto = "story_tome",
	name = "The Black King",
	activates = "the_black_king",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar09.wav')
		ui.plot_talk("Hail and sacrifice to Diablo, Lord of Terror and Destroyer of Souls. When I awoke my Master from his sleep, he attempted to posses a mortal's form. Diablo attempted to claim the body of King Leoric, but my master was too weak from his imprisonment. My Lord required a simple and innocent anchor to this world, and so found the boy Albrecht perfect for the task. While the good King Leoric was left maddened by Diablo's unsuccessful possession, I kidnapped his son Albrecht and brought him before my Master. I now await Diablo's call and pray that I will be rewarded when he at last emerges as the Lord of this world.")
	end,
}

Cell{
	-- Church, level 4
	proto = "story_tome",
	name = "Dark Exile",
	activates = "dark_exile",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar04.wav')
		ui.plot_talk("So it came to be that there was a great revolution within the Burning Hells known as the Dark Exile. The Lesser Evils overthrew the three Prime Evils and banished their spirit forms to the mortal realm. The Demons Belial (the Lord of Lies) and Azmodan (the Lord of Sin) fought to claim rulership of Hell during the abscence of the Three Brothers. All of Hell polarized between the factions of Belial and Azmodan while the forces of the High Heavens continually battered upon the very gates of Hell.")
	end,
}

Cell{
	-- Catacombs, level 8
	proto = "story_tome",
	name = "Sin War",
	activates = "sin_war",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar05.wav')
		ui.plot_talk("Many Demons travelled to the mortal realm in search of the Three Brothers. These Demons were followed to the mortal plane by Angels who hunted them throughout the vast cities of the East. The Angels allied themselves with a secretive order of mortal Magi named the Horadrim, who quickly became adept at hunting Demons. They also made many dark enemies in the underworlds.")
	end,
}

Cell{
	-- Caves, level 12
	proto = "story_tome",
	name = "Binding of the Three",
	activates = "binding_of_the_three",

	OnAct = function(x, y)
		ui.play_sound('sound/sfx/narrator/nar06.wav')
		ui.plot_talk("So it came to be that the Three Prime Evils were banished in spirit form to the mortal realm and after sewing chaos across the East for decades, they were hunted down by the cursed Order of the mortal Horadrim. The Horadrim used artifacts called Soulstones to contain the essence of Mephisto, the Lord of Hatred and his brother Baal, the Lord of Destruction. The youngest brother - Diablo, the Lord of Terror - escaped to the west. Eventually the Horadrim captured Diablo within a Soulstone as well, and buried him under an ancient, forgotten Cathedral. There, the Lord of Terror sleeps and awaits the time of his rebirth. Know ye that he will seek a body of youth and power to possess - one that is innocent and easily controlled. He will then arise to free his Brothers and once more fan the flames of the Sin War...")
	end,
}
