-- global utility functions --

-- declaration function --
function declare (name, initval)
  rawset(_G, name, initval or false)
end

-- create sequential function using upvalues
function create_seq_function(func1,func2)
	if func2 == nil then return func1 end
	if func1 == nil then return func2 end
	return 
		function(...) 
			func1(...)
			func2(...)
		end
end


-- prototype function --
function apply_prototype( proto, item )
  for k,v in pairs(proto) do
    if k~='id' and not item[k] then
       item[k] = v
	end
  end
  if proto.proto then
    if type(proto.proto) == 'string' then
      apply_prototype( prototypes[proto.proto], item )
	elseif type(proto.proto) == 'table' then
	  apply_prototype( proto.proto, item )
	end
  end
  item.proto = proto
end


-- make_id function --
function make_id(name)
  return string.lower(string.gsub(name," ","_"))
end

-- storage registering function --
function register( storage, element )
	element.name = element.name or "error"
	element.id = element.id or make_id(element.name)
	if not storage.__counter then storage.__counter = 0 end
	if element.nid ~= 0 then
		storage.__counter = storage.__counter + 1
		element.nid = storage.__counter
	end
	storage[element.id] = element
	storage[element.nid] = element
end

-- create a set from a list
function table.to_set( list )
	local s = {}
	for _,v in ipairs( list ) do 
		s[v] = true
	end
	return s
end


function table.random( t )
	return t[ math.random( #t ) ]
end

function table.merge( t, t2 )
	for k, v in pairs(t2) do 
		if not t[k] then t[k] = v end
	end
end

function table.copy( t )
	local u = { }
	for k, v in pairs(t) do u[k] = v end
	return u
end

function table.icopy( t )
	local u = { }
	for k, v in ipairs(t) do u[k] = v end
	return u
end

function table.find( t, element )
	for _, v in pairs(t) do
		if element == v then
			return true
		end
	end
	return false
end

function table.ifind( t, element )
	for _, v in ipairs(t) do
		if element == v then
			return true
		end
	end
	return false
end

