/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the
** original author.
**
****************************************************************************/


#include "maemohorizontaldivider.h"

MaemoHorizontalDivider::MaemoHorizontalDivider(QString title, QWidget *parent) :
    QFrame(parent)
{
    QHBoxLayout *layout = new QHBoxLayout(this);
    setLayout(layout);

    this->setFrameStyle(QFrame::Plain);
    this->setFrameShape(QFrame::HLine);
    this->setStyleSheet("QFrame { color: #282828; }");
    this->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);

    m_titleLabel = new QLabel(title, this);
    m_titleLabel->setStyleSheet("background-color: black;\ncolor: white;");
    m_titleLabel->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    layout->addWidget(m_titleLabel);

    show();
    m_titleLabel->setMaximumWidth(m_titleLabel->sizeHint().width()+30);
}
