/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the
** original author.
**
****************************************************************************/

#ifndef IMAGEVIEWERWIDGET_H
#define IMAGEVIEWERWIDGET_H

#include <QMainWindow>

class QLabel;
class QMenu;
class QScrollArea;
class QScrollBar;

class ImageViewerWidget : public QWidget
{
    Q_OBJECT

public:
    ImageViewerWidget(QWidget *parent);
    ~ImageViewerWidget();
    bool open(QString filePath);

public slots:
    void zoomIn();
    void zoomOut();
    void fitToWindow();

protected:
    void mouseDoubleClickEvent ( QMouseEvent * event );

private:
    void scaleImage(double factor);
    void adjustScrollBar(QScrollBar *scrollBar, double factor);

    QLabel *m_imageLabel;
    QScrollArea *m_scrollArea;
    double m_scaleFactor;
    double m_defaultScale;
};

#endif
