/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#ifndef DGSPLAYVIEW_H
#define DGSPLAYVIEW_H

#include <QtGui>
#include <QDebug>
#include <QList>
#include <QTimeLine>
#include <QTimer>
#include "dgsdata.h"
#include "dgsholespinbox.h"
#include "FullScreenExitButton.h"
#include "dgscoursemapview.h"
namespace Ui
{
    class DGSPlayView;
}

class DGSPlayView : public QMainWindow {
    Q_OBJECT
public:
    DGSPlayView(DGSData *data, QWidget *parent = 0);
    ~DGSPlayView();

protected:
    void closeEvent(QCloseEvent *event);
    void changeEvent(QEvent *e);

private:
    Ui::DGSPlayView *ui;
    QList<DGSHoleSpinBox*> m_playHoles;
    QPropertyAnimation *m_animation;
    QAction *actionSaveAndExit;
    QAction *actionDiscard;
    QTimer *m_completionTimer;
    DGSData *m_data;
    QList<int> m_pars;
    bool m_saved;
    DGSCourseMapView *m_mapView;

    void scrollContents(bool toRight);
    void addScoreSpinBoxes();

private slots:
    void refreshPlayScore();
    int completedHolesCount();
    void holeScoreChanged();
    void toggleFullScreen();
    void saveScores();
    void saveScoresAndExit();
    void exitPlayView();

    void showCourseMap();
    void mapViewClosed();

    //Play view scrolling
    void scrollContentsRight();
    void scrollContentsLeft();

    void showEndRoundDialog();
signals:
    void error(QString errorMsg);
    void exited();

};

#endif // DGSPLAYVIEW_H
