/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#ifndef DGSMAINWINDOW_H
#define DGSMAINWINDOW_H

#include <QtGui>
#include <QDebug>
#include <QItemSelectionModel>
#include <QList>

#include "dgsdata.h"
#include "dgsplayview.h"
#include "dgsscorewindow.h"
#include "dgscoursesettingsdialog.h"
#include "autoclearinglineedit.h"

namespace Ui
{
    class DGSMainWindow;
}

class DGSMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    DGSMainWindow(QWidget *parent = 0);
    ~DGSMainWindow();

private:
    Ui::DGSMainWindow *ui;
    void initModelsAndMappers();
    void firstTimeSetup();
    DGSData *m_data;
    int m_selectedRow;
    AutoClearingLineEdit *m_lineEditFilter;

private slots:
    //View changes
    void disableMenuButtons(bool setDisabled);
    void initScoreView();
    void initPlayView();
    void courseSelectionChanged(QModelIndex index);
    void filterCourses(QString);

    //Handle clicks from the ui
    void addCourseClicked();
    void editCourseClicked();

    //Modify the data
    void editCourse(int courseRow);
    void deleteCourse();

    //Error handling
    void showFatalError(QString error);
};

#endif // DGSMAINWINDOW_H
