#ifndef DGSCOURSESETTINGSDIALOG_H
#define DGSCOURSESETTINGSDIALOG_H

#include <QDialog>
#include <QDataWidgetMapper>
#include <QList>
#include <QSpinBox>
#include <QLabel>
#include <QMessageBox>
#include <QPushButton>
#include <QFileDialog>
#include <QNetworkAccessManager>
#include <QInputDialog>

#include "dgsdata.h"
#include "maemohorizontaldivider.h"
#include "DownloadManager.h"

namespace Ui {
    class DGSCourseSettingsDialog;
}

class DGSCourseSettingsDialog : public QDialog {
    Q_OBJECT

public:
    DGSCourseSettingsDialog(DGSData *data, int mapperRow, QWidget *parent = 0);
    ~DGSCourseSettingsDialog();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::DGSCourseSettingsDialog *ui;
    DGSData *m_data;
    void initMapper(int mapperRow);
    void removeHoleFromUI();
    void addHoleToUI();
    void addNewCourse();
    void modifyCourse();

    QDataWidgetMapper *m_mapper;
    QList<QSpinBox*> m_parSpinBoxes;
    QList<QSpinBox*> m_lengthSpinBoxes;
    QList<QLabel*> m_parLabels;
    QList<QLabel*> m_lengthLabels;

private slots:
    void refreshHoleCount(int holeCount);
    void saveSettings();
    void discardSettings();

    void selectCourseMapFromUrl();
    void selectLocalFile();
    void setCourseMap(QString mapFilePath);

signals:
    void error(QString errMsg);
};

#endif // DGSCOURSESETTINGSDIALOG_H
