#ifndef DGSSCOREWINDOW_H
#define DGSSCOREWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QModelIndex>
#include <QCloseEvent>
#include <QGroupBox>

#if defined(Q_WS_MAEMO_5)
#include <QtMaemo5>
#endif

#include "dgsdata.h"
#include "maemohorizontaldivider.h"

namespace Ui {
    class DGSScoreWindow;
}

class DGSScoreWindow : public QMainWindow {
    Q_OBJECT
public:
    DGSScoreWindow(DGSData *data, QWidget *parent = 0);
    ~DGSScoreWindow();

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *event);

private:
    Ui::DGSScoreWindow *ui;
    QString m_selectedCourse;
    DGSData *m_data;
    void refreshScoreLabels();
    QList< QGroupBox* > m_scoreGroupBoxes;
#if defined(Q_WS_MAEMO_5)
    QList< MaemoHorizontalDivider* > m_dividers;
    QMaemo5ListPickSelector *m_roundSelector;
    QMaemo5ListPickSelector *m_courseSelector;
#endif
    void setupUi();
    void setupMaemoUi();
    void clearRoundDetails();
    void drawScores(QList<int> scores, QList<int> pars);
    void setRoundFiltering(QSqlQueryModel *filteredModel);

signals:
    void error(QString errMsg);
    void exited();

private slots:
    void refreshCourseAndRound();
    void refreshCourseDetails();

    void refreshRound();
    void refreshRoundListing();
    void refreshRoundDetails();

    void exitScoreWindow();
    void removeRound();
};

#endif // DGSSCOREWINDOW_H
