/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#ifndef DGSSCOREMODEL_H
#define DGSSCOREMODEL_H

#include <QSqlTableModel>
#include <QtSql>
#include <QDebug>

class DGSScoreModel : public QSqlTableModel
{
Q_OBJECT
public:
    explicit DGSScoreModel(QObject *parent, QSqlDatabase db);
    bool saveScores(int round_id, QList<int> hole_ids, QList<int> scores);
    int getRoundScore(int round_id) const;
    QList<int> getRoundScores(int round_id) const;
    bool deleteRoundScores(int round_id);

signals:

public slots:

};

#endif // DGSSCOREMODEL_H
