/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#ifndef DGSROUNDMODEL_H
#define DGSROUNDMODEL_H

#include <QtSql>
#include <QDebug>
#include <QSqlRelationalTableModel>
#include <QString>

class DGSRoundModel : public QSqlRelationalTableModel
{
Q_OBJECT
public:
    explicit DGSRoundModel(QObject *parent, QSqlDatabase db);
    int saveRound(int course_id, QString startTime, QString endTime);
    bool deleteRound(int round_id);
    QList<int> getRounds(int course_id) const;
    int getCourseId(int round_id) const;
    QDateTime getStartTime(int round_id) const;
    QDateTime getEndTime(int round_id) const;

signals:

public slots:

};

#endif // DGSROUNDMODEL_H
