/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#include "dgsholespinbox.h"

DGSHoleSpinBox::DGSHoleSpinBox(QWidget *parent) :
    QSpinBox(parent)
{
    this->setMinimumSize(120,220);
    this->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    this->setStyleSheet("font: 75 48pt \"Calibri\"; \ncolor:white; \nselection-color:white;");
}

void DGSHoleSpinBox::setFontSize(int sizeInPt)
{
    QString styleSheet = this->styleSheet();
    QString replacer = QString().setNum(sizeInPt).append("pt");
    styleSheet = styleSheet.replace(QRegExp("(\\d+pt)"),replacer);
    setStyleSheet(styleSheet);
}
void DGSHoleSpinBox::setFontColor(QString color)
{
    QString styleSheet = this->styleSheet();
    QString fontColor("\ncolor:" + color +";");
    QString selColor("\nselection-color:" + color +";");
    styleSheet = styleSheet.replace(QRegExp("(\ncolor:.{3,7};)"), fontColor);
    styleSheet = styleSheet.replace(QRegExp("(\nselection-color:.{3,7};)"), selColor);
    setStyleSheet(styleSheet);
}
