/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#include "dgscoursemodel.h"

DGSCourseModel::DGSCourseModel(QObject *parent, QSqlDatabase db)
    : QSqlTableModel(new QSqlTableModel(parent, db))
{
    qDebug() << "Initializing the course model";
    this->setTable("courses");
    this->setEditStrategy(QSqlTableModel::OnManualSubmit);
    this->setSort(1, Qt::AscendingOrder);

    if (!db.isValid() || !this->select())
    {
        qDebug() << __FUNCTION__ << " Courses model init failed:" << db.lastError().text() << this->lastError().text();
    }
}

int DGSCourseModel::getCourseId(QString name) const
{
    if (name.toInt() != 0)
    {
        return name.toInt();
    }
    if ( !this->database().isOpen() )
    {
        qDebug() << "DB error @" << "DGSCourseModel::" <<__FUNCTION__;
        return 0;
    }
    QSqlQuery query;
    query.prepare("SELECT course_id FROM courses WHERE name = :parameter");
    query.bindValue(":parameter", name);
    query.exec();
    query.next();
    if (query.isValid())
    {
        return query.value(0).toInt();
    }
    else
    {
        qDebug() << "Query failed at DGSCourseModel::" <<__FUNCTION__ << "(" << name << ")"<< query.lastError();
        return 0;
    }
}

QString DGSCourseModel::getCourseName(int id) const
{
    return getCourseDetail(id, "name");
}

QString DGSCourseModel::getCourseLocation(int id) const
{
    return getCourseDetail(id, "location");
}

QString DGSCourseModel::getCourseNotes(int id) const
{
    return getCourseDetail(id, "notes");
}

QString DGSCourseModel::getCourseMapPath(int id) const
{
    return getCourseDetail(id, "map_image");
}
QString DGSCourseModel::getCourseDetail(int id, QString fieldName) const
{
    if ( !this->database().isOpen() )
    {
        qDebug() << "DB error @" << "DGSCourseModel::" <<__FUNCTION__;
        return "";
    }
    QSqlQuery query;
    query.prepare("SELECT "+fieldName+" FROM courses WHERE course_id = ?");
    query.bindValue(0, id);
    query.exec();
    query.next();
    if (query.isValid())
    {
        return query.value(0).toString();
    }
    else
    {
        qDebug() << "Query failed at DGSCourseModel::" <<__FUNCTION__ << query.lastError();
        return "";
    }
}

bool DGSCourseModel::removeCourse(int course_id)
{
    if ( !this->database().isOpen() )
    {
        qDebug() << "DB error @" << "DGSCourseModel::" <<__FUNCTION__;
        return false;
    }
    QSqlQuery query;
    query.prepare(QString("DELETE FROM courses WHERE course_id = ? ")                  );
    query.bindValue(0, course_id);
    query.exec();
    query.prepare(QString("DELETE FROM holes WHERE course_id = ? ")                  );
    query.bindValue(0, course_id);
    query.exec();
    query.prepare(QString("DELETE FROM rounds WHERE course_id = ? ")                  );
    query.bindValue(0, course_id);
    query.exec();

    this->select();
    if (query.lastError().isValid())
    {
        qDebug() << "Deleting course failed at DGSHoleModel::" <<__FUNCTION__ << query.lastError();
        return false;
    }

    return true;
}
