#include "FullScreenExitButton.h"

FullScreenExitButton::FullScreenExitButton(QWidget *parent)
    : QToolButton(parent)
{
    Q_ASSERT(parent);

    // set the fullsize icon from Maemo's theme
    setIcon(QIcon::fromTheme(QLatin1String("general_fullsize")));

    // ensure that our size is fixed to our ideal size
    setFixedSize(sizeHint());

    // set the background to 0.5 alpha
    QPalette pal = palette();
    QColor backgroundColor = pal.color(backgroundRole());
    backgroundColor.setAlpha(128);
    pal.setColor(backgroundRole(), backgroundColor);
    setPalette(pal);

    // ensure that we're painting our background
    setAutoFillBackground(true);

    // when we're clicked, tell the parent to toggle fullscreen
    connect(this, SIGNAL(clicked()), parent, SLOT(toggleFullScreen()));

    // install an event filter to listen for the parent's events
    parent->installEventFilter(this);
    setVisible(true);
}

bool FullScreenExitButton::eventFilter(QObject *obj, QEvent *event)
{
    if (obj != parent())
        return QToolButton::eventFilter(obj, event);

    QWidget *parent = parentWidget();
    raise();

    if ((event->type() == QEvent::Resize && isVisible()) || event->type() == QEvent::Show)
    {
        move(parent->width() - width(), parent->height() - height());
    }

    return QToolButton::eventFilter(obj, event);
}
