/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the
** original author.
**
****************************************************************************/

#include <QtGui>

#include "imageviewerwidget.h"

ImageViewerWidget::ImageViewerWidget(QWidget *parent)
    : QWidget(parent)
{
    qDebug() << "Initializing ImageViewerWidget";
    m_imageLabel = new QLabel;
    m_imageLabel->setBackgroundRole(QPalette::Base);
    m_imageLabel->setSizePolicy(QSizePolicy::Ignored, QSizePolicy::Ignored);
    m_imageLabel->setScaledContents(true);

    m_scrollArea = new QScrollArea;
    m_scrollArea->setBackgroundRole(QPalette::Dark);
    m_scrollArea->setWidget(m_imageLabel);
    m_scrollArea->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    m_scrollArea->setContentsMargins(0,0,0,0);

    QGridLayout *layout = new QGridLayout(this);
    this->setLayout(layout);
    layout->setContentsMargins(0,0,0,0);
    layout->addWidget(m_scrollArea,0,0);
    show();
}

ImageViewerWidget::~ImageViewerWidget()
{
    qDebug() << "Image Viewer Destroyed";
}

void ImageViewerWidget::mouseDoubleClickEvent ( QMouseEvent *event )
{
    zoomIn();
}

bool ImageViewerWidget::open(QString filePath)
{
    qDebug() << "Opening" << filePath;
    if (!filePath.isEmpty()) {
        QImage image(filePath);
        if (!image.isNull())
        {
            m_imageLabel->setPixmap(QPixmap::fromImage(image));
            m_defaultScale = (double)(m_scrollArea->width()-10) / (double)QPixmap::fromImage(image).width();
            qDebug() << m_defaultScale;
            fitToWindow();
            return true;
        }
    }
    qDebug() << "No map file to show";
    QHBoxLayout *layout = new QHBoxLayout();
    layout->addWidget(m_imageLabel);
    m_scrollArea->setLayout(layout);
    m_scrollArea->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Maximum);
    m_scrollArea->setMaximumHeight(100);
    m_imageLabel->setText(tr("Course map not found."));
    m_imageLabel->setStyleSheet("background-color: #000000; color: #FFFFFF;");

    return false;
}

void ImageViewerWidget::zoomIn()
{
    scaleImage(1.25);
    qDebug() << "Zooming in...";
}

void ImageViewerWidget::zoomOut()
{
    scaleImage(0.8);
    qDebug() << "Zooming out...";
}

void ImageViewerWidget::fitToWindow()
{
    QSize size = m_defaultScale * m_imageLabel->pixmap()->size();
    m_imageLabel->resize(size);
    m_scaleFactor = m_defaultScale;
    qDebug() << "Zoom level reset" << size;
}


void ImageViewerWidget::scaleImage(double factor)
{
    Q_ASSERT(m_imageLabel->pixmap());
    m_scaleFactor *= factor;
    m_imageLabel->resize(m_scaleFactor * m_imageLabel->pixmap()->size().width(), m_scaleFactor * m_imageLabel->pixmap()->size().height());

    adjustScrollBar(m_scrollArea->horizontalScrollBar(), factor);
    adjustScrollBar(m_scrollArea->verticalScrollBar(), factor);

}

void ImageViewerWidget::adjustScrollBar(QScrollBar *scrollBar, double factor)
{
    scrollBar->setValue(int(factor * scrollBar->value()
                            + ((factor - 1) * scrollBar->pageStep()/2)));
}
