/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#ifndef DGSHOLEMODEL_H
#define DGSHOLEMODEL_H

#include <QtSql>
#include <QDebug>
#include <QSqlRelationalTableModel>

class DGSHoleModel : public QSqlRelationalTableModel
{
    Q_OBJECT
public:
    explicit DGSHoleModel(QObject *parent, QSqlDatabase db);
    bool replaceHoleDetails(int course_id, QList<int> pars, QList<double> lengths, QList<QString> positions);
    QList<int> getPars(int course_id) const;
    QList<int> getLengths(int course_id) const;
    int getHoleCount(int course_id) const;
    int getCourseParScore(int course_id) const;
    QList<int> getHoleIds(int course_id) const;

private:
    QList<int> getHoleDetails(int id, QString fieldName) const; // A generic function

signals:

public slots:

};

#endif // DGSHOLEMODEL_H
