/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#ifndef DGSDATA_H
#define DGSDATA_H

#include <QDebug>
#include <QtSql>
#include <QObject>
#include <QSqlTableModel>
#include <QDateTime>

#include "dgscoursemodel.h"
#include "dgsscoremodel.h"
#include "dgsholemodel.h"
#include "dgsroundmodel.h"

class DGSData : public QObject
{
        Q_OBJECT
public:
    DGSData(QWidget *parent);
    ~DGSData();
    bool isValid();

    bool saveScores(QList<int> scores);
    int addCourseRow();
    void removeSelectedCourse();
    void removeSelectedRound();
    void saveCourseChanges(QList<int> pars, QList<double> lengths, QList<QString> positions);
    void cancelCourseChanges();

    void setCurrentCourse(int id);
    void setCurrentCourse(QString name);
    void setCurrentRound(int id);
    int currentRound();
    int currentCourse();
    bool roundIsValid(int id = -1);
    bool courseIsValid(int id = -1);

    void setPlayStartTime();
    QList<int> coursePars();
    QList<int> courseLengths();

    int courseRecord() const;
    int courseHoleCount() const;
    QString courseName() const;
    QString courseName(int course_id) const;
    QString courseLocation() const;
    QString courseNotes() const;
    QString courseMapPath() const;
    int courseId(QString courseName) const;
    int courseParScore();
    QList<int> roundScores() const;
    int roundScore();
    QString roundDuration() const;

    DGSCourseModel *getCourseModel();

    QSqlQueryModel *getHoleViewModel();
    QSqlQueryModel *getScoreViewModel(QModelIndex index);
    QSqlQueryModel *getRoundViewModel(int course_id = 0);
    QSqlQueryModel *getRoundViewModel(QString courseName);

private:
    bool createDbConnection();
    void removeDbConnection();
    void initModels();

    //For testing use
    void createRandomRound();
    void createRandomCourse();

    QSqlDatabase m_db;
    bool m_isValid;
    QString m_lastError;
    DGSCourseModel *m_courses;
    DGSScoreModel *m_scores;
    DGSHoleModel *m_holes;
    DGSRoundModel *m_rounds;

    QSqlQueryModel *m_roundViewModel;

    int m_currentCourseId;
    int m_currentRoundId;
    QDateTime m_playStartTime;

signals:
    void error(QString error);

public slots:
};

#endif // DGSDATA_H
