/****************************************************************************
**
** Copyright (C) 2010 Mikko Mattila
** Contact: (Gmail: mattila.mikko)
**
** This file is part of DGScores.
**
** GNU General Public License Usage
** This file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact the 
** original author.
**
****************************************************************************/

#ifndef DGSCOURSEMODEL_H
#define DGSCOURSEMODEL_H

#include <QtSql>
#include <QSqlTableModel>
#include <QDebug>

class DGSCourseModel : public QSqlTableModel
{
public:
    DGSCourseModel(QObject *parent, QSqlDatabase db);
    int getCourseId(QString name) const;
    QString getCourseName(int course_id) const;
    QString getCourseLocation(int course_id) const;
    QString getCourseNotes(int id) const;
    QString getCourseMapPath(int id) const;
    bool removeCourse(int course_id);

private:
    QString getCourseDetail(int id, QString fieldName) const;
};

#endif // DGSCOURSEMODEL_H
