#include "dgscoursemapview.h"
#include "ui_dgscoursemapview.h"

DGSCourseMapView::DGSCourseMapView(DGSData *data, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::DGSCourseMapView)
{
    m_data = data;
    ui->setupUi(this);

    ui->labelHoleCount->setText(tr("Hole Count: ") + QString().setNum(m_data->courseHoleCount()));
    ui->labelLocation->setText(m_data->courseLocation());
    ui->labelName->setText(m_data->courseName());
    ui->labelNotes->setText(m_data->courseNotes());

    m_imageViewer = new ImageViewerWidget(this);
    ui->verticalLayoutMap->addWidget(m_imageViewer);

    connect(ui->actShowInfo, SIGNAL(triggered()), this, SLOT(toggleInfo()));
    connect(ui->actionClose, SIGNAL(triggered()), this, SLOT(exitDialog()));
    connect(ui->actZoomIn, SIGNAL(triggered()), m_imageViewer, SLOT(zoomIn()));
    connect(ui->actZoomOut, SIGNAL(triggered()), m_imageViewer, SLOT(zoomOut()));
    connect(ui->actZoomReset, SIGNAL(triggered()), m_imageViewer, SLOT(fitToWindow()));
    ui->actZoomReset->setIcon(QIcon::fromTheme("zoom-fit-best", QIcon(":/res/images/white-zoom-fit.png")));
    ui->actZoomIn->setIcon(QIcon::fromTheme("zoom-in", QIcon(":/res/images/white-zoom-in.png")));
    ui->actZoomOut->setIcon(QIcon::fromTheme("zoom-out", QIcon(":/res/images/white-zoom-out.png")));
    ui->actionClose->setIcon(QIcon::fromTheme("window-close"));
    ui->actShowInfo->setIcon(QIcon::fromTheme("dialog-information"));


#if defined(Q_WS_MAEMO_5)
    showFullScreen();
#elif defined(Q_OS_SYMBIAN)
    showFullScreen();
#else
    resize(800, 480);
#endif
    show();

    QString mapImage = m_data->courseMapPath();
    if (!m_imageViewer->open(mapImage))
    {
        ui->actShowInfo->setDisabled(true);
        ui->actZoomIn->setDisabled(true);
        ui->actZoomOut->setDisabled(true);
        ui->actZoomReset->setDisabled(true);
    }
    else
    {
        toggleInfo();
    }
}

void DGSCourseMapView::exitDialog()
{
    qDebug() << "Exiting Map Dialog";
    emit exited();
    this->close();
}

DGSCourseMapView::~DGSCourseMapView()
{
    qDebug() << "Course Map View destroyed";
    delete ui;
}

void DGSCourseMapView::toggleInfo()
{
    if (ui->scrollAreaInfo->isVisible())
    {
        qDebug() << "Hiding Course Info";
        ui->scrollAreaInfo->hide();
    }
    else
    {
        qDebug() << "Showing Course Info";
        ui->scrollAreaInfo->show();
    }
}
