#include "autoclearinglineedit.h"

AutoClearingLineEdit::AutoClearingLineEdit(QString defaultText, QWidget *parent) :
    QLineEdit(parent)
{
    m_defaultText = defaultText;
    setText(m_defaultText);
}


void AutoClearingLineEdit::focusInEvent ( QFocusEvent *e )
{
    if (this->text().compare(m_defaultText) == 0)
    {
        this->setText("");
    }
}

void AutoClearingLineEdit::focusOutEvent ( QFocusEvent *e )
{
    if (this->text().compare("") == 0)
    {
        this->setText(m_defaultText);
    }
}

bool AutoClearingLineEdit::hasValidFilter() const
{
    if (text().compare(m_defaultText) == 0 || text().compare("") == 0)
    {
        return false;
    }
    return true;
}
