TARGET = dgscores
SOURCES += src/main.cpp \
    src/dgsmainwindow.cpp \
    src/dgsdata.cpp \
    src/dgscoursemodel.cpp \
    src/dgsscoremodel.cpp \
    src/dgsholemodel.cpp \
    src/dgsroundmodel.cpp \
    src/dgsholespinbox.cpp \
    src/dgsplayview.cpp \
    src/dgsscorewindow.cpp \
    src/dgscoursesettingsdialog.cpp \
    src/maemohorizontaldivider.cpp \
    src/dgscoursemapview.cpp \
    src/autoclearinglineedit.cpp \
    src/imageviewerwidget.cpp \
    src/DownloadManager.cpp \
    src/FullScreenExitButton.cpp
HEADERS += dgsmainwindow.h \
    src/dgsdata.h \
    src/dgscoursemodel.h \
    src/dgsscoremodel.h \
    src/dgsholemodel.h \
    src/dgsroundmodel.h \
    src/FullScreenExitButton.h \
    src/dgsholespinbox.h \
    src/dgsplayview.h \
    src/dgsscorewindow.h \
    src/dgscoursesettingsdialog.h \
    src/maemohorizontaldivider.h \
    src/dgscoursemapview.h \
    src/autoclearinglineedit.h \
    src/imageviewerwidget.h \
    src/DownloadManager.h
FORMS += dgsmainwindow.ui \
    uis/dgsplayview.ui \
    uis/dgsscorewindow.ui \
    uis/dgscoursesettingsdialog.ui \
    uis/dgscoursemapview.ui
RESOURCES += dgsresources.qrc

TRANSLATIONS += dgs_fi.ts

# LEXS#
LEXSOURCES += 

# YACCS#
YACCSOURCES += 
INCLUDEPATH += 
LIBS += 
DEFINES += 

# All generated files goes same directory
OBJECTS_DIR = build
MOC_DIR = build
UI_DIR = build
DESTDIR = build
TEMPLATE = app
DEPENDPATH += 
VPATH += src \
    uis
CONFIG -= 
CONFIG += debug
QT = core \
    gui \
    sql \
    maemo5 \
    network

INSTALLS += target desktop icon64 icon40 icon26

target.path = /usr/bin/

desktop.path = /usr/share/applications/hildon
desktop.files = src/$${TARGET}.desktop

icon64.path = /usr/share/icons/hicolor/64x64/apps
icon64.files = src/images/64x64/$${TARGET}.png

icon40.path = /usr/share/icons/hicolor/40x40/apps
icon40.files = src/images/40x40/$${TARGET}.png

icon26.path = /usr/share/icons/hicolor/26x26/apps
icon26.files = src/images/26x26/$${TARGET}.png

# Targets for debian source and binary package creation
debian-src.commands = dpkg-buildpackage \
    -S \
    -r \
    -us \
    -uc \
    -d
debian-bin.commands = dpkg-buildpackage \
    -b \
    -r \
    -uc \
    -d
debian-all.depends = debian-src \
    debian-bin

# Clean all but Makefile
compiler_clean.commands = -$(DEL_FILE) \
    $(TARGET)
QMAKE_EXTRA_TARGETS += debian-all \
    debian-src \
    debian-bin \
    compiler_clean
