#ifndef TEKSTITV_H
#define TEKSTITV_H

#include <QtGui>
#include <QNetworkReply>
#include <QString>
#include "imagewidget.h"

class TekstiTv : public QWidget
{
    Q_OBJECT

    public:
        TekstiTv(QWidget *parent = 0);

        void setLandscape();
        void setPortrait();
    protected:
        void keyReleaseEvent ( QKeyEvent * event );

    public slots:
        void changeSubPage(int increment);
        void changePage(int increment);
        void numberPressed(int pressedNumber);
        //void orientationChanged(const QString &newOrientation);

    private slots:
        void getTekstiTv();
        void getPrediction();
        void getSubPrediction();
        void predictionReceived(QNetworkReply *reply);
        void subPredictionReceived(QNetworkReply *reply);
        void tekstiTvReceived(QNetworkReply *reply);
        void resizeRequestReceived();
    protected:
        //bool event(QEvent *ev);
    private:
        void createFingerKeys();
        //void addRotationAwareness();
    private:
        QWidget *parent;
        QLabel *lblPageNumber;
        //QLabel *lblImageTekstiTv;
        ImageWidget *lblImageTekstiTv;
        int page;
        int subPage;
        int nextPage;
        int prevPage;
        int nextSubPage;
        int nextPrevPage;
        QString *predictionStr;
        QString *nextPrediction;
        QString *previousPrediction;
        QString *nextSubPrediction;
        QString *previousSubPrediction;

        QPixmap *imageData;
        int imageWidth;
        int imageHeight;
        int bigImageWidth;
        int bigImageHeight;
        bool showButtons;

        QWidget *central;
        QHBoxLayout *mainLayout;
        QVBoxLayout *portLayout;
        QGridLayout *numberGrid;
        QGroupBox *numberGroup;

        enum screenMode { ScreenLandscape, ScreenPortrait };
        int screenTilt;

        enum fullScreen { FullScreenOff, FullScreenOn };
        int screen;
};

#endif // TEKSTITV_H
