#ifndef ABSTRACTTEKSTITV_H
#define ABSTRACTTEKSTITV_H

#include <QObject>
#include <QNetworkReply>

class AbstractTekstiTv : QObject
{
    Q_OBJECT
public:
    AbstractTekstiTv();

public slots:

virtual void getPrediction() = 0;
virtual void getSubPrediction() = 0;

private slots:

virtual void predictionReceived(QNetworkReply *reply) = 0;
virtual void subPredictionReceived(QNetworkReply *reply) = 0;
virtual void tekstiTvReceived(QNetworkReply *reply) = 0;

signals:

virtual void receivedTekstiTv(QPixmap *image);
virtual void receivedPrediction(int page, int subPage);

private:

virtual void getTekstiTv() = 0;

public:

QString predictionStr;
QString nextPrediction;
QString previousPrediction;
QString nextSubPrediction;
QString previousSubPrediction;

int page;
int subPage;

};

#endif // ABSTRACTTEKSTITV_H
