#ifndef TEKSTITV_H
#define TEKSTITV_H

#include <QtGui>
#include <QNetworkReply>
#include <QString>
#include "imagewidget.h"
#include "abstracttekstitv.h"

class TekstiTv : public QWidget
{
    Q_OBJECT

    public:
        TekstiTv(QWidget *parent = 0);

        void setLandscape();
        void setPortrait();
        QList<QString> getSiteNames();
    protected:
        void keyReleaseEvent ( QKeyEvent * event );

    public slots:
        void changeSubPage(int increment);
        void changePage(int increment);
        void numberPressed(int pressedNumber);
        void receivedPrediction(int page, int subPage);
        void receivedTekstiTv(QPixmap *imageData);
        //void orientationChanged(const QString &newOrientation);
        void reload();
        void siteSelected(QString siteName);
        void writeSites();
    private slots:
        void resizeRequestReceived();
    protected:
        //bool event(QEvent *ev);
    private:
        void createFingerKeys();
        void readSites();
    private:
        QWidget *parent;
        QLabel *lblPageNumber;
        ImageWidget *lblImageTekstiTv;
        int page;
        int subPage;

        QPixmap *imageData;
        int imageWidth;
        int imageHeight;
        int bigImageWidth;
        int bigImageHeight;
        bool showButtons;

        QWidget *central;
        QHBoxLayout *mainLayout;
        QVBoxLayout *portLayout;
        QGridLayout *numberGrid;
        QGroupBox *numberGroup;

        QMap<QString, AbstractTekstiTv*> *sites;
        QVector<QString> siteKeys;
        AbstractTekstiTv *site;
		
        enum screenMode { ScreenLandscape, ScreenPortrait };
        int screenTilt;

        enum fullScreen { FullScreenOff, FullScreenOn };
        int screen;
};

#endif // TEKSTITV_H
