#include "tekstitv.h"
#include "numberbutton.h"
#include "imagewidget.h"
#include "commontekstitv.h"
#include <QtGui>
#include <QtNetwork>
#include <QtDebug>

#ifdef Q_WS_MAEMO_5
//#include <QtDBus>
#include <QtMaemo5>

// ![0]
//#include <mce/mode-names.h>
//#include <mce/dbus-names.h>
#endif

TekstiTv::TekstiTv(QWidget *parent) : QWidget(parent), sites(new QMap<QString, AbstractTekstiTv*>()), siteKeys()
{
    this->parent = parent;
    //addRotationAwareness();

    readSites();
    if (sites->size() < 1) {
        qDebug() << "adding default site";
        site = new CommonTekstiTv(QString("http://www.yle.fi/tekstitv/images/P[page]_[2:subpage].gif"),
                                 QString("http://www.yle.fi/tekstitv/images/P[page]_[2:subpage].gif"),
                                      QString("http://www.yle.fi/tekstitv/txt/P[page]_01.html"),
                                      QString("http://www.yle.fi/tekstitv/txt/P[page]_[2:subpage].html"),
                                      QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_01.html\">\\[Edellinen sivu\\]</A>"),
                                      QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_01.html\">\\[Seuraava sivu\\]</A>"),
                                      QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P\\d+_(\\d+).html\">\\[Edellinen alasivu\\]</A>"),
                                      QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P\\d+_(\\d+).html\">\\[Seuraava alasivu\\]</A>"), 100);

            sites->insert("Yle", site);
            writeSites();
    }
    //qDebug() << "sites read";
    // debug yle
//
//    // mtv3
//    site = new CommonTekstiTv(QString("http://www.mtv3tekstikanava.fi/new2008/images/[page]-[subpage].gif"),
//                              QString("http://www.mtv3tekstikanava.fi/new2008/[page]-01.htm"),
//                              QString("http://www.mtv3tekstikanava.fi/new2008/[page]-[subpage].htm"),
//                              QString("<a href=\"(\\d+)-01.htm\">&lt;&lt; Edellinen sivu</a>"),
//                              QString("<a href=\"(\\d+)-01.htm\">Seuraava sivu &gt;&gt;</a>"),
//                              QString("<a href=\"\\d+-(\\d+).htm\">&lt;&lt; alasivu</a>"),
//                              QString("<a href=\"\\d+-(\\d+).htm\">alasivu &gt;&gt;</a>"), 2);
//
//    sites->insert("Mtv3", site);

        connect(site, SIGNAL(receivedTekstiTv(QPixmap*)), this, SLOT(receivedTekstiTv(QPixmap*)));
        connect(site, SIGNAL(receivedPrediction(int, int)), this, SLOT(receivedPrediction(int, int)));
    //connect(parent, SIGNAL(), this, SLOT(writeSites()));
    screen = FullScreenOff;
    screenTilt = ScreenLandscape;

    mainLayout = new QHBoxLayout(this);
    mainLayout->setContentsMargins(1, 1, 1, 1);
    mainLayout->setSpacing(2);
    numberGrid = new QGridLayout();
    numberGrid->setContentsMargins(1, 1, 1, 1);
    numberGrid->setSpacing(2);
    numberGroup = new QGroupBox();

    QVBoxLayout *leftLayout = new QVBoxLayout();

    page = site->startPage();
    subPage = 1;

    imageWidth = 510;
    imageHeight = 335;
    bigImageHeight = 480;
    bigImageWidth = 700;

    lblPageNumber = new QLabel(this);
    lblPageNumber->move(600,2);
    lblPageNumber->resize(100, 22);
    QFont *font = new QFont("Arial", 16, 2, false);
    lblPageNumber->setFont(*font);
    lblPageNumber->setStyleSheet("color: #00FF00; font-weight: bold");
    lblPageNumber->setNum(page);
    lblPageNumber->show();
    lblImageTekstiTv = new ImageWidget(this);
    connect(lblImageTekstiTv, SIGNAL(resizeRequest()), this, SLOT(resizeRequestReceived()));
    showButtons = true;
    leftLayout->addWidget(lblPageNumber);
    leftLayout->addWidget(lblImageTekstiTv);
    leftLayout->setAlignment(lblImageTekstiTv, Qt::AlignHCenter);
    mainLayout->addLayout(leftLayout);
    mainLayout->addWidget(numberGroup);
    numberGroup->setLayout(numberGrid);
    //#ifdef Q_WS_MAEMO_5
    createFingerKeys();
    //#endif
    //qDebug() << "tekstitv constructor in the end, getting first site"
    site->getTekstiTv(page, subPage);
}

void TekstiTv::keyReleaseEvent ( QKeyEvent * event ) {
    if (event->key() >= Qt::Key_0 && event->key() <= Qt::Key_9) {
        int pressedNumber = event->key() - 48;
        numberPressed(pressedNumber);
        return;
    }

    switch (event->key())
    {
        case Qt::Key_Left: {
                changeSubPage(-1);
                break;
            }
        case Qt::Key_Right: {
                changeSubPage(1);
                break;
            }
        case Qt::Key_Up: {
                changePage(1);
                break;
            }
        case Qt::Key_Down: {
                changePage(-1);
                break;
            }
        default: {
                QWidget::keyReleaseEvent(event);
            break;
        }
    }

}

void TekstiTv::numberPressed(int pressedNumber) {
    int intPageNumber = lblPageNumber->text().toInt();
    if (intPageNumber >= 100) {
        lblPageNumber->setNum(pressedNumber);
    } else {
        QString newPageNumber = QString::number(intPageNumber) + QString::number(pressedNumber);
        lblPageNumber->setText(newPageNumber);
        if (newPageNumber.toInt() >= 100) {
            page = newPageNumber.toInt();
            subPage = 1;
            site->getTekstiTv(page, subPage);
			//getTekstiTv();
        }
    }
}

void TekstiTv::changePage(int increment) {
    site->getPrediction(increment);
	//getPrediction();
}

void TekstiTv::changeSubPage(int increment) {
    site->getSubPrediction(increment);
    //getSubPrediction();
}

void TekstiTv::receivedPrediction(int newPage, int newSubPage) {
        page = newPage;
        lblPageNumber->setText(QString::number(page));
        subPage = newSubPage;
}

void TekstiTv::receivedTekstiTv(QPixmap *newImageData) {
        qDebug() << "received new image data, displaying it now!";
        imageData = newImageData;
	QPixmap scaledMap = imageData->scaled(imageWidth, imageHeight, Qt::KeepAspectRatio, Qt::SmoothTransformation);
	lblImageTekstiTv->setPixmap(scaledMap);
}

void TekstiTv::reload() {
    qDebug() << QString("reloading! %1").arg(site->imageUrl());
    site->getTekstiTv(page, subPage);
}

void TekstiTv::siteSelected(QString siteName) {
    site = sites->value(siteName);
    connect(site, SIGNAL(receivedTekstiTv(QPixmap*)), this, SLOT(receivedTekstiTv(QPixmap*)));
    connect(site, SIGNAL(receivedPrediction(int, int)), this, SLOT(receivedPrediction(int, int)));
    page = site->startPage();
    lblPageNumber->setText(QString::number(page));
    subPage = 1;
    //lblImageTekstiTv->setImage();
    //site->getTekstiTv(page, subPage);
}

void TekstiTv::resizeRequestReceived() {
    showButtons = !showButtons;
    #ifdef Q_WS_MAEMO_5
        if (!showButtons && parent->testAttribute(Qt::WA_Maemo5ForceLandscapeOrientation)) {
            screen = FullScreenOn;
            lblPageNumber->hide();
            numberGroup->hide();
            parent->showFullScreen();
            //qDebug() << "making full screen";
            QPixmap scaledMap = imageData->scaled(bigImageWidth, bigImageHeight, Qt::KeepAspectRatio, Qt::SmoothTransformation);
            //qDebug() << "full screen ready";
            lblImageTekstiTv->setPixmap(scaledMap);
        } else {
            //qDebug() << "coming out of full screen";
            screen = FullScreenOff;
            lblPageNumber->show();
            numberGroup->show();
            QPixmap scaledMap = imageData->scaled(imageWidth, imageHeight, Qt::KeepAspectRatio, Qt::SmoothTransformation);
            lblImageTekstiTv->setPixmap(scaledMap);
            parent->showNormal();
            //qDebug() << "coming out of full screen ready";
        }
    #endif
}

void TekstiTv::createFingerKeys() {
    for (int i = 0; i < 3; i++) {
        for (int j = 1; j <= 3; j++) {
          int number = (j+(i*3));
          NumberButton *nb = new NumberButton(this, number);
          nb->setParent(this);
          nb->setText(QString::number(number));
          nb->show();
          numberGrid->addWidget(nb, i, j-1);
        }
        NumberButton *nb = new NumberButton(this, 0);
        nb->setParent(this);
        nb->setText(QString::number(0));
        nb->show();
        numberGrid->addWidget(nb, 3, 0);
        //next
        QPushButton *pb = new QPushButton(this);
        pb->setText(tr("Next"));
        pb->show();
        numberGrid->addWidget(pb, 3, 1);
        QSignalMapper *sm = new QSignalMapper(this);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, 1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changePage(int)));
        //reload
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("Reload"));
        pb->show();
        numberGrid->addWidget(pb, 3, 2);
        pb->connect(pb, SIGNAL(pressed()), this, SLOT(reload()));
        //sub minus
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("< Sub"));
        pb->show();
        numberGrid->addWidget(pb, 4, 0);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, -1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changeSubPage(int)));
        //previous
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("Prev"));
        pb->show();
        numberGrid->addWidget(pb, 4, 1);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, -1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changePage(int)));
        //sub plus
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("Sub >"));
        pb->show();
        numberGrid->addWidget(pb, 4, 2);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, 1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changeSubPage(int)));
    }
}

void TekstiTv::setLandscape()
    {
#ifdef Q_WS_MAEMO_5
// ![2]
    mainLayout->setDirection(QBoxLayout::LeftToRight);
// ![2]
#endif
    }

void TekstiTv::setPortrait()
    {
#ifdef Q_WS_MAEMO_5
 // ![3]
    if (screen == FullScreenOn) {
        resizeRequestReceived();
    }
    mainLayout->setDirection(QBoxLayout::TopToBottom);
// ![3]
#endif
}

QList<QString> TekstiTv::getSiteNames() {
    //QStringList list = new QStringList();
    return sites->keys();
//    QMapIterator<QString, AbstractTekstiTv *> i(*sites);
//    int index = 0;
//    while (i.hasNext()) {
//       i.next();
//        list.append(i.key());
//   }
}

void TekstiTv::readSites() {
 sites = new QMap<QString, AbstractTekstiTv*>();
 QSettings settings("Dexter", "dexter");
 int size = settings.beginReadArray("sites");
 for (int i = 0; i < size; ++i) {
    settings.setArrayIndex(i);
    QString siteName = settings.value("siteName").toString();
    QString imageUrl = settings.value("imageUrl").toString();
    QString subImageUrl = settings.value("subImageUrl", imageUrl).toString();
    QString predictionUrl = settings.value("predictionUrl").toString();
    QString subPredictionUrl = settings.value("subPredictionUrl").toString();
    QString previousPrediction = settings.value("previousPrediction").toString();
    QString nextPrediction = settings.value("nextPrediction").toString();
    QString previousSubPrediction = settings.value("previousSubPrediction").toString();
    QString nextSubPrediction = settings.value("nextSubPrediction").toString();
    int startPage = settings.value("startPage").toInt();
    CommonTekstiTv *common = new CommonTekstiTv(imageUrl, subImageUrl, predictionUrl, subPredictionUrl,
                                                                            previousPrediction, nextPrediction,
                                                                            previousSubPrediction, nextSubPrediction, startPage);
    sites->insert(siteName, common);
    siteKeys.append(siteName);
    //site = common;  // debug just one
 }
 settings.endArray();
 //site = sites->value("Yle");
 site = sites->value(siteKeys[0]);
}

void TekstiTv::writeSites() {
    QSettings settings("Dexter", "dexter");
     settings.beginWriteArray("sites");
     //for (int i = 0; i < sites->size(); ++i) {
     QMapIterator<QString, AbstractTekstiTv *> i(*sites);
     int index = 0;
     while (i.hasNext()) {
        i.next();
        QString siteName = i.key();
        AbstractTekstiTv *tempSite = i.value();
        settings.setArrayIndex(index);
        settings.setValue("siteName", siteName);
        settings.setValue("imageUrl", tempSite->imageUrl());
        settings.setValue("subImageUrl", tempSite->subImageUrl());
        settings.setValue("predictionUrl", tempSite->predictionUrl());
        settings.setValue("subPredictionUrl", tempSite->subPredictionUrl());
        settings.setValue("previousPrediction", tempSite->previousPrediction());
        settings.setValue("nextPrediction", tempSite->nextPrediction());
        settings.setValue("previousSubPrediction", tempSite->previousSubPrediction());
        settings.setValue("nextSubPrediction", tempSite->nextSubPrediction());
        settings.setValue("startPage", tempSite->startPage());
        index++;
     }
     qDebug() << QString("Wrote %1 sites to the config").arg(index);
     settings.endArray();
}
