#ifndef TEKSTITV_H
#define TEKSTITV_H

#include <QtGui>
#include <QNetworkReply>
#include <QString>

class TekstiTv : public QWidget
{
    Q_OBJECT

    public:
        TekstiTv(QWidget *parent = 0);

    protected:
        void keyReleaseEvent ( QKeyEvent * event );

    public slots:
        void changeSubPage(int increment);
        void changePage(int increment);
        void numberPressed(int pressedNumber);
        void orientationChanged(const QString &newOrientation);

    private slots:
        void getTekstiTv();
        void getPrediction();
        void tekstiTvReceived(QNetworkReply *reply);
        void predictionReceived(QNetworkReply *reply);

    protected:
        bool event(QEvent *ev);
    private:
        void createFingerKeys();
        void addRotationAwareness();
        void setLandscape();
        void setPortrait();
    private:
        QLabel *lblPageNumber;
        QLabel *lblImageTekstiTv;

        int page;
        int subPage;
        QString *predictionStr;
        QString *nextPrediction;
        QString *previousPrediction;

        int imageWidth;
        int imageHeight;

        QWidget *central;
        QHBoxLayout *mainLayout;
        QVBoxLayout *portLayout;
        QGridLayout *numberGrid;

};

#endif // TEKSTITV_H
