#ifndef ABSTRACTTEKSTITV_H
#define ABSTRACTTEKSTITV_H

#include <QObject>
#include <QNetworkReply>

class AbstractTekstiTv : public QObject
{
    Q_OBJECT
public:
    virtual void getTekstiTv(int page, int subPage) = 0;
    virtual void getTekstiTv(QString url) = 0;
    virtual QString imageUrl() = 0;
    virtual QString subImageUrl() = 0;
    virtual QString predictionUrl() = 0;
    virtual QString subPredictionUrl() = 0;
    virtual QString nextPrediction() = 0;
    virtual QString previousPrediction() = 0;
    virtual QString nextSubPrediction() = 0;
    virtual QString previousSubPrediction() = 0;
    virtual int startPage() = 0;

public slots:

virtual void getPrediction(int increment) = 0;
virtual void getSubPrediction(int increment) = 0;

private slots:

virtual void predictionReceived(QNetworkReply *reply) = 0;
virtual void subPredictionReceived(QNetworkReply *reply) = 0;
virtual void tekstiTvReceived(QNetworkReply *reply) = 0;

signals:

void receivedTekstiTv(QPixmap *image);
void receivedPrediction(int page, int subPage);

public:

QString m_predictionStr;
QString m_nextPrediction;
QString m_previousPrediction;
QString m_nextSubPrediction;
QString m_previousSubPrediction;

int m_page;
int m_subPage;
int m_startPage;
};

#endif // ABSTRACTTEKSTITV_H
