#include "tekstitv.h"
#include "numberbutton.h"
#include "imagewidget.h"
#include <QtGui>
#include <QtNetwork>
#include <QtDebug>

#ifdef Q_WS_MAEMO_5
//#include <QtDBus>
#include <QtMaemo5>

// ![0]
//#include <mce/mode-names.h>
//#include <mce/dbus-names.h>
#endif

TekstiTv::TekstiTv(QWidget *parent) : QWidget(parent)
{
    this->parent = parent;
    //addRotationAwareness();

    screen = FullScreenOff;
    screenTilt = ScreenLandscape;

    mainLayout = new QHBoxLayout(this);
    mainLayout->setContentsMargins(1, 1, 1, 1);
    mainLayout->setSpacing(2);
    numberGrid = new QGridLayout();
    numberGrid->setContentsMargins(1, 1, 1, 1);
    numberGrid->setSpacing(2);
    numberGroup = new QGroupBox();

    //this->resize(QApplication::activeWindow().width(), QApplication::activeWindow().height());
    //this->setEnabled(true);
    //this->setStyleSheet("background: #000");
    QVBoxLayout *leftLayout = new QVBoxLayout();

    page = 100;
    subPage = 1;

    imageWidth = 510;
    imageHeight = 335;
    bigImageHeight = 480;
    bigImageWidth = 700;
    previousPrediction = new QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_01.html\">\\[Edellinen sivu\\]</A>");
    nextPrediction = new QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_01.html\">\\[Seuraava sivu\\]</A>");
    previousSubPrediction = new QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_(\\d+).html\">\\[Edellinen alasivu\\]</A>");
    nextSubPrediction = new QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_(\\d+).html\">\\[Seuraava alasivu\\]</A>");

    lblPageNumber = new QLabel(this);
    lblPageNumber->move(600,2);
    lblPageNumber->resize(100, 22);
    QFont *font = new QFont("Arial", 16, 2, false);
    lblPageNumber->setFont(*font);
    lblPageNumber->setStyleSheet("color: #00FF00; font-weight: bold");
    lblPageNumber->setNum(page);
    lblPageNumber->show();
    lblImageTekstiTv = new ImageWidget(this);
    connect(lblImageTekstiTv, SIGNAL(resizeRequest()), this, SLOT(resizeRequestReceived()));
    showButtons = true;
    //lblImageTekstiTv->move(1, 1);
    //lblImageTekstiTv->resize(588, 424);
    //mainLayout->addWidget(lblImageTekstiTv);
    leftLayout->addWidget(lblPageNumber);
    leftLayout->addWidget(lblImageTekstiTv);
    leftLayout->setAlignment(lblImageTekstiTv, Qt::AlignHCenter);
    mainLayout->addLayout(leftLayout);
    //mainLayout->addLayout(numberGrid);
    mainLayout->addWidget(numberGroup);
    numberGroup->setLayout(numberGrid);
    // finger keys for maemo
    //#ifdef Q_WS_MAEMO_5
    createFingerKeys();
    //#endif
    getTekstiTv();
    //this->setLayout(mainLayout);
}

void TekstiTv::keyReleaseEvent ( QKeyEvent * event ) {
    if (event->key() >= Qt::Key_0 && event->key() <= Qt::Key_9) {
        int pressedNumber = event->key() - 48;
        numberPressed(pressedNumber);
        return;
    }

    switch (event->key())
    {
        case Qt::Key_Left: {
                changeSubPage(-1);
                break;
            }
        case Qt::Key_Right: {
                changeSubPage(1);
                break;
            }
        case Qt::Key_Up: {
                changePage(1);
                break;
            }
        case Qt::Key_Down: {
                changePage(-1);
                break;
            }
        default: {
                QWidget::keyReleaseEvent(event);
            break;
        }
    }

}

void TekstiTv::numberPressed(int pressedNumber) {
    int intPageNumber = lblPageNumber->text().toInt();
    if (intPageNumber >= 100) {
        lblPageNumber->setNum(pressedNumber);
    } else {
        QString newPageNumber = QString::number(intPageNumber) + QString::number(pressedNumber);
        lblPageNumber->setText(newPageNumber);
        if (newPageNumber.toInt() >= 100) {
            page = newPageNumber.toInt();
            subPage = 1;
            getTekstiTv();
        }
    }
}

void TekstiTv::changePage(int increment) {
//    page = page + increment;
    if (increment > 0) { predictionStr = nextPrediction; }
    if (increment < 0) { predictionStr = previousPrediction; }
    if (page < 100) { page = 100; }
    if (page > 999) { page = 999; }
    subPage = 1;
    getPrediction();
}

void TekstiTv::changeSubPage(int increment) {
    if (increment > 0) { predictionStr = nextSubPrediction; }
    if (increment < 0) { predictionStr = previousSubPrediction; }

    //subPage = subPage + increment;

    //if (subPage > 99) { subPage = 1; }
    //if (subPage < 1) { subPage = 9; }
    //getTekstiTv();
    getSubPrediction();
}

void TekstiTv::getPrediction() {
 QNetworkAccessManager *manager = new QNetworkAccessManager(this);
 connect(manager, SIGNAL(finished(QNetworkReply*)),
         this, SLOT(predictionReceived(QNetworkReply*)));
 QString url = "http://www.yle.fi/tekstitv/txt/P" + QString::number(page) + "_01.html";
 manager->get(QNetworkRequest(QUrl(url)));
}

void TekstiTv::predictionReceived(QNetworkReply *reply) {
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    //qDebug(dataStr->toLatin1());
    //find out the next/previous page number with regular expressions from the data
    //qDebug() << *predictionStr;
    QRegExp regExp(*predictionStr);
    int pos = regExp.indexIn(*dataStr);
    //qDebug() << pos;
    if (pos > 1) {
        QString predictedPage = regExp.cap(1);
        //set lblPageNumber to that page
        page = predictedPage.toInt();
        lblPageNumber->setNum(page);
        //call getTekstiTv();
        getTekstiTv();
    }
    delete dataStr;
}

void TekstiTv::getSubPrediction() {
    QNetworkAccessManager *manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(subPredictionReceived(QNetworkReply*)));
    QString subPageStr = (subPage > 9) ? QString::number(subPage) : "0" + QString::number(subPage);
    QString url = "http://www.yle.fi/tekstitv/txt/P" + QString::number(page) + "_" + subPageStr + ".html";
    //qDebug() << url;
    manager->get(QNetworkRequest(QUrl(url)));
}

void TekstiTv::subPredictionReceived(QNetworkReply *reply) {
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    //qDebug() << *dataStr;
    //qDebug(dataStr->toLatin1());
    //find out the next/previous subpage number with regular expressions from the data
    //qDebug() << *predictionStr;
    QRegExp regExp(*predictionStr);
    int pos = regExp.indexIn(*dataStr);
    //qDebug() << pos;
    if (pos > 1) {
        QString predictedPage = regExp.cap(2);
        //qDebug() << predictedPage;
        //set lblPageNumber to that page
        //page = predictedPage.toInt();
        subPage = predictedPage.toInt();
        //qDebug() << subPage;
        if (subPage < 1) { subPage = 1; }
        //lblPageNumber->setNum(page);
        //call getTekstiTv();
        getTekstiTv();
    }
    delete dataStr;
}

void TekstiTv::resizeRequestReceived() {
    //qDebug() << QString("Resize request received!");
    showButtons = !showButtons;
    //if (parent->testAttribute(Qt::WA_Maemo5ForceLandscapeOrientation)) {
        if (!showButtons && parent->testAttribute(Qt::WA_Maemo5ForceLandscapeOrientation)) {
            screen = FullScreenOn;
            lblPageNumber->hide();
            numberGroup->hide();
            parent->showFullScreen();
            QPixmap scaledMap = imageData->scaled(bigImageWidth, bigImageHeight, Qt::KeepAspectRatio, Qt::SmoothTransformation);
            lblImageTekstiTv->setPixmap(scaledMap);
        } else {
            screen = FullScreenOff;
            lblPageNumber->show();
            numberGroup->show();
            QPixmap scaledMap = imageData->scaled(imageWidth, imageHeight, Qt::KeepAspectRatio, Qt::SmoothTransformation);
            lblImageTekstiTv->setPixmap(scaledMap);
            parent->showNormal();
        }
    //}
}

void TekstiTv::getTekstiTv() {
 QNetworkAccessManager *manager = new QNetworkAccessManager(this);
 connect(manager, SIGNAL(finished(QNetworkReply*)),
         this, SLOT(tekstiTvReceived(QNetworkReply*)));
 QString subPageStr = (subPage > 9) ? QString::number(subPage) : "0" + QString::number(subPage);
 QString url = "http://www.yle.fi/tekstitv/images/P" + QString::number(page) + "_" + subPageStr + ".gif";
 manager->get(QNetworkRequest(QUrl(url)));
}


void TekstiTv::tekstiTvReceived(QNetworkReply *reply) {
    QByteArray imgTextTv = reply->readAll();
    imageData = new QPixmap();
    bool success = imageData->loadFromData(imgTextTv);
    if (!imageData->isNull() && success) {
        QPixmap scaledMap = imageData->scaled(imageWidth, imageHeight, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        lblImageTekstiTv->setPixmap(scaledMap);
        lblImageTekstiTv->show();
    }
    //delete pixMap;
    //pixMap = 0;
}

void TekstiTv::createFingerKeys() {
    for (int i = 0; i < 3; i++) {
        for (int j = 1; j <= 3; j++) {
          int number = (j+(i*3));
          NumberButton *nb = new NumberButton(this, number);
          nb->setParent(this);
          nb->setText(QString::number(number));
          //nb->setStyleSheet("color: #00FF00");
          //nb->setText("jiihaa");
          nb->show();
          numberGrid->addWidget(nb, i, j-1);
        }
        NumberButton *nb = new NumberButton(this, 0);
        nb->setParent(this);
        nb->setText(QString::number(0));
        nb->show();
        numberGrid->addWidget(nb, 3, 0);
        //next
        QPushButton *pb = new QPushButton(this);
        pb->setText(tr("Next"));
        pb->show();
        numberGrid->addWidget(pb, 3, 1);
        QSignalMapper *sm = new QSignalMapper(this);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, 1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changePage(int)));
        //reload
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("Reload"));
        pb->show();
        numberGrid->addWidget(pb, 3, 2);
        pb->connect(pb, SIGNAL(pressed()), this, SLOT(getTekstiTv()));
        //sub minus
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("< Sub"));
        pb->show();
        numberGrid->addWidget(pb, 4, 0);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, -1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changeSubPage(int)));
        //previous
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("Prev"));
        pb->show();
        numberGrid->addWidget(pb, 4, 1);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, -1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changePage(int)));
        //sub plus
        sm = new QSignalMapper(this);
        pb = new QPushButton(this);
        pb->setText(tr("Sub >"));
        pb->show();
        numberGrid->addWidget(pb, 4, 2);
        pb->connect(pb, SIGNAL(pressed()), sm, SLOT(map()));
        sm->setMapping(pb, 1);
        sm->connect(sm, SIGNAL(mapped(int)), this, SLOT(changeSubPage(int)));
    }
}

void TekstiTv::setLandscape()
    {
#ifdef Q_WS_MAEMO_5
// ![2]
    //parent->setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    //setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    mainLayout->setDirection(QBoxLayout::LeftToRight);
    //qDebug() << QString("portrait");
// ![2]
#endif
    }

void TekstiTv::setPortrait()
    {
#ifdef Q_WS_MAEMO_5
 // ![3]
       // parent->setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, true);
        //setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, true);
    if (screen == FullScreenOn) {
        //qDebug() << QString("full screen detected - exit full screen for portrait mode");
        resizeRequestReceived();
    }
    mainLayout->setDirection(QBoxLayout::TopToBottom);
        //qDebug() << QString("landscape");
// ![3]
#endif
//void TekstiTv::addRotationAwareness() {
//#ifdef Q_WS_MAEMO_5
//    // ![1]
//            QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
//                   MCE_DEVICE_ORIENTATION_SIG,
//                   this,
//                   SLOT(orientationChanged(QString)));
//    // ![1]
//#endif
//    }

    }

//
//// ![4]
//    void TekstiTv::orientationChanged(const QString &newOrientation)
//    {
//#ifdef Q_WS_MAEMO_5
//        if (newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT)) {
//            setPortrait();
//        }
//        else {
//            setLandscape();
//        }
//        // ![4]
//#endif
//    }
//
//// ![5]
//    bool TekstiTv::event(QEvent *ev)
//    {
//    #ifdef Q_WS_MAEMO_5
//        switch (ev->type()) {
//        case QEvent::WindowActivate: {
//            QDBusConnection::systemBus().call(
//                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
//                                               MCE_REQUEST_IF,
//                                               MCE_ACCELEROMETER_ENABLE_REQ));
//            break;
//        }
//        case QEvent::WindowDeactivate:
//            QDBusConnection::systemBus().call(
//                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
//                                               MCE_REQUEST_IF,
//                                               MCE_ACCELEROMETER_DISABLE_REQ));
//            break;
//        default:
//            break;
//        }
//
//        return QWidget::event(ev);
//#endif
//    }


