#include "mainwindow.h"
#include "tekstitv.h"
#ifdef Q_WS_MAEMO_5
#include <QtDBus>
#include <QtMaemo5>

// ![0]
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#endif
MainWindow::MainWindow()
{
    setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    addRotationAwareness();
}

void MainWindow::setMainWidget(TekstiTv *main) {
    this->main = main;
}

void MainWindow::addRotationAwareness() {
#ifdef Q_WS_MAEMO_5
    // ![1]
            QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
                   MCE_DEVICE_ORIENTATION_SIG,
                   this,
                   SLOT(orientationChanged(QString)));
    // ![1]
#endif
    }

void MainWindow::setLandscape()
    {
#ifdef Q_WS_MAEMO_5
// ![2]
    setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    //TekstiTv *main = centralWidget();
    main->setLandscape();
// ![2]
#endif
    }

void MainWindow::setPortrait()
    {
#ifdef Q_WS_MAEMO_5
 // ![3]
        setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, true);
        //TekstiTv *main = centralWidget();
        main->setPortrait();
// ![3]
#endif
    }


// ![4]
    void MainWindow::orientationChanged(const QString &newOrientation)
    {
#ifdef Q_WS_MAEMO_5
        if (newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT)) {
            setPortrait();
        }
        else {
            setLandscape();
        }
        // ![4]
#endif
    }

// ![5]
    bool MainWindow::event(QEvent *ev)
    {
    #ifdef Q_WS_MAEMO_5
        switch (ev->type()) {
        case QEvent::WindowActivate: {
            QDBusConnection::systemBus().call(
                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                               MCE_REQUEST_IF,
                                               MCE_ACCELEROMETER_ENABLE_REQ));
            break;
        }
        case QEvent::WindowDeactivate:
            QDBusConnection::systemBus().call(
                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                               MCE_REQUEST_IF,
                                               MCE_ACCELEROMETER_DISABLE_REQ));
            break;
        default:
            break;
        }

        return QWidget::event(ev);
#endif
    }
