#include "mainwindow.h"
#include "tekstitv.h"
#ifdef Q_WS_MAEMO_5
#include <QtDBus>
#include <QtMaemo5>
#include <QtDebug>

// ![0]
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#endif
MainWindow::MainWindow()
{
    //switchSite.set
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    addRotationAwareness();
#endif
}

void MainWindow::setMainWidget(TekstiTv *main) {
    this->main = main;
    setupMenuBar();
}

void MainWindow::setupMenuBar() {
    menuBar = new QMenuBar(this);
    QMenu *menu = menuBar->addMenu(tr("Actions"));
    QAction *switchSite = new QAction(tr("Switch Text-TV"), this);
    connect(switchSite, SIGNAL(triggered()), this, SLOT(actionSwitchSite()));
    menu->addAction(switchSite);
}

void MainWindow::actionSwitchSite() {
    QDialog *switchDialog = new QDialog(this);
    QVBoxLayout *switchLayout = new QVBoxLayout();
    switchDialog->setLayout(switchLayout);
    QLabel *label = new QLabel();
    switchLayout->addWidget(label);
    label->setText(tr("Choose your Text-TV Site:"));
    label->show();
#ifdef Q_WS_MAEMO_5
    QMaemo5ValueButton *btnSite = new QMaemo5ValueButton(tr("Site:"));
    switchLayout->addWidget(btnSite);
    btnSite->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    QStandardItemModel *model = createModel(main->getSiteNames());
    //populateListModel(&model);
    QMaemo5ListPickSelector *selSite = new QMaemo5ListPickSelector;
    selSite->setModel(model);
    btnSite->setPickSelector(selSite);
    connect(selSite, SIGNAL(selected(QString)), main, SLOT(siteSelected(QString)));
#endif
    connect(switchDialog, SIGNAL(rejected()), main, SLOT(reload()));
    switchDialog->show();
}

#ifdef Q_WS_MAEMO_5
QStandardItemModel* MainWindow::createModel(QList<QString> options) {
    QStandardItemModel *model = new QStandardItemModel(0, 1);
    foreach(QString option, options) {
        QStandardItem *item;
        item = new QStandardItem(option);
        model->appendRow(item);
    }
    return model;
}

#endif
void MainWindow::populateListModel(QStandardItemModel *model) {
    QList<QString> list = main->getSiteNames();
    for (int i = 0; i < list.size(); i++) {
        QStandardItem *item = new QStandardItem(QString("%1").arg(list.at(i)));
        qDebug() << QString("adding site: %1").arg(list.at(i));
        item->setTextAlignment(Qt::AlignCenter); // the Maemo 5 design spec recommends this.
        item->setEditable(false); // prevent editing of the item
        model->appendRow(item);
    }
}

void MainWindow::addRotationAwareness() {
#ifdef Q_WS_MAEMO_5
    // ![1]
            QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
                   MCE_DEVICE_ORIENTATION_SIG,
                   this,
                   SLOT(orientationChanged(QString)));
    // ![1]
#endif
    }

void MainWindow::setLandscape()
    {
#ifdef Q_WS_MAEMO_5
// ![2]
    setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    //TekstiTv *main = centralWidget();
    main->setLandscape();
// ![2]
#endif
    }

void MainWindow::setPortrait()
    {
#ifdef Q_WS_MAEMO_5
 // ![3]
        setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, true);
        //TekstiTv *main = centralWidget();
        main->setPortrait();
// ![3]
#endif
    }


// ![4]
    void MainWindow::orientationChanged(const QString &newOrientation)
    {
#ifdef Q_WS_MAEMO_5
        if (newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT)) {
            setPortrait();
        }
        else {
            setLandscape();
        }
        // ![4]
#endif
    }

// ![5]
    bool MainWindow::event(QEvent *ev)
    {
    #ifdef Q_WS_MAEMO_5
        switch (ev->type()) {
        case QEvent::WindowActivate: {
            QDBusConnection::systemBus().call(
                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                               MCE_REQUEST_IF,
                                               MCE_ACCELEROMETER_ENABLE_REQ));
            break;
        }
        case QEvent::WindowDeactivate:
            QDBusConnection::systemBus().call(
                QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                               MCE_REQUEST_IF,
                                               MCE_ACCELEROMETER_DISABLE_REQ));
            break;
        default:
            break;
        }

        return QWidget::event(ev);
#endif
        return false;
    }
