#include "commontekstitv.h"
#include "tekstitvyle.h"
#include <QtNetwork>
#include <QPixmap>
#include <QObject>
#include <QtDebug>

CommonTekstiTv::CommonTekstiTv(QString imageUrl, QString predictionUrl, QString subPredictionUrl,
				QString prevPrediction, QString nextPrediction,
                                QString prevSubPrediction, QString nextSubPrediction, int pad)
{
    m_imageUrl = imageUrl;
    m_predictionUrl = predictionUrl;
    m_subPredictionUrl = subPredictionUrl;
    m_previousPrediction = prevPrediction;
    m_nextPrediction = nextPrediction;
    m_previousSubPrediction = prevSubPrediction;
    m_nextSubPrediction = nextSubPrediction;
    m_pad = pad;
    m_page = 100;
    m_subPage = 1;
}

void CommonTekstiTv::getPrediction(int increment) {
    if (increment > 0) { m_predictionStr = m_nextPrediction; }
    if (increment < 0) { m_predictionStr = m_previousPrediction; }
    m_subPage = 1;
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(predictionReceived(QNetworkReply*)));
    
     QString url = transformToRealUrl(m_predictionUrl);
	//QString url = "http://www.yle.fi/tekstitv/txt/P" + QString::number(page) + "_01.html";
    manager->get(QNetworkRequest(QUrl(url)));
}

void CommonTekstiTv::getSubPrediction(int increment) {
    if (increment > 0) { m_predictionStr = m_nextSubPrediction; }
    if (increment < 0) { m_predictionStr = m_previousSubPrediction; }
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(subPredictionReceived(QNetworkReply*)));
    //QString subPageStr = (subPage > 9) ? QString::number(subPage) : "0" + QString::number(subPage);
        QString url = transformToRealUrl(m_subPredictionUrl);
        qDebug() << url;
    //QString url = "http://www.yle.fi/tekstitv/txt/P" + QString::number(page) + "_" + subPageStr + ".html";
    manager->get(QNetworkRequest(QUrl(url)));
}

void CommonTekstiTv::predictionReceived(QNetworkReply *reply) {
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    QRegExp regExp(m_predictionStr);
    int pos = regExp.indexIn(*dataStr);
    if (pos > 1) {
        QString predictedPage = regExp.cap(1);
        m_page = predictedPage.toInt();
        emit receivedPrediction(m_page, m_subPage);
        getTekstiTv(m_page, m_subPage);
    }
    delete dataStr;
}

void CommonTekstiTv::subPredictionReceived(QNetworkReply *reply) {
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    QRegExp regExp(m_predictionStr);
    qDebug() << m_predictionStr;
    int pos = regExp.indexIn(*dataStr);
    qDebug() << pos;
    if (pos > 1) {
        QString predictedPage = regExp.cap(1);
        m_subPage = predictedPage.toInt();
        if (m_subPage < 1) { m_subPage = 1; }
        emit receivedPrediction(m_page, m_subPage);
        getTekstiTv(m_page, m_subPage);
    }
}

void CommonTekstiTv::getTekstiTv(int page, int subPage) {
    m_page = page;
    m_subPage = subPage;
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(tekstiTvReceived(QNetworkReply*)));
    //QString subPageStr = (subPage > 9) ? QString::number(subPage) : "0" + QString::number(subPage);
    //QString url = "http://www.yle.fi/tekstitv/images/P" + QString::number(page) + "_" + subPageStr + ".gif";
        QString url = transformToRealUrl(m_imageUrl);
    manager->get(QNetworkRequest(QUrl(url)));
}

void CommonTekstiTv::tekstiTvReceived(QNetworkReply *reply) {
    QByteArray imgTextTv = reply->readAll();
    m_imageData = new QPixmap();
    bool success = m_imageData->loadFromData(imgTextTv);
    qDebug() << QString("tekstitv received: %1").arg(success);
    if (!m_imageData->isNull() && success) {
        // connect to ui
        emit receivedTekstiTv(m_imageData);
    }
}


QString CommonTekstiTv::transformToRealUrl(QString url) {
    QString temp = url.replace(QString("[page]"), QString::number(m_page));
    QString subPageStr = QString("%1").arg(m_subPage, m_pad, 10, QLatin1Char('0'));
    //QString subPageStr = (m_subPage > 9) ? QString::number(m_subPage) : "0" + QString::number(m_subPage);
    temp = temp.replace(QString("[subpage]"), subPageStr);
    QString topicStr = QString("%1").arg(floor(m_page / 100) * 100);
    temp = temp.replace(QString("topicpage"), topicStr);
    qDebug() << temp;
    return temp;
}

QString CommonTekstiTv::imageUrl() {
    return m_imageUrl;
}

QString CommonTekstiTv::predictionUrl() {
    return m_predictionUrl;
}

QString CommonTekstiTv::subPredictionUrl() {
    return m_subPredictionUrl;
}

QString CommonTekstiTv::nextPrediction() {
    return m_nextPrediction;
}

QString CommonTekstiTv::previousPrediction() {
    return m_previousPrediction;
}

QString CommonTekstiTv::nextSubPrediction() {
    return m_nextSubPrediction;
}

QString CommonTekstiTv::previousSubPrediction() {
    return m_previousSubPrediction;
}

int CommonTekstiTv::pad() {
   return m_pad;
}

