/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.1
import com.nokia.meego 1.0

Page {
    id: about
    tools: ToolBarLayout {
        visible: true
        ToolIcon {
            iconId: "toolbar-back";
            onClicked: { about.close(); }
        }
    }

    signal close()

    Label {
        text: 'Demine'
        anchors.horizontalCenter: parent.horizontalCenter
        platformStyle: LabelStyle {
            fontPixelSize: 30
        }
    }
}
