/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.0

Rectangle {
    id: dialog
    anchors.fill: parent
    border.width: 1
    opacity: 0
    visible: opacity > 0

    signal closed
    signal opened

    Behavior on opacity {
        NumberAnimation { duration: 1000 }
    }

    Text {
        id: dialogText;
        anchors.centerIn: parent;
        color:  'white'
        font.pixelSize: 40
        text: ""
    }

    MouseArea {
        anchors.fill: parent;
        onClicked: forceClose();
    }

    function forceClose() {
        if(dialog.opacity == 0)
            return; //already closed
        dialog.closed();
        dialog.opacity = 0;
    }

    function show(txt) {
        dialog.opened();
        dialogText.text = txt;
        dialog.opacity = 0.5;
    }
}
