//
// compile with : 
// gcc -g -Wall `sdl-config --cflags` `sdl-config --libs` -L /usr/include/SDL -lSDL_image delite.c -o de-lite
//


#include <stdio.h>
#include <SDL.h>

SDL_Surface *tiles;
int xpos=0,ypos=0,moves=0,level,info_pos,show_info,load_level;

int map[25]={
0,0,0,0,0,
0,0,0,0,0,
0,0,0,0,0,
0,0,0,0,0,
0,0,0,0,0
}; 
int levels[1250]={
1,1,0,1,1,1,0,1,0,1,0,1,1,1,0,1,0,1,0,1,1,1,0,1,1,
0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,0,1,
1,0,0,0,1,1,1,0,1,1,0,0,1,0,0,1,0,1,0,0,1,0,1,1,0,
1,1,0,1,1,0,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,1,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,
0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,
1,1,0,1,1,1,1,0,1,1,0,0,0,0,0,1,1,0,1,1,1,1,0,1,1,
// 10
1,1,1,1,1,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,1,1,1,1,1,
1,1,1,1,1,1,0,0,0,1,1,0,0,0,1,1,0,0,0,1,1,1,1,1,1,
0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,
1,0,0,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,0,0,1,
1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,
1,0,0,0,0,0,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,
1,1,1,0,1,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,0,1,1,1,
1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,
// 20
1,1,1,1,1,1,0,0,0,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,1,1,0,0,0,1,1,
1,1,1,0,1,1,1,1,0,0,1,1,1,0,0,1,1,1,0,0,1,1,1,0,1,
1,1,1,1,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,
0,0,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,
0,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,1,1,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,0,1,1,1,1,0,0,0,1,1,0,0,0,1,1,0,1,1,
1,0,0,0,1,0,1,1,1,0,0,1,1,1,0,0,1,1,1,0,1,0,0,0,1,
1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,0,1,0,0,1,0,0,1,0,0,1,1,1,1,1,0,0,0,0,1,1,0,1,0,
// 30
0,0,0,0,1,0,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,1,1,1,1,
1,1,0,1,1,0,1,0,1,0,1,1,1,1,1,1,1,0,1,1,1,0,0,0,1,
0,1,1,0,0,0,1,1,0,1,0,1,0,0,1,1,1,0,0,0,1,1,1,1,0,
0,0,0,0,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,0,1,0,0,1,0,
1,0,1,1,1,0,0,1,0,1,0,0,0,0,0,1,1,1,1,0,1,1,0,1,0,
1,1,0,1,1,0,1,0,1,1,0,0,0,1,0,1,1,0,0,0,1,1,1,1,0,
1,1,1,1,1,0,0,0,1,0,0,1,0,1,1,1,1,1,0,1,1,0,1,0,0,
0,0,0,1,1,1,0,1,1,0,0,0,1,0,0,0,1,1,1,1,1,0,0,1,0,
0,0,0,0,1,0,0,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,0,0,
0,0,1,1,1,1,0,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,0,1,1,
// 40
0,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,
1,1,1,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,1,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,1,0,0,1,
0,0,0,0,0,0,0,0,1,0,1,1,0,1,1,0,1,1,0,0,1,1,1,1,1,
0,0,0,1,1,0,1,1,0,0,0,1,0,0,0,1,1,1,1,0,1,1,1,1,0,
0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,1,1,1,0,
0,1,0,1,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,1,1,1,0,
1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,
1,1,0,0,1,0,1,0,0,1,0,1,1,1,1,0,1,0,1,0,1,1,1,1,1,
1,1,1,1,1,0,0,1,0,0,0,1,1,0,0,0,0,1,1,0,1,1,1,0,1,
1,0,1,0,1,1,0,1,0,0,0,0,0,1,1,0,1,0,1,0,1,0,0,1,0
}; 

void drawSprite(SDL_Surface* imageSurface,SDL_Surface* screenSurface,int srcX, int srcY,int dstX, int dstY,int width, int height)
{
   SDL_Rect srcRect;
   srcRect.x = srcX;
   srcRect.y = srcY;
   srcRect.w = width;
   srcRect.h = height;

   SDL_Rect dstRect;
   dstRect.x = dstX;
   dstRect.y = dstY;
   dstRect.w = width;
   dstRect.h = height;

   SDL_BlitSurface(imageSurface, &srcRect, screenSurface, &dstRect);
}

void DrawScreen(SDL_Surface* screen)
{ 
	int x, y;
	if(SDL_MUSTLOCK(screen)) 
	{
	if(SDL_LockSurface(screen) < 0) return;
	}
	for(y = 0; y < 5; y++ ){
		for( x = 0; x < 5; x++ ) {
			drawSprite(tiles,screen,100,(map[x+(y*5)]*96)+288,(x*96)+100,y*96,96,96);
		}
 	}
	drawSprite(tiles,screen,0,0,0,0,100,480);
	drawSprite(tiles,screen,196,0,580,0,220,480);
	drawSprite(tiles,screen,100,(moves%10)*20,651,300,32,20);
	drawSprite(tiles,screen,100,((moves/10)%10)*20,651,320,32,20);
	drawSprite(tiles,screen,100,((moves/100)%10)*20,651,340,32,20);
	drawSprite(tiles,screen,100,(level%10)*20,717,300,32,20);
	drawSprite(tiles,screen,100,((level/10)%10)*20,717,320,32,20);
	drawSprite(tiles,screen,100,((level/100)%10)*20,717,340,32,20);
	if(show_info==1){
		drawSprite(tiles,screen,418,0,info_pos,0,800,480);
		if(info_pos>0) info_pos=(info_pos*3)/4;
	}
	if(show_info==2){
		drawSprite(tiles,screen,418,0,800-info_pos,0,800,480);
		if(info_pos>0) info_pos=(info_pos*3)/4;
		if(info_pos==0) show_info=0;
	}
	if(SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);

	SDL_Flip(screen); 
}


int main(int argc, char* argv[])
{
    xpos=0;
    ypos=0;
    show_info=0;
    int yp,xp,map_pos;
    moves=0;
    level=1;
	load_level=1;
	map_pos=0;
    SDL_Surface *screen;
    SDL_Event event;
    tiles = IMG_Load("/opt/de-lite/game.png");
    if ( tiles == NULL ) {
        fprintf(stderr, "Failed to load GFX.\n");
	SDL_Quit();
	return(0);
    }
    int playing = 1;

    if (SDL_Init(SDL_INIT_VIDEO) < 0 ) return 1;
   
    if (!(screen = SDL_SetVideoMode(800, 480, 16, SDL_FULLSCREEN|SDL_HWSURFACE)))
    {
        SDL_Quit();
        return 1;
    }
    SDL_ShowCursor(SDL_DISABLE);
  
    while(playing) 
    {
         DrawScreen(screen);
	if(load_level>0){
		map[map_pos]=levels[map_pos+((load_level-1)*25)];
		map_pos++;
		if (map_pos>24) load_level=0;
	}
	if(load_level==0){
		yp=0;
		for(xp=0;xp<25;xp++) yp+=map[xp];
		if(yp==0){
			if(level<50){
				level++;
				load_level=level;
				map_pos=0;
				moves=0;
			}
		}
	}
         while(SDL_PollEvent(&event)) 
         {      
              switch (event.type) 
              {
		  case SDL_MOUSEBUTTONDOWN:
			xpos=event.button.x; 
			ypos=event.button.y;
			if(show_info==0){
				if((xpos>704)&&(xpos<764)&&(ypos>218)&&(ypos<282)){
					if(level<50){
						level++;
						load_level=level;
						map_pos=0;
						moves=0;
					}
				}
				if((xpos>704)&&(xpos<764)&&(ypos>396)&&(ypos<462)){
					if(level>1){
						level--;
						load_level=level;
						map_pos=0;
						moves=0;
					}
				}
			}
			if(load_level==0){
				if(show_info==0){
					if((xpos<53)&&(ypos<112)) playing=0;
					if((xpos>610)&&(xpos<696)&&(ypos<195)){
						load_level=level;
						map_pos=0;
						moves=0;
					}
					if((xpos>696)&&(ypos<195)){
						show_info=1;
						info_pos=800;				
					}
					if((xpos>99)&&(xpos<580)){
						xp=((xpos-100)/96)%5;
						yp=(ypos/96)%5;
					     	map[xp+(yp*5)]=(map[xp+(yp*5)]+1)&1;
						if((xp-1)>=0) map[(xp-1)+(yp*5)]=(map[(xp-1)+(yp*5)]+1)&1;
					     	if((xp+1)<5) map[(xp+1)+(yp*5)]=(map[(xp+1)+(yp*5)]+1)&1;
					     	if((yp-1)>=0) map[xp+((yp-1)*5)]=(map[xp+((yp-1)*5)]+1)&1;
					     	if((yp+1)<5) map[xp+((yp+1)*5)]=(map[xp+((yp+1)*5)]+1)&1;
						moves++;
					}
				}else if(show_info==1){
					if(xpos<800){
						show_info=2;
						info_pos=800;				
					}
				}
			}
              }
         }
	if((show_info==0) && (load_level==0)) SDL_Delay(150);
    }

    SDL_Quit();
  
    return 0;
}




