import gtk
import gtk.glade
import hildon
import gobject

import csv
import os
import commands

XREFPATH = "/usr/lib/dbus-switchboard/dbus-switch-xref.cfg"
HANDLERPATH = "/usr/lib/dbus-switchboard/dbus-switch-apps.cfg"
#DEFAULTSPATH = "/home/user/defaults.list"
DEFAULTSPATH = "/usr/share/applications/defaults.list"
##URIDEFAULTSPATH = "/home/user/uri-action-defaults.list"
URIDEFAULTSPATH = "/usr/share/applications/uri-action-defaults.list"
DESKTOPFILE = "hildon-dbus-switchboard.desktop"

class dbus_switchboard_gui (hildon.Program):
    def __init__(self):
        hildon.Program.__init__(self)
        gtk.set_application_name("")
        self.window_in_fullscreen=False
        self.window = hildon.Window()
        self.window.set_title("Dbus Switchboard")
        self.window.connect('delete-event', self.on_quit)
        self.window.connect("key-press-event", self.on_key_press)
        self.add_window(self.window)
        self.gladefile = "/usr/lib/dbus-switchboard/switchboard_gui.glade"
##        self.gladefile = "switchboard_gui.glade"
        self.xrefs = {}
        self.handlers = {}
        self.protocols = {}
        self.defaults = {}
        self.uridefaults = {}
    def run(self):
        self.wTree = gtk.glade.XML(self.gladefile)
        self.wTree.get_widget("mainContainer").reparent(self.window)
        self.wTree.get_widget("window1").destroy()
        self.scroll_tree = self.wTree.get_widget("scroll_tree")
        self.label_mode = self.wTree.get_widget("label_mode")
        cell = gtk.CellRendererText()
        cell_shade = gtk.CellRendererText()
        cell_shade.set_property('cell-background', 'green')
        extColumn = gtk.TreeViewColumn('ext', cell, text=0)
        appColumn = gtk.TreeViewColumn('application', cell, text=1)
        urlColumn = gtk.TreeViewColumn('ext', cell, text=0)
        url_appColumn = gtk.TreeViewColumn('application', cell, text=1)
        nameColumn = gtk.TreeViewColumn('application', cell, text=0)
        commandColumn = gtk.TreeViewColumn('command', cell, text=1)
        mimeColumn = gtk.TreeViewColumn('mime type', cell_shade, text=0, cell_background_set=2)
        openwithColumn = gtk.TreeViewColumn('Open With...', cell_shade, text=1, cell_background_set=2)
        uri_mimeColumn = gtk.TreeViewColumn('mime type', cell_shade, text=0, cell_background_set=2)
        uri_openwithColumn = gtk.TreeViewColumn('Open With...', cell_shade, text=1, cell_background_set=2)
        self.tree_xref = self.new_treeview()
        self.tree_url = self.new_treeview()
        self.tree_handlers = self.new_treeview()
        self.tree_defaults = self.new_treeview()
        self.tree_uri_defaults = gtk.TreeView()
        self.tree_xref.append_column(extColumn)
        self.tree_xref.append_column(appColumn)
        self.tree_xref.connect("row-activated", self.on_xref_activated)
        self.tree_url.append_column(urlColumn)
        self.tree_url.append_column(url_appColumn)
        self.tree_url.connect("row-activated", self.on_xref_activated)
        self.tree_handlers.append_column(nameColumn)
        self.tree_handlers.append_column(commandColumn)
        self.tree_handlers.connect("row-activated", self.on_handler_activated)
        self.tree_defaults.append_column(mimeColumn)
        self.tree_defaults.append_column(openwithColumn)
        self.tree_defaults.connect("row-activated", self.on_defaults_activated)
        self.tree_uri_defaults.append_column(uri_mimeColumn)
        self.tree_uri_defaults.append_column(uri_openwithColumn)
        self.tree_uri_defaults.connect("row-activated", self.on_uri_defaults_activated)
        self.wTree.get_widget("xref_OK").connect("clicked", self.on_OK_clicked)
        self.wTree.get_widget("xref_cancel").connect("clicked", self.on_OK_clicked)
        self.wTree.get_widget("url_OK").connect("clicked", self.on_OK_clicked)
        self.wTree.get_widget("url_cancel").connect("clicked", self.on_OK_clicked)
        self.wTree.get_widget("handler_OK").connect("clicked", self.on_OK_clicked)
        self.wTree.get_widget("handler_cancel").connect("clicked", self.on_OK_clicked)
        self.wTree.get_widget("b_new").connect("clicked", self.on_new)
        self.wTree.get_widget("b_edit").connect("clicked", self.on_edit)
        self.wTree.get_widget("b_xref").connect("clicked", self.on_xref)
        self.wTree.get_widget("b_url").connect("clicked", self.on_url)
        self.wTree.get_widget("b_handlers").connect("clicked", self.on_handlers)
        self.wTree.get_widget("b_defaults").connect("clicked", self.on_defaults)
        self.wTree.get_widget("b_uri_defaults").connect("clicked", self.on_uri_defaults)
        self.wTree.get_widget("menu_newxref").connect("activate", self.on_new_xref)
        self.wTree.get_widget("menu_newurl").connect("activate", self.on_new_url)
        self.wTree.get_widget("menu_newhandler").connect("activate", self.on_new_handler)
        self.wTree.get_widget("menu_about").connect("activate", self.on_about)
        self.wTree.get_widget("menu_delete").connect("activate", self.on_delete)
        self.wTree.get_widget("menu_save").connect("activate", self.on_save)
        self.wTree.get_widget("menu_quit").connect("activate", self.on_quit)
        hildon.hildon_helper_set_thumb_scrollbar(self.scroll_tree, True)
        self.main_menu = self.wTree.get_widget("menu1")
        self.set_common_menu(self.main_menu)
        self.read_xref()
        self.read_handlers()
        self.load_defaults()
        self.load_uri_defaults()
        self.window.show_all()
        self.mode = "xref"
        self.close_dialog = None
        self.saved = True
        self.mode_functions = {
            "xref" : (self.pack_xrefs, self.tree_xref, self.new_xref, self.edit_xref, self.xrefs),
            "url" : (self.pack_urls, self.tree_url, self.new_url, self.edit_url, self.protocols),
            "handlers" : (self.pack_handlers, self.tree_handlers, self.new_handler, self.edit_handler, self.handlers),
            "defaults" : (self.pack_defaults, self.tree_defaults, self.new_default, self.edit_default, self.defaults),
            "uri_defaults" : (self.pack_uri_defaults, self.tree_uri_defaults, self.new_uri_default, self.edit_uri_default, self.uri_defaults),
            None : None,
            }
        self.scroll_tree.add(self.mode_functions[self.mode][1])
        self.pack_handlers()
        self.pack_view()
        gtk.main()
    def new_treeview(self):
        tree = gtk.TreeView()
        tree.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_HORIZONTAL)
#        tree.set_headers_visable(True)
        return tree
    def pack_view(self):
        self.mode_functions[self.mode][0]()
        self.label_mode.set_text(self.mode.upper())
    def on_quit(self, widget, data=None):
        if not self.saved:
            confirm = hildon.Note("confirmation", (self.window, "Do you want to save the settings?", gtk.STOCK_DIALOG_WARNING))
            confirm.set_button_texts("Yes", "No")
            print "**confirm save**"
            response = confirm.run()
            print response
            confirm.destroy()
            if response == gtk.RESPONSE_OK:
                self.on_save(None)
        gtk.main_quit()
#        return True
    def on_key_press(self, widget, event, *args):
        if event.keyval == gtk.keysyms.F6:
            if self.window_in_fullscreen:
               self.window.unfullscreen ()
               self.window_in_fullscreen=False
            else:
               self.window_in_fullscreen=True
               self.window.fullscreen ()
    def on_OK_clicked(self, widget):
        self.close_dialog()
    def on_new_xref(self, widget):
        self.new_xref()
    def on_new_url(self, widget):
        self.new_xref()
    def on_new_handler(self, widget):
        self.new_handler()
    def on_save(self, widget):
        self.write_xrefs()
        self.write_handlers()
        self.write_defaults()
        # qole fix: write URIs
        self.write_uri_defaults()
        print "**saved**"
        self.saved = True
    def read_xref(self):
        print "**load xrefs**"
        if os.path.exists(XREFPATH):
            print "**xref file found**"
            rdr_xref = csv.reader(open(XREFPATH, "rb"))
            for row_xref in rdr_xref:
                if row_xref[2] == "":
                    self.xrefs[row_xref[0]]=row_xref[1]
                else:
                    self.protocols[row_xref[2]] = [row_xref[0], row_xref[1]]
    def pack_xrefs(self):
        print "**pack xrefs**"
        self.wTree.get_widget("b_new").set_sensitive(True)
        self.xref_tree_model = gtk.ListStore(str, str)
        for ref in self.xrefs:
            self.xref_tree_model.append(row=[ref, self.xrefs[ref]])
        self.xrefs_sm = gtk.TreeModelSort(self.xref_tree_model)
        self.xrefs_sm.set_sort_column_id(0, gtk.SORT_ASCENDING)
        self.tree_xref.set_model(self.xrefs_sm)
        self.tree_xref.show_all()
    def pack_urls(self):
        print "**pack urls**"
        self.wTree.get_widget("b_new").set_sensitive(True)
        self.url_tree_model = gtk.ListStore(str, str)
        for ref in self.protocols:
            self.url_tree_model.append(row=[ref, self.protocols[ref][1]])
        self.urls_sm = gtk.TreeModelSort(self.url_tree_model)
        self.urls_sm.set_sort_column_id(0, gtk.SORT_ASCENDING)
        self.tree_url.set_model(self.urls_sm)
        self.tree_url.show_all()
    def write_xrefs(self):
        rows = []
        for ref in self.xrefs:
            rows.append((ref, self.xrefs[ref], ""))
        for ref in self.protocols:
            rows.append((self.protocols[ref][0], self.protocols[ref][1], ref))
        if os.path.exists(XREFPATH):
            wtr = csv.writer(open(XREFPATH, "wb"))
            wtr.writerows(rows)
    def insert_xref(self, extension, handler, protocol=""):
        print "extension:" + extension + " handler:" + handler + " protocol:" + protocol
        if protocol == "":
            self.xrefs[extension] = handler
            self.pack_xrefs()
        else:
            self.protocols[protocol] = [extension, handler]
            self.pack_urls()
    def new_xref(self):
        print "**new xref**"
        self.edit_xref(None)
    def edit_xref(self, name):
#        self.saved = False
        print "**edit xref**"
        print self.mode
        dialog = self.wTree.get_widget("dialog_xref")
        self.close_dialog = dialog.hide_all
        extension_entry = self.wTree.get_widget("xref_extension")
        extension_entry.set_sensitive(True)
        if self.mode == "xref":
            extension_entry.set_text("[extension]")
        else:
            extension_entry.set_text("[protocol]")
        handler_combo = self.wTree.get_widget("xref_handlers")
        if name != None:
            extension_entry.set_text(name)
            extension_entry.set_sensitive(False)
            if self.mode == "xref":
                self.wTree.get_widget("l_xref_current").set_text(self.xrefs[name])
                handler_combo.child.set_text(self.xrefs[name])
                for row in self.handlers_sm:
                    if row[0] == self.xrefs[name]:
                        handler_combo.set_active_iter(row.iter)
            elif self.mode == "url":
                self.wTree.get_widget("l_xref_current").set_text(self.protocols[name][1])
                handler_combo.child.set_text(self.protocols[name][1])
                for row in self.handlers_sm:
                    if row[0] == self.protocols[name][1]:
                        handler_combo.set_active_iter(row.iter)
            extension_entry.set_text(name)
        cell = gtk.CellRendererText()
        handler_combo.pack_start(cell, True)
        handler_combo.set_model(self.handlers_sm)
        dialog.set_modal(False)
        dialog.show_all()
        response = dialog.run()
        if response == 1:
            print "**cancel xref**"
        elif response == 2:
            pass
        else:
            self.saved = False
            if name == None:
                print "**new xref**"
                print extension_entry.get_text()
#                print self.xrefs
                if extension_entry.get_text() in self.xrefs:
                    confirm = hildon.Note("confirmation", (self.window, "Do you want to overwrite existing xref?", gtk.STOCK_DIALOG_WARNING))
                    confirm.set_button_texts("Yes", "No")
                    print "**confirm overwrite**"
                    response = confirm.run()
                    print response
                    print extension_entry.get_text()
                    confirm.destroy()
                    if response == gtk.RESPONSE_OK:
                        if self.mode == "xref":
                            self.insert_xref(extension_entry.get_text(), handler_combo.get_model().get_value(handler_combo.get_active_iter(), 0))
                        elif self.mode == "url":
                            self.insert_xref("", handler_combo.get_model().get_value(handler_combo.get_active_iter(), 0), protocol=extension_entry.get_text())
                else:
                    "**defining new**"
                    if self.mode == "xref":
                        self.insert_xref(extension_entry.get_text(), handler_combo.get_model().get_value(handler_combo.get_active_iter(), 0))
                    elif self.mode == "url":
                        self.insert_xref("", handler_combo.get_model().get_value(handler_combo.get_active_iter(), 0), protocol=extension_entry.get_text())
            else:
                "**old xref**"
                if self.mode == "xref":
                    self.insert_xref(extension_entry.get_text(), handler_combo.get_model().get_value(handler_combo.get_active_iter(), 0))
                elif self.mode == "url":
                    self.insert_xref("", handler_combo.get_model().get_value(handler_combo.get_active_iter(), 0), protocol=extension_entry.get_text())
#        print self.xrefs
    def on_xref_activated(self, widget, path, view_column):
        i = widget.get_model().get_iter(path)
        name = widget.get_model().get_value(i, 0)
        self.edit_xref(name)
    def new_url(self):
        self.new_xref()
    def edit_url(self, name):
        self.edit_xref(name)
    def read_handlers(self):
        print "**load handlers**"
        if os.path.exists(HANDLERPATH):
            print "**handlers file found**"
            rdr_handler = csv.reader(open(HANDLERPATH, "rb"))
            for row_handler in rdr_handler:
##                print row_handler[0]
                self.handlers[row_handler[0]] = [row_handler[1], row_handler[2]]
    def pack_handlers(self):
        print "**pack handlers**"
        self.wTree.get_widget("b_new").set_sensitive(True)
        self.handlers_tree_model = gtk.ListStore(str, str)
        for ref in self.handlers:
##            print ref
##            print self.handlers[ref]
            self.handlers_tree_model.append(row=[ref, self.handlers[ref][1]])
        self.handlers_sm = gtk.TreeModelSort(self.handlers_tree_model)
        self.handlers_sm.set_sort_column_id(0, gtk.SORT_ASCENDING)
        self.tree_handlers.set_model(self.handlers_sm)
##        self.wTree.get_widget("tree_handlers").set_model(self.handlers_tree_model)
        self.tree_handlers.show_all()
    def write_handlers(self):
        rows = []
        for ref in self.handlers:
            rows.append((ref, self.handlers[ref][0], self.handlers[ref][1]))
        if os.path.exists(HANDLERPATH):
            wtr = csv.writer(open(HANDLERPATH, "wb"))
            wtr.writerows(rows)
    def insert_handler(self, name, command, interface="cli"):
        self.handlers[name] = [interface, command]
##        print self.handlers
        self.pack_handlers()
    def new_handler(self):
        self.edit_handler(None)
    def edit_handler(self, name):
#        self.saved = False
        print "**edit handler**"
        dialog = self.wTree.get_widget("dialog_handler")
        self.close_dialog = dialog.hide_all
        name_entry = self.wTree.get_widget("handler_name")
        name_entry.set_sensitive(True)
        command_entry = self.wTree.get_widget("handler_command")
        if name != None:
            name_entry.set_text(name)
            name_entry.set_sensitive(False)
            command_entry.set_text(self.handlers[name][1])
        dialog.set_modal(False)
        dialog.show_all()
        response = dialog.run()
        if response == 1:
            print "**cancel handler**"
        elif response == 2:
            pass
        else:
            self.saved = False
            interface = "cli"
            if name == None:
                print "**new handler**"
                if name_entry.get_text() in self.handlers:
                    confirm = hildon.Note("confirmation", (self.window, "Do you want to overwrite existing handler?", gtk.STOCK_DIALOG_WARNING))
                    confirm.set_button_texts("Yes", "No")
                    print "**confirm overwrite**"
                    response = confirm.run()
                    print response
                    confirm.destroy()
                    if response == gtk.RESPONSE_OK:
                        self.insert_handler(name_entry.get_text(), command_entry.get_text(), interface)
                else:
                    self.insert_handler(name_entry.get_text(), command_entry.get_text(), interface)
            else:
                self.insert_handler(name_entry.get_text(), command_entry.get_text(), interface)
    def on_handler_activated(self, widget, path, view_column):
        i = widget.get_model().get_iter(path)
        name = widget.get_model().get_value(i, 0)
        self.edit_handler(name)
    def load_defaults(self):
        print "**Load Defaults**"
        print '@ ' + DEFAULTSPATH
        self.defaults = {}
#        self.defaults_liststore = gtk.ListStore(str, str, bool)
        fp = open(DEFAULTSPATH)
        for line in fp:
            if line.startswith('#'):
                continue
            elif line == "":
                continue
            elif '=' not in line:
                continue
            key = line.split('=')[0]
            val = line.split('=')[1].strip()
            self.defaults[key] = val
#            print key + ' : ' + val
        if "application/octet-stream" not in self.defaults:
            self.defaults["application/octet-stream"] = DESKTOPFILE
        self.defaults_base = {}

#        fp = open(DEFAULTSPATH+'~')
#       Pipeline mod to use backup of orig defaults files
        fp = open("/usr/lib/python2.5/site-packages/dbus_switchboard_gui/defaults.orig")

        for line in fp:
            if line.startswith('#'):
                continue
            elif line == "":
                continue
            elif '=' not in line:
                continue
            key = line.split('=')[0]
            val = line.split('=')[1].strip()
            self.defaults_base[key] = val
#        self.defaults_working = dct
    def write_defaults(self):
        fp = open('/tmp/dbsw_defaults.list', 'w')
        fp.flush()

        # Pipeline fix to add section header
        fp.write("[Default Applications]\n")

        for key in self.defaults:
            s = key + '=' + self.defaults[key] + '\n'
            fp.write(s)
        fp.close()

#       Pipeline mod to use backup of orig uri defaults files
#        print commands.getoutput('sudo cp /tmp/dbsw_defaults.list ' + DEFAULTSPATH)
        print commands.getoutput('cp /tmp/dbsw_defaults.list ' + DEFAULTSPATH)

    def pack_defaults(self):
        self.default_store = gtk.ListStore(str, str, bool)
        self.wTree.get_widget("b_new").set_sensitive(False)
        for key in self.defaults:
            b = False
            if self.defaults[key] == DESKTOPFILE:
                b = True
            s = self.defaults[key]
            if s == "":
                s == "None"
            self.default_store.append(row=[key, s, b])
        self.defaults_liststore = gtk.TreeModelSort(self.default_store)
        self.defaults_liststore.set_sort_column_id(0, gtk.SORT_ASCENDING)
        self.tree_defaults.set_model(self.defaults_liststore)
#        self.tree_defaults.show_all()
    def on_defaults_activated(self, widget, path, view_column):
        print '**defaluts activated**'
        self.saved = False
        model = widget.get_model().get_model()
        ch_path = widget.get_model().convert_path_to_child_path(path)
        i = model.get_iter(ch_path)
        name = model.get_value(i, 0)
        if self.defaults[name] != DESKTOPFILE:
            print "**setting " + name + " to " + DESKTOPFILE
            self.defaults[name] = DESKTOPFILE
            model.set_value(i, 1, DESKTOPFILE)
            model.set_value(i, 2, True)
        elif name in self.defaults_base.keys():
            print "**setting " + name + " to " + self.defaults_base[name] + "**"
            self.defaults[name] = self.defaults_base[name]
            model.set_value(i, 1, self.defaults_base[name])
            model.set_value(i, 2, False)
        else:
            print "**setting " + name + " to None**"
            self.defaults[name] = ""
            model.set_value(i, 1, "None")
            model.set_value(i, 2, False)
        widget.get_selection().unselect_path(path)
#        self.pack_defaults()
    def new_default(self):
        pass
    def edit_default(self, name):
        widget = self.tree_defaults
        i = widget.get_selection().get_selected()[1]
        path = widget.get_model().get_path(i)
        view_column = 0
        self.on_defaults_activated(widget, path, view_column)
    def load_uri_defaults(self):
        print "**Load Uri Defaults**"
        print '@ ' + URIDEFAULTSPATH

        self.uri_defaults = {}
        fp = open(URIDEFAULTSPATH)

        for line in fp:
            if line.startswith('#'):
                continue
            elif line == "":
                continue
            elif '=' not in line:
                continue
            key = line.split('=')[0]
            val = line.split('=')[1].strip()
            self.uri_defaults[key] = val
#            print key + ' : ' + val
        self.uri_defaults_base = {}

#       Pipeline mod to use backup of orig uri defaults files
#        fp = open(URIDEFAULTSPATH+'~')
        fp = open("/usr/lib/python2.5/site-packages/dbus_switchboard_gui/uri-action-defaults.orig")

        for line in fp:
            if line.startswith('#'):
                continue
            elif line == "":
                continue
            elif '=' not in line:
                continue
            key = line.split('=')[0]
            val = line.split('=')[1].strip()
            self.uri_defaults_base[key] = val

    def write_uri_defaults(self):
        fp = open('/tmp/dbsw_uri-defaults.list', 'w')
        fp.flush()

# qole mod: write out original file, substitute keys where necessary

#       qole mod to make this work: read the file into a list.

        fp2 = open(URIDEFAULTSPATH)
        self.uri_defaults_file = []
        for line in fp2:
          self.uri_defaults_file.append(line)
        fp2.close()


# write the file back out unchanged, except the key pairs

        for line in self.uri_defaults_file:

           if '=' in line:
             key = line.split('=')[0]
             line = key + '=' + self.uri_defaults[key] + '\n'

           fp.write(line)

        fp.close()

# Pipeline un-sudo since app aleady sudo'ed
#        print commands.getoutput('sudo cp /tmp/dbsw_uri-defaults.list ' + URIDEFAULTSPATH)
        print commands.getoutput('cp /tmp/dbsw_uri-defaults.list ' + URIDEFAULTSPATH)
    def pack_uri_defaults(self):
        self.uri_default_store = gtk.ListStore(str, str, bool)
        self.wTree.get_widget("b_new").set_sensitive(False)
        for key in self.uri_defaults:
            b = False
            if self.uri_defaults[key] == 'hildon-dbus-switchboard.desktop':
                b = True
            s = self.uri_defaults[key]
            if s == "":
                s = "None"
            self.uri_default_store.append(row=[key, s, b])
        self.uri_defaults_liststore = gtk.TreeModelSort(self.uri_default_store)
        self.uri_defaults_liststore.set_sort_column_id(0, gtk.SORT_ASCENDING)
        self.tree_uri_defaults.set_model(self.uri_defaults_liststore)
        self.tree_uri_defaults.show_all()
    def on_uri_defaults_activated(self, widget, path, view_column):
        print '**uri defaluts activated**'
        self.saved = False
        model = widget.get_model().get_model()
        ch_path = widget.get_model().convert_path_to_child_path(path)
        i = model.get_iter(ch_path)
        name = model.get_value(i, 0)
        if self.uri_defaults[name] != DESKTOPFILE:
            print "**setting " + name + " to " + DESKTOPFILE
            self.uri_defaults[name] = DESKTOPFILE
            model.set_value(i, 1, DESKTOPFILE)
            model.set_value(i, 2, True)
        elif name in self.uri_defaults_base.keys():
            print "**setting " + name + " to " + self.uri_defaults_base[name] + "**"
            self.uri_defaults[name] = self.uri_defaults_base[name]
            model.set_value(i, 1, self.uri_defaults_base[name])
            model.set_value(i, 2, False)
        else:
            print "**setting " + name + " to None**"
            self.uri_defaults[name] = ""
            model.set_value(i, 1, "None")
            model.set_value(i, 2, False)
        widget.get_selection().unselect_path(path)
##        self.pack_uri_defaults()
    def new_uri_default(self):
        pass
    def edit_uri_default(self, name):
        widget = self.tree_uri_defaults
        i = widget.get_selection().get_selected()[1]
        path = widget.get_model().get_path(i)
        view_column = 0
        self.on_uri_defaults_activated(widget, path, view_column)
    def on_xref(self, widget):
        self.scroll_tree.remove(self.mode_functions[self.mode][1])
        self.mode = "xref"
        self.scroll_tree.add(self.mode_functions[self.mode][1])
        self.pack_view()
    def on_url(self, widget):
        self.scroll_tree.remove(self.mode_functions[self.mode][1])
        self.mode = "url"
        self.scroll_tree.add(self.mode_functions[self.mode][1])
        self.pack_view()
    def on_handlers(self, widget):
        self.scroll_tree.remove(self.mode_functions[self.mode][1])
        self.mode = "handlers"
        self.scroll_tree.add(self.mode_functions[self.mode][1])
        self.pack_view()
    def on_defaults(self, widget):
        self.scroll_tree.remove(self.mode_functions[self.mode][1])
        self.mode = "defaults"
        self.scroll_tree.add(self.mode_functions[self.mode][1])
        self.scroll_tree.show_all()
        self.pack_view()
    def on_uri_defaults(self, widget):
        self.scroll_tree.remove(self.mode_functions[self.mode][1])
        self.mode = "uri_defaults"
        self.scroll_tree.add(self.mode_functions[self.mode][1])
        self.pack_view()
    def on_new(self, widget):
        self.mode_functions[self.mode][2]()
    def on_edit(self, widget):
        data = self.mode_functions[self.mode][1].get_selection().get_selected()
        if type(data[1]) is gtk.TreeIter:
            name = data[0].get_value(data[1], 0)
            print "**Editing " + name + "**"
            self.mode_functions[self.mode][3](name)
    def on_delete(self, widget):
        data = self.mode_functions[self.mode][1].get_selection().get_selected()
        if type(data[1]) is gtk.TreeIter:
            name = data[0].get_value(data[1], 0)
            confirm = hildon.Note("confirmation", (self.window, "Are you sure you want to delete " + name + "?", gtk.STOCK_DIALOG_WARNING))
            confirm.set_button_texts("Yes", "No")
            print "**delete**"
            response = confirm.run()
            print response
            confirm.destroy()
            if response == gtk.RESPONSE_OK:
                self.saved = False
                self.mode_functions[self.mode][4].pop(name)
                self.pack_view()
    def on_about(self, widget):
        pass

if __name__ == "__main__":
    app = dbus_switchboard_gui()
    app.run()
